# determine tax rate 
# currently used in website code by CC , MCP and AKB
namespace eval tax {

variable tax_codes
array set tax_codes {}

# return the current gst rate (percentage). Specify the tax code if it isn't 'GST'
# throws an error if the tax code is not in the database
proc gst_rate { {date ""} {GSTcode "GST"} } {
	variable tax_codes

	# load the tax_code from the database?
	if { [array names tax_codes $GSTcode,*] == {} } {
		if { ![load_tax_code $GSTcode] } {
			error "Invalid GST code: \"$GSTcode\""
		}
	}

	# default to todays date
	if {$date == ""} {
		set seconds [clock seconds]
		set year [clock format $seconds -format "%Y"]
		set month [clock format $seconds -format "%m"]
		set day [clock format $seconds -format "%d"]
		set date [format "%s-%s-%s" $year $month $day]
	} else {
		# only use the first 10 characters of the date, i.e. YYYY-MM-DD
		set date [string range $date 0 9]
	}

	# calcualate the effective GST rate, default is 0%:
	set GSTrate 0
	for {set i 1} { $i <= 5} {incr i} {
	
		# if this GST date is blank or in the future, return the last rate
		set GSTdate $tax_codes($GSTcode,DATE$i)
		
		if { $GSTdate == "" || $GSTdate == "0000-00-00" || $GSTdate > $date } {
			return $GSTrate
		}
		
		set GSTrate $tax_codes($GSTcode,RATE$i)
	}

	# if we exited the above loop without returning, the fifth rate is the one we want:
	return $tax_codes($GSTcode,RATE5)
}

# load the tax code dates and rates from the database
# return 1 if loaded, 0 otherwise
proc load_tax_code { code } {
	variable tax_codes

	set query "
		select 	DATE1, DATE2, DATE3, DATE4, DATE5, 
				RATE1, RATE2, RATE3, RATE4, RATE5
		from TAX_CODE
		where CODE = '$code'
	"

	set result [sql $query]
	if { $result == {} } { return 0 }

	set row [lindex $result 0]

	# only store the first 10 characters of the date, i.e. YYYY-MM-DD
	set tax_codes($code,DATE1) [string range [lindex $row 0] 0 9]
	set tax_codes($code,DATE2) [string range [lindex $row 1] 0 9]
	set tax_codes($code,DATE3) [string range [lindex $row 2] 0 9]
	set tax_codes($code,DATE4) [string range [lindex $row 3] 0 9]
	set tax_codes($code,DATE5) [string range [lindex $row 4] 0 9]
	set tax_codes($code,RATE1) [lindex $row 5]
	set tax_codes($code,RATE2) [lindex $row 6]
	set tax_codes($code,RATE3) [lindex $row 7]
	set tax_codes($code,RATE4) [lindex $row 8]
	set tax_codes($code,RATE5) [lindex $row 9]

	return 1
}

}
