
# Database schema, list of all tables used in Fastbase
# See also schema_column.tcl (auto-generated)
# This file is manually edited, when new tables are added

# Manual/auto check if the column order here matches column order in schema ...
# Manual/auto check if this is actually the primary key ...
# Default cache timeout per table ...

namespace eval schema {

# Default key per table, usually the primary key
# These are taken from sql.tcl and may not be accurate
# Compare with Null and Key columns in "show columns"

set key_columns(ADDITIONAL_CHARGE)			{COMPANY_ID REF_NO ACCOUNT INVOICE_NO SEQUENCE}
set key_columns(ALTERNATE_PARTS)			{COMPANY_ID PART ALTERNATE_PART}
set key_columns(ALTERNATE_SUPPLIERS)		{COMPANY_ID PART SUPPLIER}
set key_columns(AREA)						{COMPANY_ID AREA_CODE}
set key_columns(AREA_BUDGETS)				{COMPANY_ID AREA_CODE YEAR}
set key_columns(ASSET_SCHEDULE)				{COMPANY_ID CODE}
set key_columns(ASSET_VALUE)				{COMPANY_ID ASSET}
set key_columns(AS_MODULE)					{COMPANY_ID MODULE}
set key_columns(AUTOMOTIVE_MAKE)			{ID}
set key_columns(AUTOMOTIVE_MODEL)			{ID}
set key_columns(BALANCE)					{COMPANY_ID MODULE ACCOUNT YEAR BRANCH}
set key_columns(BANK_STATEMENT)				{COMPANY_ID ACCOUNT PAGE_NO}
set key_columns(BANK_STATEMENT_DETAIL)		{COMPANY_ID ACCOUNT PAGE_NO REF_NO BATCH_NO REFERENCE}
set key_columns(BATCH)						{COMPANY_ID BATCH_NO}
set key_columns(BRANCH)						{COMPANY_ID BRANCH_ID}
set key_columns(BRANCH_BUDGETS)				{COMPANY_ID BRANCH_ID YEAR}
set key_columns(CALL_CYCLE)					{COMPANY_ID CYCLE}
set key_columns(CODE_BUDGETS)				{COMPANY_ID MODULE CODE YEAR}	
set key_columns(CODE_DATA)					{COMPANY_ID MODULE NUMBER HEADING_ID}
set key_columns(CODE_HEADING)				{ID}
set key_columns(COMPANY)					{COMPANY_ID}
set key_columns(COMPONENTS)					{COMPANY_ID PART COMPONENT}
set key_columns(CONTACT_ROLE)				{COMPANY_ID MODULE ID}
set key_columns(COURIER)					{COMPANY_ID CODE}
set key_columns(COURIER_CONTROL)			{COMPANY_ID TYPE BRANCH}
set key_columns(COURIER_DESTINATION)		{COMPANY_ID TYPE BRANCH DESTINATION}
set key_columns(COURIER_PRODUCT)			{COMPANY_ID TYPE CODE}
set key_columns(COURIER_SERVICE)			{ID}
set key_columns(COURIER_TICKET_STATUS)		{COMPANY_ID TYPE STATUS}
set key_columns(CURRENCY)					{BALANCE_CURRENCY CODE}
set key_columns(CURRENCY_RATES)				{BALANCE_CURRENCY CODE DATE}
set key_columns(CUSTOMER_ADDRESS)			{ID}
set key_columns(CUSTOMER_CATEGORIES)		{ID}
set key_columns(CUSTOMER_DISCOUNT)			{COMPANY_ID CUSTOMER PART}
set key_columns(CUSTOMER_DISCOUNT2)			{COMPANY_ID CUSTOMER TYPE CODE}
set key_columns(CUSTOMER_EXTRAS)			{COMPANY_ID CUSTOMER}
set key_columns(CUSTOMER_PRICE_BOOK)		{COMPANY_ID CUSTOMER}
set key_columns(CUSTOMER_TYPE_DISCOUNT)		{COMPANY_ID AR_TYPE IN_TYPE}
set key_columns(DEPT)						{COMPANY_ID DEPT_ID}
set key_columns(FOLLOW_UP_NOTE)				{NOTE_ID SORT_SEQUENCE}
set key_columns(GL_UPDATE)   				{COMPANY_ID UPDATE_BATCH ACCOUNT HEADER BATCH_NO REF_NO}
set key_columns(INSTRUMENT)					{USER_ID COMPANY_ID EVENT_DATE EVENT_NAME}
set key_columns(JOB_EQUIPMENT)				{ID}
set key_columns(JOB_NOTE)					{ID}
set key_columns(LAYOUT)						{COMPANY_ID MODULE LAYOUT}
set key_columns(LOG)						{ID}
set key_columns(MAIN_NOTE)					{ID}
set key_columns(MARKETING_CODES)			{COMPANY_ID MARKETING_CODE}
set key_columns(MASTER)						{COMPANY_ID MODULE NUMBER}
set key_columns(MASTER_BUDGETS)				{COMPANY_ID MODULE NUMBER YEAR}
set key_columns(MASTER_CODE)				{COMPANY_ID MODULE CODE}
set key_columns(MASTER_KEYWORD)				{}
set key_columns(MASTER_SUBTYPE)				{COMPANY_ID MODULE TYPE SUBTYPE}
set key_columns(MASTER_TYPE)				{COMPANY_ID MODULE TYPE}
set key_columns(MISSHIPMENT_HEADER)			{COMPANY_ID REF}
set key_columns(MISSHIPMENT_LINE)			{COMPANY_ID REF SORT_SEQUENCE}
set key_columns(MISSHIPMENT_NOTE)			{ID}
set key_columns(MODULE_TRAN)				{COMPANY_ID MODULE TYPE}
set key_columns(NOTES)						{ID}
set key_columns(ORDER_HEADER)				{COMPANY_ID REF}
set key_columns(ORDER_LINE)					{COMPANY_ID REF SORT_SEQUENCE}
set key_columns(ORDER_LINE_DETAIL)			{COMPANY_ID REF SORT_SEQUENCE LINE_NO}
set key_columns(OVERSEAS_ENQUIRY)			{ID}
set key_columns(OVERSEAS_PART)				{ID}
set key_columns(PACKING_SLIP)				{COMPANY_ID PACKING_SLIP}
set key_columns(PART_LABEL)					{ID}
set key_columns(PART_PHRASE)				{}
set key_columns(PHONE_NUMBER)				{ID}
set key_columns(PPP_CONTRACT)				{COMPANY_ID REF}
set key_columns(PPP_COUNT)					{COMPANY_ID REF DATE}
set key_columns(PPP_ITEM)					{COMPANY_ID REF PART}
set key_columns(PPP_NOTE)					{ID}
set key_columns(PRICE_CHANGE)				{ID}
set key_columns(PRICE_CODE)					{COMPANY_ID PRICE_CODE}
set key_columns(PRICE_UPDATE_LINE)			{COMPANY_ID UPDATE_NO SORT_SEQUENCE}
set key_columns(PRINTER)					{ID}
set key_columns(PRODUCT_AUTOMOTIVE)			{ID}
set key_columns(PRODUCT_BARCODES)			{COMPANY_ID PART}
set key_columns(PRODUCT_EXTRAS)				{COMPANY_ID PART}
set key_columns(PRODUCT_TYPE_CATEGORY)		{COMPANY_ID ID}
set key_columns(PURCHASE_LINE)				{COMPANY_ID REF SORT_SEQUENCE}
set key_columns(PURCHASE_ORDER)				{COMPANY_ID REF}
set key_columns(RETURN_HEADER)				{COMPANY_ID REF}
set key_columns(RETURN_LINE)				{COMPANY_ID REF SORT_SEQUENCE}
set key_columns(RETURN_NOTE)				{ID}
set key_columns(RE_ORDER)					{COMPANY_ID BRANCH TYPE}
set key_columns(SALESMAN_COMMISSION)		{COMPANY_ID SALESMAN TYPE}
set key_columns(SAVED_REPORT)				{ID}
set key_columns(SCHEDULED_PRICE_UPDATE)		{COMPANY_ID UPDATE_NO}
set key_columns(SERIAL_NUMBER)				{COMPANY_ID PART SERIAL_NO}
set key_columns(STANDARD_TEXT)				{ID}
set key_columns(STK_HEADER)					{COMPANY_ID REF_NO}
set key_columns(STK_PART)					{COMPANY_ID REF_NO PART}
set key_columns(STK_SERIAL)					{COMPANY_ID REF_NO PART BRANCH SERIAL_NO}
set key_columns(STOCK_PURCHASE)				{COMPANY_ID PART BRANCH DATE REF_NO}
set key_columns(STOCK_QTY)					{COMPANY_ID PART BRANCH}
set key_columns(SUPPLIER_ADDRESS)			{SUPPLIER ID}
set key_columns(SUPPLIER_MARKUP)			{SUPPLIER TYPE COMPANY_ID}
set key_columns(SYSTEM)						{}
set key_columns(TAXI_PIN)					{COMPANY_ID PIN}
set key_columns(TAXI_PIN_DATA)				{ID}
set key_columns(TAXI_VOUCHER)				{ID}
set key_columns(TAXI_ZONE)					{COMPANY_ID CODE}
set key_columns(TAX_CODE)					{CODE}
set key_columns(TICKET)      			 	{COMPANY_ID DISPATCH_NO ITEM_NO} 
set key_columns(TRAN)						{COMPANY_ID REF_NO HEADER SORT_SEQUENCE}
set key_columns(TRAN_APPLY)					{COMPANY_ID REF_NO APPLY_NO}
set key_columns(TRAN_REF)					{COMPANY_ID TYPE BRANCH}
set key_columns(TRAN_SERIAL)				{REF_NO HEADER SORT_SEQUENCE SERIAL_NO PART COMPANY_ID}
set key_columns(TYPE_BUDGETS)				{COMPANY_ID MODULE TYPE YEAR}
set key_columns(TYPE_DATA)					{COMPANY_ID MODULE NUMBER SEQUENCE}
set key_columns(TYPE_HEADING)				{COMPANY_ID MODULE TYPE SEQUENCE}
set key_columns(USER)        				{USER_ID}
set key_columns(USER_COMPANY)				{USER_ID COMPANY_ID}
set key_columns(VOUCHER_REGISTER)			{FIRST_NUMBER TYPE COMPANY_ID}
set key_columns(WARRANTY_CLAIM)				{ID}
set key_columns(WARRANTY_DETAIL)			{ID}
set key_columns(WEB_CONTROL)				{}
set key_columns(WEB_SESSION)				{COMPANY_ID ID}
set key_columns(WEB_USER)					{USER_ID}

# Tables with specific cache expiry times (seconds)
set expiry(AS_MODULE)						600
set expiry(COMPANY)							600
set expiry(INSTRUMENT)						600
set expiry(MODULE_TRAN)						600
set expiry(PRINTER)							600
set expiry(SAVED_REPORT)					600
set expiry(SYSTEM)							3600
set expiry(USER)        					3600
set expiry(USER_COMPANY)					3600
set expiry(WEB_CONTROL)						5
set expiry(WEB_SESSION)						10
set expiry(WEB_USER)						10

# Sort the key into standard column order
# Move elsewhere ...
proc get_sorted_key { table key } {
	# Key has previously been sorted
	if {[info exists ::schema::sorted_${table}($key)]} {
		return [set ::schema::sorted_${table}($key)]
	}

	# Required columns
	array set column {}
	foreach name $key {
		set column($name) 1
	}

	# Sort per all_columns in schema
	set number [llength $key]
	set sorted {}
	if {$number > 0} {
		foreach name $schema::all_columns($table) {
			if {[info exists column($name)]} {
				lappend sorted $name
				if {[incr number -1] == 0} { break }
			}
		}
		if {$number > 0} { error "key \{$key\} for table $table has unknown column" }
	}
	set ::schema::sorted_${table}($key) $sorted
	return $sorted
}

# Determine if key is a unique key for the table
# Move elsewhere ...
proc is_unique_key { table key } {
	# Previously determined
	if {[info exists ::schema::unique_${table}($key)]} {
		return [set ::schema::unique_${table}($key)]
	}

	# Convert key to array
	array set column {}
	foreach name $key {
		set column($name) 1
	}

	# Check against each known unique key
	set keyList $::schema::key_unique($table)
	set is_unique 0
	foreach candidate $keyList {
		# Do all columns of candidate occur in key
		set is_unique 1
		foreach name $candidate {
			if {![info exists column($name)]} {
				set is_unique 0
				break
			}
		}
		if {$is_unique} { break }
	}
	set ::schema::unique_${table}($key) $is_unique
	return $is_unique
}

# End namespace
}

