
# --- DO NOT EDIT ---
#
# This file was generated by make_schema.tcl for database template on moa at 2014-01-14 17:08:15
# tclsh command/make_schema.tcl database (on moa)
# Defines database table and column attributes
#   all_tables: list of all tables in the database, in alphabetic order
#   all_columns(table): list of all columns in the table, most commonly-used first
#   type_table: type per column of the table 0=string 1=integer 2=real 3=date
#   null_table: null per column of the table 0 or 1 (column may be null)
#   key_unique: list of unique keys per table
#   auto_column: auto increment column name per table
#

namespace eval schema {

	set all_tables {ADDITIONAL_CHARGE ALTERNATE_PARTS ALTERNATE_SUPPLIERS AREA AREA_BUDGETS ASSET_SCHEDULE ASSET_VALUE AS_MODULE
		AUTOMOTIVE_MAKE AUTOMOTIVE_MODEL BALANCE BANK_STATEMENT BANK_STATEMENT_DETAIL BATCH BRANCH BRANCH_BUDGETS
		CALL_CYCLE CODE_BUDGETS CODE_DATA CODE_HEADING COMPANY COMPONENTS CONTACT_ROLE COURIER
		COURIER_CONTROL COURIER_DESTINATION COURIER_PRODUCT COURIER_SERVICE COURIER_TICKET_STATUS CURRENCY CURRENCY_RATES CUSTOMER_ADDRESS
		CUSTOMER_CATEGORIES CUSTOMER_DISCOUNT CUSTOMER_DISCOUNT2 CUSTOMER_EXTRAS CUSTOMER_PRICE_BOOK CUSTOMER_TYPE_DISCOUNT DEPT FOLLOW_UP_NOTE
		GL_UPDATE INSTRUMENT JOB_EQUIPMENT JOB_NOTE LAYOUT LOG MAIN_NOTE MARKETING_CODES
		MASTER MASTER_BUDGETS MASTER_CODE MASTER_KEYWORD MASTER_SUBTYPE MASTER_TYPE MISSHIPMENT_HEADER MISSHIPMENT_LINE
		MISSHIPMENT_NOTE MODULE_TRAN NOTES ORDER_HEADER ORDER_LINE ORDER_LINE_DETAIL OVERSEAS_ENQUIRY OVERSEAS_PART
		PACKING_SLIP PART_LABEL PART_PHRASE PHONE_NUMBER PPP_CONTRACT PPP_COUNT PPP_ITEM PPP_NOTE
		PRICE_CHANGE PRICE_CODE PRICE_UPDATE_LINE PRINTER PRODUCT_AUTOMOTIVE PRODUCT_BARCODES PRODUCT_EXTRAS PRODUCT_TYPE_CATEGORY
		PURCHASE_LINE PURCHASE_ORDER RETURN_HEADER RETURN_LINE RETURN_NOTE RE_ORDER SALESMAN_COMMISSION SAVED_REPORT
		SCHEDULED_PRICE_UPDATE SERIAL_NUMBER STANDARD_TEXT STK_HEADER STK_PART STK_SERIAL STOCK_PURCHASE STOCK_QTY
		SUPPLIER_ADDRESS SUPPLIER_MARKUP SYSTEM TAXI_PIN TAXI_PIN_DATA TAXI_VOUCHER TAXI_ZONE TAX_CODE
		TICKET TRAN TRAN_APPLY TRAN_REF TRAN_SERIAL TYPE_BUDGETS TYPE_DATA TYPE_HEADING
		USER USER_COMPANY VOUCHER_REGISTER WARRANTY_CLAIM WARRANTY_DETAIL WEB_CONTROL WEB_SESSION WEB_USER}

	set all_columns(ADDITIONAL_CHARGE) {COMPANY_ID REF_NO ACCOUNT ALLOCATION_CODE AMOUNT APPLY_TO_COST CURRENCY_CODE EXCHANGE_RATE
		EXPENSE_ACCOUNT INVOICE_NO MODULE NARRATION SEQUENCE TAX_EXEMPT_AMOUNT TAX_TYPE}
	array set type_ADDITIONAL_CHARGE {COMPANY_ID 0 REF_NO 1 ACCOUNT 1 ALLOCATION_CODE 0 AMOUNT 2 APPLY_TO_COST 0
		CURRENCY_CODE 0 EXCHANGE_RATE 2 EXPENSE_ACCOUNT 1 INVOICE_NO 0 MODULE 0 NARRATION 0
		SEQUENCE 1 TAX_EXEMPT_AMOUNT 2 TAX_TYPE 0}
	array set null_ADDITIONAL_CHARGE {COMPANY_ID 0 REF_NO 0 ACCOUNT 0 ALLOCATION_CODE 1 AMOUNT 1 APPLY_TO_COST 1
		CURRENCY_CODE 0 EXCHANGE_RATE 0 EXPENSE_ACCOUNT 1 INVOICE_NO 0 MODULE 0 NARRATION 1
		SEQUENCE 1 TAX_EXEMPT_AMOUNT 1 TAX_TYPE 0}
	array set default_ADDITIONAL_CHARGE {COMPANY_ID {} REF_NO 0 ACCOUNT 0 ALLOCATION_CODE {} AMOUNT 0.0 APPLY_TO_COST {}
		CURRENCY_CODE {} EXCHANGE_RATE 0.000000 EXPENSE_ACCOUNT 0 INVOICE_NO {} MODULE {} NARRATION {}
		SEQUENCE 0 TAX_EXEMPT_AMOUNT 0.0 TAX_TYPE {}}

	set all_columns(ALTERNATE_PARTS) {COMPANY_ID PART ALTERNATE_PART DISPLAY NOTE}
	array set type_ALTERNATE_PARTS {COMPANY_ID 0 PART 1 ALTERNATE_PART 1 DISPLAY 0 NOTE 0}
	array set null_ALTERNATE_PARTS {COMPANY_ID 0 PART 0 ALTERNATE_PART 0 DISPLAY 1 NOTE 1}
	array set default_ALTERNATE_PARTS {COMPANY_ID {} PART 0 ALTERNATE_PART 0 DISPLAY {} NOTE {}}

	set all_columns(ALTERNATE_SUPPLIERS) {COMPANY_ID PART SUPPLIER COST_PRICE LAST_PURCHASE_DATE LAST_PURCHASE_PRICE NOTE SUPPLIER_PART}
	array set type_ALTERNATE_SUPPLIERS {COMPANY_ID 0 PART 1 SUPPLIER 1 COST_PRICE 2 LAST_PURCHASE_DATE 3 LAST_PURCHASE_PRICE 2
		NOTE 0 SUPPLIER_PART 0}
	array set null_ALTERNATE_SUPPLIERS {COMPANY_ID 0 PART 0 SUPPLIER 0 COST_PRICE 1 LAST_PURCHASE_DATE 1 LAST_PURCHASE_PRICE 1
		NOTE 1 SUPPLIER_PART 1}
	array set default_ALTERNATE_SUPPLIERS {COMPANY_ID {} PART 0 SUPPLIER 0 COST_PRICE 0.0 LAST_PURCHASE_DATE {} LAST_PURCHASE_PRICE 0.0
		NOTE {} SUPPLIER_PART {}}

	set all_columns(AREA) {COMPANY_ID AREA_CODE NAME}
	array set type_AREA {COMPANY_ID 0 AREA_CODE 0 NAME 0}
	array set null_AREA {COMPANY_ID 0 AREA_CODE 0 NAME 0}
	array set default_AREA {COMPANY_ID {} AREA_CODE {} NAME {}}

	set all_columns(AREA_BUDGETS) {AREA_CODE COMPANY_ID SALES01 SALES02 SALES03 SALES04 SALES05 SALES06
		SALES07 SALES08 SALES09 SALES10 SALES11 SALES12 YEAR}
	array set type_AREA_BUDGETS {AREA_CODE 0 COMPANY_ID 0 SALES01 2 SALES02 2 SALES03 2 SALES04 2
		SALES05 2 SALES06 2 SALES07 2 SALES08 2 SALES09 2 SALES10 2
		SALES11 2 SALES12 2 YEAR 1}
	array set null_AREA_BUDGETS {AREA_CODE 0 COMPANY_ID 0 SALES01 1 SALES02 1 SALES03 1 SALES04 1
		SALES05 1 SALES06 1 SALES07 1 SALES08 1 SALES09 1 SALES10 1
		SALES11 1 SALES12 1 YEAR 0}
	array set default_AREA_BUDGETS {AREA_CODE {} COMPANY_ID {} SALES01 0.0 SALES02 0.0 SALES03 0.0 SALES04 0.0
		SALES05 0.0 SALES06 0.0 SALES07 0.0 SALES08 0.0 SALES09 0.0 SALES10 0.0
		SALES11 0.0 SALES12 0.0 YEAR 0}

	set all_columns(ASSET_SCHEDULE) {CODE COMPANY_ID DEPN_PERIOD DESCRIPTION}
	array set type_ASSET_SCHEDULE {CODE 0 COMPANY_ID 0 DEPN_PERIOD 3 DESCRIPTION 0}
	array set null_ASSET_SCHEDULE {CODE 0 COMPANY_ID 0 DEPN_PERIOD 0 DESCRIPTION 0}
	array set default_ASSET_SCHEDULE {CODE {} COMPANY_ID {} DEPN_PERIOD {0000-00-00 00:00:00} DESCRIPTION {}}

	set all_columns(ASSET_VALUE) {ASSET COMPANY_ID DEPN_ACCUMULATED DEPN_METHOD DEPN_RATE DEPN_YTD}
	array set type_ASSET_VALUE {ASSET 1 COMPANY_ID 0 DEPN_ACCUMULATED 2 DEPN_METHOD 0 DEPN_RATE 2 DEPN_YTD 2}
	array set null_ASSET_VALUE {ASSET 0 COMPANY_ID 0 DEPN_ACCUMULATED 0 DEPN_METHOD 0 DEPN_RATE 0 DEPN_YTD 0}
	array set default_ASSET_VALUE {ASSET 0 COMPANY_ID {} DEPN_ACCUMULATED 0.00 DEPN_METHOD {} DEPN_RATE 0.00 DEPN_YTD 0.00}

	set all_columns(AS_MODULE) {MODULE COMPANY_ID LAST_NUMBER LAST_CONTACT_ROLE_ID PERIOD_END_DATE YEAR_END_DATE ACCOUNT_NAME AUTOMATIC_DISABLE_RESET
		BATCH_TOTAL_SECURITY CASH_PAYMENT_TRANSACTION CHECK_CREDIT_LIMIT CHECK_MAX_DAYS CHECK_OVERRIDE_LEVEL CODE_NAME COMMISSION_CALCULATION DEFAULT_COURIER
		DEFAULT_CREDIT_LIMIT DEFAULT_DISCOUNT_TYPE DEFAULT_LAYOUT DEFAULT_PRICE_LEVEL DEFAULT_PRICE_UPDATING DEFAULT_TYPE EMAIL_ADDRESS EQUIPMENT_NAME
		GL_ACCUMULATED_DEPN GL_ASSET_CONTROL GL_ASSET_PROCEEDS GL_BANK_CHARGES GL_CAPITAL_GAINS GL_CONTROL_ACCOUNT GL_COST_OF_SALES GL_COST_VARIANCE
		GL_DEPN_EXPENSE GL_DISCOUNT_ACCOUNT GL_EXCHANGE_VARIANCE GL_FREIGHT_ACCOUNT GL_GAIN_LOSS_ON_DEPN GL_GOODS_IN_TRANSIT GL_GST_ADJ10 GL_GST_DEFERRED
		GL_GST_IN GL_GST_OUT GL_LENGTH1 GL_LENGTH2 GL_LENGTH3 GL_LENGTH4 GL_LENGTH5 GL_LENGTH6
		GL_NON_STOCK GL_PROFIT GL_RETAINED_EARNINGS GL_SALES GL_SEGMENT1 GL_SEGMENT2 GL_SEGMENT3 GL_SEGMENT4
		GL_SEGMENT5 GL_SEGMENT6 GL_SEPARATOR GL_STOCK GL_STOCK_CLEARING GL_SURCHARGE_ACCOUNT GL_SUSPENSE HISTORY_NAME1
		HISTORY_NAME2 INVOICE_SECURITY INVOICE_TRANSACTION LENGTH_OF_ACCOUNT LENGTH_OF_NAME LOCATION_NAME MARGIN_OVERRIDE_LEVEL MAXIMUM_DAYS_CREDIT
		MINIMUM_SALES_MARGIN NAME NUMBER_ACCOUNTS PASSWORD_OVERRIDE PAYMENT_METHOD PRICE1_NAME PRICE1_SECURITY PRICE2_NAME
		PRICE2_SECURITY PRICE3_NAME PRICE3_SECURITY PRICE4_NAME PRICE4_SECURITY PRICE5_NAME PRICE5_SECURITY PRICE6_NAME
		PRICE6_SECURITY PRICE7_NAME PRICE7_SECURITY PRICE8_NAME PRICE8_SECURITY PRICE9_NAME PRICE9_SECURITY PRICE10_NAME
		PRICE10_SECURITY PRINT_CASH_SALES PRINT_INVOICES PURCHASE_FOLLOWUP_LOCAL PURCHASE_FOLLOWUP_OVERSEAS REFERENCE_NAME REPLACEMENT_METHOD REPORT_TYPE1
		REPORT_TYPE2 ROUND_BY_5_CENTS SALES_BRANCH SHOW_LABOUR_RATE SORT_INVOICES SUPPLIER_PAYMENT_TRANSACTION TYPE_NAME VALUATION_METHOD
		WIP_ACCOUNT GL_START1 GL_START2 GL_START3 GL_START4 GL_START5 GL_START6 SORT_CUSTOMERS
		SUNDRY_CHARGES AUTO_RELEASE_ORDERS PRINT_SHIPMENT_BACKING CASH_CUSTOMER DEFAULT_INVOICE NON_STOCK_ITEM}
	array set type_AS_MODULE {MODULE 0 COMPANY_ID 0 LAST_NUMBER 1 LAST_CONTACT_ROLE_ID 1 PERIOD_END_DATE 3 YEAR_END_DATE 3
		ACCOUNT_NAME 0 AUTOMATIC_DISABLE_RESET 0 BATCH_TOTAL_SECURITY 1 CASH_PAYMENT_TRANSACTION 0 CHECK_CREDIT_LIMIT 0 CHECK_MAX_DAYS 0
		CHECK_OVERRIDE_LEVEL 1 CODE_NAME 0 COMMISSION_CALCULATION 0 DEFAULT_COURIER 0 DEFAULT_CREDIT_LIMIT 2 DEFAULT_DISCOUNT_TYPE 0
		DEFAULT_LAYOUT 0 DEFAULT_PRICE_LEVEL 1 DEFAULT_PRICE_UPDATING 0 DEFAULT_TYPE 0 EMAIL_ADDRESS 0 EQUIPMENT_NAME 0
		GL_ACCUMULATED_DEPN 1 GL_ASSET_CONTROL 1 GL_ASSET_PROCEEDS 1 GL_BANK_CHARGES 1 GL_CAPITAL_GAINS 1 GL_CONTROL_ACCOUNT 1
		GL_COST_OF_SALES 1 GL_COST_VARIANCE 1 GL_DEPN_EXPENSE 1 GL_DISCOUNT_ACCOUNT 1 GL_EXCHANGE_VARIANCE 1 GL_FREIGHT_ACCOUNT 1
		GL_GAIN_LOSS_ON_DEPN 1 GL_GOODS_IN_TRANSIT 1 GL_GST_ADJ10 1 GL_GST_DEFERRED 1 GL_GST_IN 1 GL_GST_OUT 1
		GL_LENGTH1 1 GL_LENGTH2 1 GL_LENGTH3 1 GL_LENGTH4 1 GL_LENGTH5 1 GL_LENGTH6 1
		GL_NON_STOCK 1 GL_PROFIT 1 GL_RETAINED_EARNINGS 1 GL_SALES 1 GL_SEGMENT1 0 GL_SEGMENT2 0
		GL_SEGMENT3 0 GL_SEGMENT4 0 GL_SEGMENT5 0 GL_SEGMENT6 0 GL_SEPARATOR 0 GL_STOCK 1
		GL_STOCK_CLEARING 1 GL_SURCHARGE_ACCOUNT 1 GL_SUSPENSE 1 HISTORY_NAME1 0 HISTORY_NAME2 0 INVOICE_SECURITY 1
		INVOICE_TRANSACTION 0 LENGTH_OF_ACCOUNT 1 LENGTH_OF_NAME 1 LOCATION_NAME 0 MARGIN_OVERRIDE_LEVEL 1 MAXIMUM_DAYS_CREDIT 1
		MINIMUM_SALES_MARGIN 2 NAME 0 NUMBER_ACCOUNTS 0 PASSWORD_OVERRIDE 0 PAYMENT_METHOD 0 PRICE1_NAME 0
		PRICE1_SECURITY 0 PRICE2_NAME 0 PRICE2_SECURITY 0 PRICE3_NAME 0 PRICE3_SECURITY 0 PRICE4_NAME 0
		PRICE4_SECURITY 0 PRICE5_NAME 0 PRICE5_SECURITY 0 PRICE6_NAME 0 PRICE6_SECURITY 0 PRICE7_NAME 0
		PRICE7_SECURITY 0 PRICE8_NAME 0 PRICE8_SECURITY 0 PRICE9_NAME 0 PRICE9_SECURITY 0 PRICE10_NAME 0
		PRICE10_SECURITY 0 PRINT_CASH_SALES 0 PRINT_INVOICES 0 PURCHASE_FOLLOWUP_LOCAL 1 PURCHASE_FOLLOWUP_OVERSEAS 1 REFERENCE_NAME 0
		REPLACEMENT_METHOD 0 REPORT_TYPE1 0 REPORT_TYPE2 0 ROUND_BY_5_CENTS 0 SALES_BRANCH 0 SHOW_LABOUR_RATE 0
		SORT_INVOICES 0 SUPPLIER_PAYMENT_TRANSACTION 0 TYPE_NAME 0 VALUATION_METHOD 0 WIP_ACCOUNT 1 GL_START1 1
		GL_START2 1 GL_START3 1 GL_START4 1 GL_START5 1 GL_START6 1 SORT_CUSTOMERS 0
		SUNDRY_CHARGES 1 AUTO_RELEASE_ORDERS 0 PRINT_SHIPMENT_BACKING 0 CASH_CUSTOMER 1 DEFAULT_INVOICE 0 NON_STOCK_ITEM 1}
	array set null_AS_MODULE {MODULE 0 COMPANY_ID 0 LAST_NUMBER 1 LAST_CONTACT_ROLE_ID 0 PERIOD_END_DATE 1 YEAR_END_DATE 1
		ACCOUNT_NAME 1 AUTOMATIC_DISABLE_RESET 1 BATCH_TOTAL_SECURITY 1 CASH_PAYMENT_TRANSACTION 1 CHECK_CREDIT_LIMIT 1 CHECK_MAX_DAYS 1
		CHECK_OVERRIDE_LEVEL 1 CODE_NAME 1 COMMISSION_CALCULATION 1 DEFAULT_COURIER 1 DEFAULT_CREDIT_LIMIT 1 DEFAULT_DISCOUNT_TYPE 1
		DEFAULT_LAYOUT 1 DEFAULT_PRICE_LEVEL 1 DEFAULT_PRICE_UPDATING 1 DEFAULT_TYPE 1 EMAIL_ADDRESS 1 EQUIPMENT_NAME 1
		GL_ACCUMULATED_DEPN 1 GL_ASSET_CONTROL 1 GL_ASSET_PROCEEDS 1 GL_BANK_CHARGES 1 GL_CAPITAL_GAINS 1 GL_CONTROL_ACCOUNT 1
		GL_COST_OF_SALES 1 GL_COST_VARIANCE 1 GL_DEPN_EXPENSE 1 GL_DISCOUNT_ACCOUNT 1 GL_EXCHANGE_VARIANCE 1 GL_FREIGHT_ACCOUNT 1
		GL_GAIN_LOSS_ON_DEPN 1 GL_GOODS_IN_TRANSIT 1 GL_GST_ADJ10 1 GL_GST_DEFERRED 1 GL_GST_IN 1 GL_GST_OUT 1
		GL_LENGTH1 1 GL_LENGTH2 1 GL_LENGTH3 1 GL_LENGTH4 1 GL_LENGTH5 1 GL_LENGTH6 1
		GL_NON_STOCK 1 GL_PROFIT 1 GL_RETAINED_EARNINGS 1 GL_SALES 1 GL_SEGMENT1 1 GL_SEGMENT2 1
		GL_SEGMENT3 1 GL_SEGMENT4 1 GL_SEGMENT5 1 GL_SEGMENT6 1 GL_SEPARATOR 1 GL_STOCK 1
		GL_STOCK_CLEARING 1 GL_SURCHARGE_ACCOUNT 1 GL_SUSPENSE 1 HISTORY_NAME1 1 HISTORY_NAME2 1 INVOICE_SECURITY 1
		INVOICE_TRANSACTION 1 LENGTH_OF_ACCOUNT 1 LENGTH_OF_NAME 1 LOCATION_NAME 1 MARGIN_OVERRIDE_LEVEL 1 MAXIMUM_DAYS_CREDIT 1
		MINIMUM_SALES_MARGIN 1 NAME 0 NUMBER_ACCOUNTS 1 PASSWORD_OVERRIDE 1 PAYMENT_METHOD 1 PRICE1_NAME 1
		PRICE1_SECURITY 1 PRICE2_NAME 1 PRICE2_SECURITY 1 PRICE3_NAME 1 PRICE3_SECURITY 1 PRICE4_NAME 1
		PRICE4_SECURITY 1 PRICE5_NAME 1 PRICE5_SECURITY 1 PRICE6_NAME 1 PRICE6_SECURITY 1 PRICE7_NAME 1
		PRICE7_SECURITY 1 PRICE8_NAME 1 PRICE8_SECURITY 1 PRICE9_NAME 1 PRICE9_SECURITY 1 PRICE10_NAME 1
		PRICE10_SECURITY 1 PRINT_CASH_SALES 1 PRINT_INVOICES 1 PURCHASE_FOLLOWUP_LOCAL 1 PURCHASE_FOLLOWUP_OVERSEAS 1 REFERENCE_NAME 1
		REPLACEMENT_METHOD 1 REPORT_TYPE1 1 REPORT_TYPE2 1 ROUND_BY_5_CENTS 1 SALES_BRANCH 1 SHOW_LABOUR_RATE 1
		SORT_INVOICES 1 SUPPLIER_PAYMENT_TRANSACTION 1 TYPE_NAME 1 VALUATION_METHOD 1 WIP_ACCOUNT 1 GL_START1 1
		GL_START2 1 GL_START3 1 GL_START4 1 GL_START5 1 GL_START6 1 SORT_CUSTOMERS 1
		SUNDRY_CHARGES 1 AUTO_RELEASE_ORDERS 1 PRINT_SHIPMENT_BACKING 1 CASH_CUSTOMER 1 DEFAULT_INVOICE 1 NON_STOCK_ITEM 1}
	array set default_AS_MODULE {MODULE {} COMPANY_ID {} LAST_NUMBER 0 LAST_CONTACT_ROLE_ID 0 PERIOD_END_DATE {} YEAR_END_DATE {}
		ACCOUNT_NAME {} AUTOMATIC_DISABLE_RESET {} BATCH_TOTAL_SECURITY 0 CASH_PAYMENT_TRANSACTION {} CHECK_CREDIT_LIMIT {} CHECK_MAX_DAYS {}
		CHECK_OVERRIDE_LEVEL 0 CODE_NAME {} COMMISSION_CALCULATION {} DEFAULT_COURIER {} DEFAULT_CREDIT_LIMIT 0.0 DEFAULT_DISCOUNT_TYPE {}
		DEFAULT_LAYOUT {} DEFAULT_PRICE_LEVEL 0 DEFAULT_PRICE_UPDATING {} DEFAULT_TYPE {} EMAIL_ADDRESS {} EQUIPMENT_NAME {}
		GL_ACCUMULATED_DEPN 0 GL_ASSET_CONTROL 0 GL_ASSET_PROCEEDS 0 GL_BANK_CHARGES 0 GL_CAPITAL_GAINS 0 GL_CONTROL_ACCOUNT 0
		GL_COST_OF_SALES 0 GL_COST_VARIANCE 0 GL_DEPN_EXPENSE 0 GL_DISCOUNT_ACCOUNT 0 GL_EXCHANGE_VARIANCE 0 GL_FREIGHT_ACCOUNT 0
		GL_GAIN_LOSS_ON_DEPN 0 GL_GOODS_IN_TRANSIT 0 GL_GST_ADJ10 0 GL_GST_DEFERRED 0 GL_GST_IN 0 GL_GST_OUT 0
		GL_LENGTH1 0 GL_LENGTH2 0 GL_LENGTH3 0 GL_LENGTH4 0 GL_LENGTH5 0 GL_LENGTH6 0
		GL_NON_STOCK 0 GL_PROFIT 0 GL_RETAINED_EARNINGS 0 GL_SALES 0 GL_SEGMENT1 {} GL_SEGMENT2 {}
		GL_SEGMENT3 {} GL_SEGMENT4 {} GL_SEGMENT5 {} GL_SEGMENT6 {} GL_SEPARATOR {} GL_STOCK 0
		GL_STOCK_CLEARING 0 GL_SURCHARGE_ACCOUNT 0 GL_SUSPENSE 0 HISTORY_NAME1 {} HISTORY_NAME2 {} INVOICE_SECURITY 0
		INVOICE_TRANSACTION {} LENGTH_OF_ACCOUNT 0 LENGTH_OF_NAME 0 LOCATION_NAME {} MARGIN_OVERRIDE_LEVEL 0 MAXIMUM_DAYS_CREDIT 0
		MINIMUM_SALES_MARGIN 0.0 NAME {} NUMBER_ACCOUNTS {} PASSWORD_OVERRIDE {} PAYMENT_METHOD {} PRICE1_NAME {}
		PRICE1_SECURITY {} PRICE2_NAME {} PRICE2_SECURITY {} PRICE3_NAME {} PRICE3_SECURITY {} PRICE4_NAME {}
		PRICE4_SECURITY {} PRICE5_NAME {} PRICE5_SECURITY {} PRICE6_NAME {} PRICE6_SECURITY {} PRICE7_NAME {}
		PRICE7_SECURITY {} PRICE8_NAME {} PRICE8_SECURITY {} PRICE9_NAME {} PRICE9_SECURITY {} PRICE10_NAME {}
		PRICE10_SECURITY {} PRINT_CASH_SALES {} PRINT_INVOICES {} PURCHASE_FOLLOWUP_LOCAL 0 PURCHASE_FOLLOWUP_OVERSEAS 0 REFERENCE_NAME {}
		REPLACEMENT_METHOD {} REPORT_TYPE1 {} REPORT_TYPE2 {} ROUND_BY_5_CENTS {} SALES_BRANCH {} SHOW_LABOUR_RATE {}
		SORT_INVOICES {} SUPPLIER_PAYMENT_TRANSACTION {} TYPE_NAME {} VALUATION_METHOD {} WIP_ACCOUNT 0 GL_START1 0
		GL_START2 0 GL_START3 0 GL_START4 0 GL_START5 0 GL_START6 0 SORT_CUSTOMERS {}
		SUNDRY_CHARGES 0 AUTO_RELEASE_ORDERS {} PRINT_SHIPMENT_BACKING {} CASH_CUSTOMER 0 DEFAULT_INVOICE {} NON_STOCK_ITEM 0}

	set all_columns(AUTOMOTIVE_MAKE) {ID NAME}
	array set type_AUTOMOTIVE_MAKE {ID 0 NAME 0}
	array set null_AUTOMOTIVE_MAKE {ID 0 NAME 0}
	array set default_AUTOMOTIVE_MAKE {ID {} NAME {}}

	set all_columns(AUTOMOTIVE_MODEL) {NAME AUTOMOTIVE_MAKE_ID ID}
	array set type_AUTOMOTIVE_MODEL {NAME 0 AUTOMOTIVE_MAKE_ID 0 ID 0}
	array set null_AUTOMOTIVE_MODEL {NAME 0 AUTOMOTIVE_MAKE_ID 0 ID 0}
	array set default_AUTOMOTIVE_MODEL {NAME {} AUTOMOTIVE_MAKE_ID {} ID {}}

	set all_columns(BALANCE) {MODULE COMPANY_ID ACCOUNT YEAR BRANCH SALES_VALUE04 SALES_VALUE05 SALES_VALUE06
		SALES_VALUE03 SALES_VALUE07 SALES_VALUE02 SALES_VALUE08 SALES_VALUE01 SALES_VALUE09 COST_OF_SALES06 COST_OF_SALES05
		COST_OF_SALES04 COST_OF_SALES03 SALES_VALUE10 SALES_VALUE11 COST_OF_SALES07 SALES_VALUE12 COST_OF_SALES08 COST_OF_SALES02
		COST_OF_SALES09 COST_OF_SALES01 COST_OF_SALES11 COST_OF_SALES12 SALES_NZD04 SALES_NZD05 COST_OF_SALES10 SALES_NZD06
		SALES_NZD03 SALES_NZD07 SALES_NZD02 SALES_NZD08 SALES_NZD01 SALES_NZD09 SALES_NZD10 SALES_NZD12
		SALES_NZD11 SALES_QTY06 SALES_QTY08 SALES_QTY09 SALES_QTY03 SALES_QTY07 SALES_QTY05 SALES_QTY11
		SALES_QTY02 SALES_QTY10 SALES_QTY12 SALES_QTY01 SALES_QTY04 PURCHASE_QTY07 PURCHASE_QTY04 PURCHASE_QTY05
		PURCHASE_QTY06 PURCHASE_QTY01 PURCHASE_QTY02 PURCHASE_QTY08 PURCHASE_QTY03 TOTAL06 TOTAL05 TOTAL07
		PURCHASE_QTY12 PURCHASE_QTY09 PURCHASE_QTY11 PURCHASE_QTY10 TOTAL08 TOTAL04 TOTAL09 TOTAL01
		TOTAL03 TOTAL12 TOTAL02 TOTAL11 TOTAL10 PURCHASE_VALUE06 PURCHASE_VALUE07 PURCHASE_VALUE08
		PURCHASE_VALUE04 PURCHASE_VALUE05 PURCHASE_VALUE09 PURCHASE_NZD04 PURCHASE_NZD05 PURCHASE_NZD06 PURCHASE_NZD07 PURCHASE_NZD08
		PURCHASE_NZD09 PURCHASE_VALUE02 PURCHASE_NZD02 PURCHASE_NZD01 PURCHASE_NZD03 PURCHASE_NZD10 PURCHASE_NZD11 PURCHASE_NZD12
		PURCHASE_VALUE01 PURCHASE_VALUE03 PURCHASE_VALUE10 PURCHASE_VALUE11 PURCHASE_VALUE12}
	array set type_BALANCE {MODULE 0 COMPANY_ID 0 ACCOUNT 1 YEAR 1 BRANCH 0 SALES_VALUE04 2
		SALES_VALUE05 2 SALES_VALUE06 2 SALES_VALUE03 2 SALES_VALUE07 2 SALES_VALUE02 2 SALES_VALUE08 2
		SALES_VALUE01 2 SALES_VALUE09 2 COST_OF_SALES06 2 COST_OF_SALES05 2 COST_OF_SALES04 2 COST_OF_SALES03 2
		SALES_VALUE10 2 SALES_VALUE11 2 COST_OF_SALES07 2 SALES_VALUE12 2 COST_OF_SALES08 2 COST_OF_SALES02 2
		COST_OF_SALES09 2 COST_OF_SALES01 2 COST_OF_SALES11 2 COST_OF_SALES12 2 SALES_NZD04 2 SALES_NZD05 2
		COST_OF_SALES10 2 SALES_NZD06 2 SALES_NZD03 2 SALES_NZD07 2 SALES_NZD02 2 SALES_NZD08 2
		SALES_NZD01 2 SALES_NZD09 2 SALES_NZD10 2 SALES_NZD12 2 SALES_NZD11 2 SALES_QTY06 2
		SALES_QTY08 2 SALES_QTY09 2 SALES_QTY03 2 SALES_QTY07 2 SALES_QTY05 2 SALES_QTY11 2
		SALES_QTY02 2 SALES_QTY10 2 SALES_QTY12 2 SALES_QTY01 2 SALES_QTY04 2 PURCHASE_QTY07 2
		PURCHASE_QTY04 2 PURCHASE_QTY05 2 PURCHASE_QTY06 2 PURCHASE_QTY01 2 PURCHASE_QTY02 2 PURCHASE_QTY08 2
		PURCHASE_QTY03 2 TOTAL06 2 TOTAL05 2 TOTAL07 2 PURCHASE_QTY12 2 PURCHASE_QTY09 2
		PURCHASE_QTY11 2 PURCHASE_QTY10 2 TOTAL08 2 TOTAL04 2 TOTAL09 2 TOTAL01 2
		TOTAL03 2 TOTAL12 2 TOTAL02 2 TOTAL11 2 TOTAL10 2 PURCHASE_VALUE06 2
		PURCHASE_VALUE07 2 PURCHASE_VALUE08 2 PURCHASE_VALUE04 2 PURCHASE_VALUE05 2 PURCHASE_VALUE09 2 PURCHASE_NZD04 2
		PURCHASE_NZD05 2 PURCHASE_NZD06 2 PURCHASE_NZD07 2 PURCHASE_NZD08 2 PURCHASE_NZD09 2 PURCHASE_VALUE02 2
		PURCHASE_NZD02 2 PURCHASE_NZD01 2 PURCHASE_NZD03 2 PURCHASE_NZD10 2 PURCHASE_NZD11 2 PURCHASE_NZD12 2
		PURCHASE_VALUE01 2 PURCHASE_VALUE03 2 PURCHASE_VALUE10 2 PURCHASE_VALUE11 2 PURCHASE_VALUE12 2}
	array set null_BALANCE {MODULE 0 COMPANY_ID 0 ACCOUNT 0 YEAR 0 BRANCH 0 SALES_VALUE04 1
		SALES_VALUE05 1 SALES_VALUE06 1 SALES_VALUE03 1 SALES_VALUE07 1 SALES_VALUE02 1 SALES_VALUE08 1
		SALES_VALUE01 1 SALES_VALUE09 1 COST_OF_SALES06 1 COST_OF_SALES05 1 COST_OF_SALES04 1 COST_OF_SALES03 1
		SALES_VALUE10 1 SALES_VALUE11 1 COST_OF_SALES07 1 SALES_VALUE12 1 COST_OF_SALES08 1 COST_OF_SALES02 1
		COST_OF_SALES09 1 COST_OF_SALES01 1 COST_OF_SALES11 1 COST_OF_SALES12 1 SALES_NZD04 1 SALES_NZD05 1
		COST_OF_SALES10 1 SALES_NZD06 1 SALES_NZD03 1 SALES_NZD07 1 SALES_NZD02 1 SALES_NZD08 1
		SALES_NZD01 1 SALES_NZD09 1 SALES_NZD10 1 SALES_NZD12 1 SALES_NZD11 1 SALES_QTY06 1
		SALES_QTY08 1 SALES_QTY09 1 SALES_QTY03 1 SALES_QTY07 1 SALES_QTY05 1 SALES_QTY11 1
		SALES_QTY02 1 SALES_QTY10 1 SALES_QTY12 1 SALES_QTY01 1 SALES_QTY04 1 PURCHASE_QTY07 1
		PURCHASE_QTY04 1 PURCHASE_QTY05 1 PURCHASE_QTY06 1 PURCHASE_QTY01 1 PURCHASE_QTY02 1 PURCHASE_QTY08 1
		PURCHASE_QTY03 1 TOTAL06 1 TOTAL05 1 TOTAL07 1 PURCHASE_QTY12 1 PURCHASE_QTY09 1
		PURCHASE_QTY11 1 PURCHASE_QTY10 1 TOTAL08 1 TOTAL04 1 TOTAL09 1 TOTAL01 1
		TOTAL03 1 TOTAL12 1 TOTAL02 1 TOTAL11 1 TOTAL10 1 PURCHASE_VALUE06 1
		PURCHASE_VALUE07 1 PURCHASE_VALUE08 1 PURCHASE_VALUE04 1 PURCHASE_VALUE05 1 PURCHASE_VALUE09 1 PURCHASE_NZD04 1
		PURCHASE_NZD05 1 PURCHASE_NZD06 1 PURCHASE_NZD07 1 PURCHASE_NZD08 1 PURCHASE_NZD09 1 PURCHASE_VALUE02 1
		PURCHASE_NZD02 1 PURCHASE_NZD01 1 PURCHASE_NZD03 1 PURCHASE_NZD10 1 PURCHASE_NZD11 1 PURCHASE_NZD12 1
		PURCHASE_VALUE01 1 PURCHASE_VALUE03 1 PURCHASE_VALUE10 1 PURCHASE_VALUE11 1 PURCHASE_VALUE12 1}
	array set default_BALANCE {MODULE {} COMPANY_ID {} ACCOUNT 0 YEAR 0 BRANCH {} SALES_VALUE04 0.00
		SALES_VALUE05 0.00 SALES_VALUE06 0.00 SALES_VALUE03 0.00 SALES_VALUE07 0.00 SALES_VALUE02 0.00 SALES_VALUE08 0.00
		SALES_VALUE01 0.00 SALES_VALUE09 0.00 COST_OF_SALES06 0.00 COST_OF_SALES05 0.00 COST_OF_SALES04 0.00 COST_OF_SALES03 0.00
		SALES_VALUE10 0.00 SALES_VALUE11 0.00 COST_OF_SALES07 0.00 SALES_VALUE12 0.00 COST_OF_SALES08 0.00 COST_OF_SALES02 0.00
		COST_OF_SALES09 0.00 COST_OF_SALES01 0.00 COST_OF_SALES11 0.00 COST_OF_SALES12 0.00 SALES_NZD04 0.00 SALES_NZD05 0.00
		COST_OF_SALES10 0.00 SALES_NZD06 0.00 SALES_NZD03 0.00 SALES_NZD07 0.00 SALES_NZD02 0.00 SALES_NZD08 0.00
		SALES_NZD01 0.00 SALES_NZD09 0.00 SALES_NZD10 0.00 SALES_NZD12 0.00 SALES_NZD11 0.00 SALES_QTY06 0.0000
		SALES_QTY08 0.0000 SALES_QTY09 0.0000 SALES_QTY03 0.0000 SALES_QTY07 0.0000 SALES_QTY05 0.0000 SALES_QTY11 0.0000
		SALES_QTY02 0.0000 SALES_QTY10 0.0000 SALES_QTY12 0.0000 SALES_QTY01 0.0000 SALES_QTY04 0.0000 PURCHASE_QTY07 0.0000
		PURCHASE_QTY04 0.0000 PURCHASE_QTY05 0.0000 PURCHASE_QTY06 0.0000 PURCHASE_QTY01 0.0000 PURCHASE_QTY02 0.0000 PURCHASE_QTY08 0.0000
		PURCHASE_QTY03 0.0000 TOTAL06 0.00 TOTAL05 0.00 TOTAL07 0.00 PURCHASE_QTY12 0.0000 PURCHASE_QTY09 0.0000
		PURCHASE_QTY11 0.0000 PURCHASE_QTY10 0.0000 TOTAL08 0.00 TOTAL04 0.00 TOTAL09 0.00 TOTAL01 0.00
		TOTAL03 0.00 TOTAL12 0.00 TOTAL02 0.00 TOTAL11 0.00 TOTAL10 0.00 PURCHASE_VALUE06 0.00
		PURCHASE_VALUE07 0.00 PURCHASE_VALUE08 0.00 PURCHASE_VALUE04 0.00 PURCHASE_VALUE05 0.00 PURCHASE_VALUE09 0.00 PURCHASE_NZD04 0.00
		PURCHASE_NZD05 0.00 PURCHASE_NZD06 0.00 PURCHASE_NZD07 0.00 PURCHASE_NZD08 0.00 PURCHASE_NZD09 0.00 PURCHASE_VALUE02 0.00
		PURCHASE_NZD02 0.00 PURCHASE_NZD01 0.00 PURCHASE_NZD03 0.00 PURCHASE_NZD10 0.00 PURCHASE_NZD11 0.00 PURCHASE_NZD12 0.00
		PURCHASE_VALUE01 0.00 PURCHASE_VALUE03 0.00 PURCHASE_VALUE10 0.00 PURCHASE_VALUE11 0.00 PURCHASE_VALUE12 0.00}

	set all_columns(BANK_STATEMENT) {ACCOUNT COMPANY_ID PAGE_NO STATUS CLOSING_DATE OLDEST_TRAN CLOSING_BALANCE OLDEST_UNPRESENTED
		OPENING_BALANCE OPENING_DATE}
	array set type_BANK_STATEMENT {ACCOUNT 1 COMPANY_ID 0 PAGE_NO 1 STATUS 0 CLOSING_DATE 3 OLDEST_TRAN 3
		CLOSING_BALANCE 2 OLDEST_UNPRESENTED 3 OPENING_BALANCE 2 OPENING_DATE 3}
	array set null_BANK_STATEMENT {ACCOUNT 0 COMPANY_ID 0 PAGE_NO 0 STATUS 0 CLOSING_DATE 0 OLDEST_TRAN 1
		CLOSING_BALANCE 0 OLDEST_UNPRESENTED 1 OPENING_BALANCE 0 OPENING_DATE 0}
	array set default_BANK_STATEMENT {ACCOUNT 0 COMPANY_ID {} PAGE_NO 0 STATUS {} CLOSING_DATE {0000-00-00 00:00:00} OLDEST_TRAN {}
		CLOSING_BALANCE 0.00 OLDEST_UNPRESENTED {} OPENING_BALANCE 0.00 OPENING_DATE {0000-00-00 00:00:00}}

	set all_columns(BANK_STATEMENT_DETAIL) {ACCOUNT COMPANY_ID REF_NO PAGE_NO BATCH_NO PRESENTED REFERENCE TYPE
		DEBIT CREDIT DESCRIPTION OTHER DATE}
	array set type_BANK_STATEMENT_DETAIL {ACCOUNT 1 COMPANY_ID 0 REF_NO 1 PAGE_NO 1 BATCH_NO 1 PRESENTED 0
		REFERENCE 0 TYPE 0 DEBIT 2 CREDIT 2 DESCRIPTION 0 OTHER 0
		DATE 3}
	array set null_BANK_STATEMENT_DETAIL {ACCOUNT 0 COMPANY_ID 0 REF_NO 1 PAGE_NO 0 BATCH_NO 1 PRESENTED 0
		REFERENCE 1 TYPE 0 DEBIT 1 CREDIT 1 DESCRIPTION 1 OTHER 1
		DATE 1}
	array set default_BANK_STATEMENT_DETAIL {ACCOUNT 0 COMPANY_ID {} REF_NO 0 PAGE_NO 0 BATCH_NO 0 PRESENTED {}
		REFERENCE {} TYPE {} DEBIT 0.0 CREDIT 0.0 DESCRIPTION {} OTHER {}
		DATE {}}

	set all_columns(BATCH) {COMPANY_ID BATCH_NO TYPE STATUS BRANCH_ID TITLE MODULE REF_NO
		DATE GL_UPDATE_BATCH TOTAL_TOTAL TOTAL_AMOUNT TOTAL_COST_OF_SALES TOTAL_ITEMS TOTAL_FREIGHT TOTAL_QTY
		TOTAL_SURCHARGE NOTES PRINT_COUNT PRINT_DATE REPEAT_DAYS REPEAT_MONTHS STANDING_LAST_PROCESS DEPT_ID
		REVERSAL_DATE SECURITY_TYPE STATUS_MISC USER_ID}
	array set type_BATCH {COMPANY_ID 0 BATCH_NO 1 TYPE 0 STATUS 0 BRANCH_ID 0 TITLE 0
		MODULE 0 REF_NO 1 DATE 3 GL_UPDATE_BATCH 1 TOTAL_TOTAL 2 TOTAL_AMOUNT 2
		TOTAL_COST_OF_SALES 2 TOTAL_ITEMS 1 TOTAL_FREIGHT 2 TOTAL_QTY 2 TOTAL_SURCHARGE 2 NOTES 0
		PRINT_COUNT 1 PRINT_DATE 3 REPEAT_DAYS 1 REPEAT_MONTHS 1 STANDING_LAST_PROCESS 3 DEPT_ID 0
		REVERSAL_DATE 3 SECURITY_TYPE 0 STATUS_MISC 0 USER_ID 0}
	array set null_BATCH {COMPANY_ID 0 BATCH_NO 0 TYPE 0 STATUS 1 BRANCH_ID 0 TITLE 1
		MODULE 0 REF_NO 1 DATE 0 GL_UPDATE_BATCH 1 TOTAL_TOTAL 1 TOTAL_AMOUNT 1
		TOTAL_COST_OF_SALES 1 TOTAL_ITEMS 1 TOTAL_FREIGHT 1 TOTAL_QTY 1 TOTAL_SURCHARGE 1 NOTES 1
		PRINT_COUNT 1 PRINT_DATE 1 REPEAT_DAYS 1 REPEAT_MONTHS 1 STANDING_LAST_PROCESS 1 DEPT_ID 1
		REVERSAL_DATE 1 SECURITY_TYPE 1 STATUS_MISC 1 USER_ID 1}
	array set default_BATCH {COMPANY_ID {} BATCH_NO 0 TYPE {} STATUS {} BRANCH_ID {} TITLE {}
		MODULE {} REF_NO 0 DATE {0000-00-00 00:00:00} GL_UPDATE_BATCH 0 TOTAL_TOTAL 0.0 TOTAL_AMOUNT 0.0
		TOTAL_COST_OF_SALES 0.0 TOTAL_ITEMS 0 TOTAL_FREIGHT 0.0 TOTAL_QTY 0.0 TOTAL_SURCHARGE 0.0 NOTES {}
		PRINT_COUNT 0 PRINT_DATE {} REPEAT_DAYS 0 REPEAT_MONTHS 0 STANDING_LAST_PROCESS {} DEPT_ID {}
		REVERSAL_DATE {} SECURITY_TYPE {} STATUS_MISC {} USER_ID {}}

	set all_columns(BRANCH) {COMPANY_ID BRANCH_ID OFFICE_TYPE LAST_JOB_NO LAST_ORDER_NO LAST_PURCHASE_NO LAST_QUOTE_NO LAST_RETURN_NO
		NAME HOLD_STOCK LAST_BARCODE_NO ADDRESS AUTO_RECEIPT_TRANSFERS BARCODE_PREFIX CUSTOMER_ORDER_PREFIX FAX_NO
		GL_CODE HIDE_BRANCH LAST_LOCAL_PO_NO LAST_MISSHIPMENT_NO LAST_OSEAS_PO_NO LAST_PPP_CONTRACT_NO LAST_STANDING_PO_NO PHONE_NO
		PURCHASE_ORDER_PREFIX PURCHASE_SUFFIX SHORT_DESC CASH_SALES TAG}
	array set type_BRANCH {COMPANY_ID 0 BRANCH_ID 0 OFFICE_TYPE 0 LAST_JOB_NO 1 LAST_ORDER_NO 1 LAST_PURCHASE_NO 1
		LAST_QUOTE_NO 1 LAST_RETURN_NO 1 NAME 0 HOLD_STOCK 0 LAST_BARCODE_NO 1 ADDRESS 0
		AUTO_RECEIPT_TRANSFERS 0 BARCODE_PREFIX 0 CUSTOMER_ORDER_PREFIX 0 FAX_NO 0 GL_CODE 0 HIDE_BRANCH 0
		LAST_LOCAL_PO_NO 1 LAST_MISSHIPMENT_NO 1 LAST_OSEAS_PO_NO 1 LAST_PPP_CONTRACT_NO 1 LAST_STANDING_PO_NO 1 PHONE_NO 0
		PURCHASE_ORDER_PREFIX 0 PURCHASE_SUFFIX 0 SHORT_DESC 0 CASH_SALES 1 TAG 0}
	array set null_BRANCH {COMPANY_ID 0 BRANCH_ID 0 OFFICE_TYPE 1 LAST_JOB_NO 1 LAST_ORDER_NO 1 LAST_PURCHASE_NO 1
		LAST_QUOTE_NO 1 LAST_RETURN_NO 1 NAME 0 HOLD_STOCK 1 LAST_BARCODE_NO 1 ADDRESS 1
		AUTO_RECEIPT_TRANSFERS 1 BARCODE_PREFIX 1 CUSTOMER_ORDER_PREFIX 1 FAX_NO 1 GL_CODE 1 HIDE_BRANCH 1
		LAST_LOCAL_PO_NO 1 LAST_MISSHIPMENT_NO 1 LAST_OSEAS_PO_NO 1 LAST_PPP_CONTRACT_NO 1 LAST_STANDING_PO_NO 1 PHONE_NO 1
		PURCHASE_ORDER_PREFIX 1 PURCHASE_SUFFIX 1 SHORT_DESC 1 CASH_SALES 1 TAG 0}
	array set default_BRANCH {COMPANY_ID {} BRANCH_ID {} OFFICE_TYPE {} LAST_JOB_NO 0 LAST_ORDER_NO 0 LAST_PURCHASE_NO 0
		LAST_QUOTE_NO 0 LAST_RETURN_NO 0 NAME {} HOLD_STOCK {} LAST_BARCODE_NO 0 ADDRESS {}
		AUTO_RECEIPT_TRANSFERS {} BARCODE_PREFIX {} CUSTOMER_ORDER_PREFIX {} FAX_NO {} GL_CODE {} HIDE_BRANCH {}
		LAST_LOCAL_PO_NO 0 LAST_MISSHIPMENT_NO 0 LAST_OSEAS_PO_NO 0 LAST_PPP_CONTRACT_NO 0 LAST_STANDING_PO_NO 0 PHONE_NO {}
		PURCHASE_ORDER_PREFIX {} PURCHASE_SUFFIX {} SHORT_DESC {} CASH_SALES 0 TAG {}}

	set all_columns(BRANCH_BUDGETS) {BRANCH_ID COMPANY_ID YEAR SALES01 SALES02 SALES03 SALES04 SALES05
		SALES06 SALES07 SALES08 SALES09 SALES10 SALES11 SALES12}
	array set type_BRANCH_BUDGETS {BRANCH_ID 0 COMPANY_ID 0 YEAR 1 SALES01 2 SALES02 2 SALES03 2
		SALES04 2 SALES05 2 SALES06 2 SALES07 2 SALES08 2 SALES09 2
		SALES10 2 SALES11 2 SALES12 2}
	array set null_BRANCH_BUDGETS {BRANCH_ID 0 COMPANY_ID 0 YEAR 0 SALES01 1 SALES02 1 SALES03 1
		SALES04 1 SALES05 1 SALES06 1 SALES07 1 SALES08 1 SALES09 1
		SALES10 1 SALES11 1 SALES12 1}
	array set default_BRANCH_BUDGETS {BRANCH_ID {} COMPANY_ID {} YEAR 0 SALES01 0.0 SALES02 0.0 SALES03 0.0
		SALES04 0.0 SALES05 0.0 SALES06 0.0 SALES07 0.0 SALES08 0.0 SALES09 0.0
		SALES10 0.0 SALES11 0.0 SALES12 0.0}

	set all_columns(CALL_CYCLE) {COMPANY_ID CYCLE NAME}
	array set type_CALL_CYCLE {COMPANY_ID 0 CYCLE 0 NAME 0}
	array set null_CALL_CYCLE {COMPANY_ID 0 CYCLE 0 NAME 0}
	array set default_CALL_CYCLE {COMPANY_ID {} CYCLE {} NAME {}}

	set all_columns(CODE_BUDGETS) {CODE COMPANY_ID MODULE YEAR SALES01 SALES02 SALES03 SALES04
		SALES05 SALES06 SALES07 SALES08 SALES09 SALES10 SALES11 SALES12}
	array set type_CODE_BUDGETS {CODE 0 COMPANY_ID 0 MODULE 0 YEAR 1 SALES01 2 SALES02 2
		SALES03 2 SALES04 2 SALES05 2 SALES06 2 SALES07 2 SALES08 2
		SALES09 2 SALES10 2 SALES11 2 SALES12 2}
	array set null_CODE_BUDGETS {CODE 0 COMPANY_ID 0 MODULE 0 YEAR 0 SALES01 1 SALES02 1
		SALES03 1 SALES04 1 SALES05 1 SALES06 1 SALES07 1 SALES08 1
		SALES09 1 SALES10 1 SALES11 1 SALES12 1}
	array set default_CODE_BUDGETS {CODE {} COMPANY_ID {} MODULE {} YEAR 0 SALES01 0.0 SALES02 0.0
		SALES03 0.0 SALES04 0.0 SALES05 0.0 SALES06 0.0 SALES07 0.0 SALES08 0.0
		SALES09 0.0 SALES10 0.0 SALES11 0.0 SALES12 0.0}

	set all_columns(CODE_DATA) {HEADING_ID NUMBER COMPANY_ID MODULE VALUE}
	array set type_CODE_DATA {HEADING_ID 1 NUMBER 1 COMPANY_ID 0 MODULE 0 VALUE 0}
	array set null_CODE_DATA {HEADING_ID 0 NUMBER 0 COMPANY_ID 0 MODULE 0 VALUE 1}
	array set default_CODE_DATA {HEADING_ID 0 NUMBER 0 COMPANY_ID {} MODULE {} VALUE {}}

	set all_columns(CODE_HEADING) {ID COMPANY_ID MODULE CODE SEQUENCE DISPLAY HEADING}
	array set type_CODE_HEADING {ID 1 COMPANY_ID 0 MODULE 0 CODE 0 SEQUENCE 1 DISPLAY 0
		HEADING 0}
	array set null_CODE_HEADING {ID 0 COMPANY_ID 0 MODULE 0 CODE 0 SEQUENCE 0 DISPLAY 1
		HEADING 0}
	array set default_CODE_HEADING {ID {} COMPANY_ID {} MODULE {} CODE {} SEQUENCE 0 DISPLAY {}
		HEADING {}}

	set all_columns(COMPANY) {COMPANY_ID STATUS LAST_ORDER_NO LAST_PURCHASE_NO NEXT_SCHEDULED_UPDATE_NO NEXT_BATCH_NO NAME BRANCH_ID
		ADDRESS AP_MODULE AR_MODULE BRANCH_TRANSFERS CO_MODULE CURRENCY_CODE DEPT_ID FA_MODULE
		FAX_NO FINANCIAL_START_DATE GL_MODULE GST_NO IN_MODULE LAST_JOB_NO LAST_QUOTE_NO LAST_RETURN_NO
		OPEN_ITEM ORDER_NO_PER_COMPANY PHONE_NO PO_MODULE SERVICE_TYPE SS_MODULE TAX_CODE TAX_TYPE
		TAG}
	array set type_COMPANY {COMPANY_ID 0 STATUS 0 LAST_ORDER_NO 1 LAST_PURCHASE_NO 1 NEXT_SCHEDULED_UPDATE_NO 1 NEXT_BATCH_NO 1
		NAME 0 BRANCH_ID 0 ADDRESS 0 AP_MODULE 0 AR_MODULE 0 BRANCH_TRANSFERS 0
		CO_MODULE 0 CURRENCY_CODE 0 DEPT_ID 0 FA_MODULE 0 FAX_NO 0 FINANCIAL_START_DATE 3
		GL_MODULE 0 GST_NO 0 IN_MODULE 0 LAST_JOB_NO 1 LAST_QUOTE_NO 1 LAST_RETURN_NO 1
		OPEN_ITEM 0 ORDER_NO_PER_COMPANY 0 PHONE_NO 0 PO_MODULE 0 SERVICE_TYPE 0 SS_MODULE 0
		TAX_CODE 0 TAX_TYPE 0 TAG 0}
	array set null_COMPANY {COMPANY_ID 0 STATUS 1 LAST_ORDER_NO 1 LAST_PURCHASE_NO 1 NEXT_SCHEDULED_UPDATE_NO 1 NEXT_BATCH_NO 1
		NAME 0 BRANCH_ID 1 ADDRESS 1 AP_MODULE 1 AR_MODULE 1 BRANCH_TRANSFERS 1
		CO_MODULE 1 CURRENCY_CODE 1 DEPT_ID 1 FA_MODULE 1 FAX_NO 1 FINANCIAL_START_DATE 1
		GL_MODULE 1 GST_NO 1 IN_MODULE 1 LAST_JOB_NO 1 LAST_QUOTE_NO 1 LAST_RETURN_NO 1
		OPEN_ITEM 1 ORDER_NO_PER_COMPANY 1 PHONE_NO 1 PO_MODULE 1 SERVICE_TYPE 1 SS_MODULE 1
		TAX_CODE 1 TAX_TYPE 1 TAG 0}
	array set default_COMPANY {COMPANY_ID {} STATUS {} LAST_ORDER_NO 0 LAST_PURCHASE_NO 0 NEXT_SCHEDULED_UPDATE_NO 0 NEXT_BATCH_NO 0
		NAME {} BRANCH_ID {} ADDRESS {} AP_MODULE {} AR_MODULE {} BRANCH_TRANSFERS {}
		CO_MODULE {} CURRENCY_CODE {} DEPT_ID {} FA_MODULE {} FAX_NO {} FINANCIAL_START_DATE {}
		GL_MODULE {} GST_NO {} IN_MODULE {} LAST_JOB_NO 0 LAST_QUOTE_NO 0 LAST_RETURN_NO 0
		OPEN_ITEM {} ORDER_NO_PER_COMPANY 0 PHONE_NO {} PO_MODULE {} SERVICE_TYPE {} SS_MODULE {}
		TAX_CODE {} TAX_TYPE {} TAG {}}

	set all_columns(COMPONENTS) {COMPANY_ID PART COMPONENT QUANTITY}
	array set type_COMPONENTS {COMPANY_ID 0 PART 1 COMPONENT 1 QUANTITY 2}
	array set null_COMPONENTS {COMPANY_ID 0 PART 0 COMPONENT 0 QUANTITY 1}
	array set default_COMPONENTS {COMPANY_ID {} PART 0 COMPONENT 0 QUANTITY 0.0}

	set all_columns(CONTACT_ROLE) {COMPANY_ID MODULE ID NAME}
	array set type_CONTACT_ROLE {COMPANY_ID 0 MODULE 0 ID 1 NAME 0}
	array set null_CONTACT_ROLE {COMPANY_ID 0 MODULE 0 ID 0 NAME 0}
	array set default_CONTACT_ROLE {COMPANY_ID {} MODULE {} ID {} NAME {}}

	set all_columns(COURIER) {COMPANY_ID CODE NAME TYPE FREIGHT TAG}
	array set type_COURIER {COMPANY_ID 0 CODE 0 NAME 0 TYPE 0 FREIGHT 2 TAG 0}
	array set null_COURIER {COMPANY_ID 0 CODE 0 NAME 0 TYPE 1 FREIGHT 1 TAG 0}
	array set default_COURIER {COMPANY_ID {} CODE {} NAME {} TYPE {} FREIGHT 0.0 TAG {}}

	set all_columns(COURIER_CONTROL) {BRANCH COMPANY_ID TYPE LAST_TICKET_NO LAST_MANIFEST_BATCH COURIER_CODE COURIER_ID HIGH_TICKET_NO
		LAST_CHANGE_LOG LAST_TRACK_TRACE LOW_TICKET_NO SITE_ID TICKET_PREFIX TICKET_SUFFIX}
	array set type_COURIER_CONTROL {BRANCH 0 COMPANY_ID 0 TYPE 0 LAST_TICKET_NO 2 LAST_MANIFEST_BATCH 2 COURIER_CODE 0
		COURIER_ID 0 HIGH_TICKET_NO 2 LAST_CHANGE_LOG 0 LAST_TRACK_TRACE 3 LOW_TICKET_NO 2 SITE_ID 0
		TICKET_PREFIX 0 TICKET_SUFFIX 0}
	array set null_COURIER_CONTROL {BRANCH 0 COMPANY_ID 0 TYPE 0 LAST_TICKET_NO 1 LAST_MANIFEST_BATCH 1 COURIER_CODE 1
		COURIER_ID 1 HIGH_TICKET_NO 1 LAST_CHANGE_LOG 1 LAST_TRACK_TRACE 1 LOW_TICKET_NO 1 SITE_ID 1
		TICKET_PREFIX 1 TICKET_SUFFIX 1}
	array set default_COURIER_CONTROL {BRANCH {} COMPANY_ID {} TYPE {} LAST_TICKET_NO 0.0 LAST_MANIFEST_BATCH 0.0 COURIER_CODE {}
		COURIER_ID {} HIGH_TICKET_NO 0.0 LAST_CHANGE_LOG {} LAST_TRACK_TRACE {} LOW_TICKET_NO 0.0 SITE_ID {}
		TICKET_PREFIX {} TICKET_SUFFIX {}}

	set all_columns(COURIER_DESTINATION) {COMPANY_ID TYPE BRANCH DESTINATION CITY_CODE DESCRIPTION DISTANCE ZONE}
	array set type_COURIER_DESTINATION {COMPANY_ID 0 TYPE 0 BRANCH 0 DESTINATION 0 CITY_CODE 0 DESCRIPTION 0
		DISTANCE 2 ZONE 0}
	array set null_COURIER_DESTINATION {COMPANY_ID 0 TYPE 0 BRANCH 0 DESTINATION 0 CITY_CODE 1 DESCRIPTION 1
		DISTANCE 1 ZONE 1}
	array set default_COURIER_DESTINATION {COMPANY_ID {} TYPE {} BRANCH {} DESTINATION {} CITY_CODE {} DESCRIPTION {}
		DISTANCE 0.0 ZONE {}}

	set all_columns(COURIER_PRODUCT) {COMPANY_ID TYPE CODE WEIGHT DISTANCE NAME PRICE}
	array set type_COURIER_PRODUCT {COMPANY_ID 0 TYPE 0 CODE 0 WEIGHT 2 DISTANCE 2 NAME 0
		PRICE 2}
	array set null_COURIER_PRODUCT {COMPANY_ID 0 TYPE 0 CODE 0 WEIGHT 1 DISTANCE 1 NAME 0
		PRICE 1}
	array set default_COURIER_PRODUCT {COMPANY_ID {} TYPE {} CODE {} WEIGHT 0.0 DISTANCE 0.0 NAME {}
		PRICE 0.0}

	set all_columns(COURIER_SERVICE) {COMPANY_ID TYPE DEFAULT_SERVICE NAME CODE BRANCH ID INCREMENTAL_CHARGE
		INCREMENTAL_WEIGHT MINIMUM_CHARGE MINIMUM_WEIGHT STANDARD_CHARGE STANDARD_WEIGHT TICKET_NAME ZONE}
	array set type_COURIER_SERVICE {COMPANY_ID 0 TYPE 0 DEFAULT_SERVICE 0 NAME 0 CODE 0 BRANCH 0
		ID 1 INCREMENTAL_CHARGE 2 INCREMENTAL_WEIGHT 2 MINIMUM_CHARGE 2 MINIMUM_WEIGHT 2 STANDARD_CHARGE 2
		STANDARD_WEIGHT 2 TICKET_NAME 0 ZONE 0}
	array set null_COURIER_SERVICE {COMPANY_ID 0 TYPE 0 DEFAULT_SERVICE 1 NAME 0 CODE 0 BRANCH 1
		ID 0 INCREMENTAL_CHARGE 1 INCREMENTAL_WEIGHT 1 MINIMUM_CHARGE 1 MINIMUM_WEIGHT 1 STANDARD_CHARGE 1
		STANDARD_WEIGHT 1 TICKET_NAME 1 ZONE 1}
	array set default_COURIER_SERVICE {COMPANY_ID {} TYPE {} DEFAULT_SERVICE {} NAME {} CODE {} BRANCH {}
		ID {} INCREMENTAL_CHARGE 0.0 INCREMENTAL_WEIGHT 0.0 MINIMUM_CHARGE 0.0 MINIMUM_WEIGHT 0.0 STANDARD_CHARGE 0.0
		STANDARD_WEIGHT 0.0 TICKET_NAME {} ZONE {}}

	set all_columns(COURIER_TICKET_STATUS) {COMPANY_ID NAME TYPE STATUS}
	array set type_COURIER_TICKET_STATUS {COMPANY_ID 0 NAME 0 TYPE 0 STATUS 0}
	array set null_COURIER_TICKET_STATUS {COMPANY_ID 0 NAME 1 TYPE 0 STATUS 0}
	array set default_COURIER_TICKET_STATUS {COMPANY_ID {} NAME {} TYPE {} STATUS {}}

	set all_columns(CURRENCY) {BALANCE_CURRENCY CODE NAME LATEST_DATE LATEST_RATE WORKING_RATE TAG}
	array set type_CURRENCY {BALANCE_CURRENCY 0 CODE 0 NAME 0 LATEST_DATE 3 LATEST_RATE 2 WORKING_RATE 2
		TAG 0}
	array set null_CURRENCY {BALANCE_CURRENCY 0 CODE 0 NAME 0 LATEST_DATE 1 LATEST_RATE 1 WORKING_RATE 1
		TAG 0}
	array set default_CURRENCY {BALANCE_CURRENCY NZD CODE {} NAME {} LATEST_DATE {} LATEST_RATE 0.0 WORKING_RATE 0.0
		TAG {}}

	set all_columns(CURRENCY_RATES) {BALANCE_CURRENCY CODE DATE EXCHANGE_RATE}
	array set type_CURRENCY_RATES {BALANCE_CURRENCY 0 CODE 0 DATE 3 EXCHANGE_RATE 2}
	array set null_CURRENCY_RATES {BALANCE_CURRENCY 0 CODE 0 DATE 0 EXCHANGE_RATE 1}
	array set default_CURRENCY_RATES {BALANCE_CURRENCY NZD CODE {} DATE {0000-00-00 00:00:00} EXCHANGE_RATE 0.0}

	set all_columns(CUSTOMER_ADDRESS) {ID COMPANY_ID CUSTOMER DEFAULT_ADDRESS ADDRESS SALESMAN ROLE DELIVERY_NAME
		STORE_CODE CONTACT RECORD_TYPE LAST_ORDER_DATE ADDITIONAL_INFO CALL_CYCLE EMAIL_ADDRESS EQUIPMENT_DETAILS
		FAX_NO LAST_CONTACT_DATE MARKETING_CODE MOBILE_NO NEXT_CONTACT_DATE PHONE_NO POST_CODE SPAM_1
		SPAM_2 SPAM_3 SPAM_4 SPAM_5 SPAM_NOTE SPAM_OK SUPPRESS_REPORTING}
	array set type_CUSTOMER_ADDRESS {ID 1 COMPANY_ID 0 CUSTOMER 1 DEFAULT_ADDRESS 0 ADDRESS 0 SALESMAN 0
		ROLE 1 DELIVERY_NAME 0 STORE_CODE 0 CONTACT 0 RECORD_TYPE 0 LAST_ORDER_DATE 3
		ADDITIONAL_INFO 0 CALL_CYCLE 0 EMAIL_ADDRESS 0 EQUIPMENT_DETAILS 0 FAX_NO 0 LAST_CONTACT_DATE 3
		MARKETING_CODE 0 MOBILE_NO 0 NEXT_CONTACT_DATE 3 PHONE_NO 0 POST_CODE 0 SPAM_1 0
		SPAM_2 0 SPAM_3 0 SPAM_4 0 SPAM_5 0 SPAM_NOTE 0 SPAM_OK 0
		SUPPRESS_REPORTING 0}
	array set null_CUSTOMER_ADDRESS {ID 0 COMPANY_ID 0 CUSTOMER 0 DEFAULT_ADDRESS 1 ADDRESS 1 SALESMAN 1
		ROLE 1 DELIVERY_NAME 1 STORE_CODE 1 CONTACT 1 RECORD_TYPE 1 LAST_ORDER_DATE 1
		ADDITIONAL_INFO 1 CALL_CYCLE 1 EMAIL_ADDRESS 1 EQUIPMENT_DETAILS 1 FAX_NO 1 LAST_CONTACT_DATE 1
		MARKETING_CODE 1 MOBILE_NO 1 NEXT_CONTACT_DATE 1 PHONE_NO 1 POST_CODE 1 SPAM_1 1
		SPAM_2 1 SPAM_3 1 SPAM_4 1 SPAM_5 1 SPAM_NOTE 1 SPAM_OK 1
		SUPPRESS_REPORTING 1}
	array set default_CUSTOMER_ADDRESS {ID {} COMPANY_ID {} CUSTOMER 0 DEFAULT_ADDRESS {} ADDRESS {} SALESMAN {}
		ROLE 0 DELIVERY_NAME {} STORE_CODE {} CONTACT {} RECORD_TYPE {} LAST_ORDER_DATE {}
		ADDITIONAL_INFO {} CALL_CYCLE {} EMAIL_ADDRESS {} EQUIPMENT_DETAILS {} FAX_NO {} LAST_CONTACT_DATE {}
		MARKETING_CODE {} MOBILE_NO {} NEXT_CONTACT_DATE {} PHONE_NO {} POST_CODE {} SPAM_1 {}
		SPAM_2 {} SPAM_3 {} SPAM_4 {} SPAM_5 {} SPAM_NOTE {} SPAM_OK {}
		SUPPRESS_REPORTING {}}

	set all_columns(CUSTOMER_CATEGORIES) {CODE COMPANY_ID CUSTOMER ID NOTE STATUS}
	array set type_CUSTOMER_CATEGORIES {CODE 0 COMPANY_ID 0 CUSTOMER 1 ID 1 NOTE 0 STATUS 0}
	array set null_CUSTOMER_CATEGORIES {CODE 0 COMPANY_ID 0 CUSTOMER 0 ID 0 NOTE 1 STATUS 1}
	array set default_CUSTOMER_CATEGORIES {CODE {} COMPANY_ID {} CUSTOMER 0 ID {} NOTE {} STATUS {}}

	set all_columns(CUSTOMER_DISCOUNT) {COMPANY_ID CUSTOMER PART CUSTOMER_PART PRICE_LEVEL SUPPLIER_REBATE CUSTOMER_BARCODE DISCOUNT
		FINISH_DATE NOTE QTY_BREAK1 QTY_BREAK2 QTY_BREAK3 QTY_BREAK4 QTY_BREAK5 QTY_DISCOUNT1
		QTY_DISCOUNT2 QTY_DISCOUNT3 QTY_DISCOUNT4 QTY_DISCOUNT5 REFERENCE SPECIAL_PRICE UPDATE_DATE UPDATE_USER}
	array set type_CUSTOMER_DISCOUNT {COMPANY_ID 0 CUSTOMER 1 PART 1 CUSTOMER_PART 0 PRICE_LEVEL 1 SUPPLIER_REBATE 2
		CUSTOMER_BARCODE 0 DISCOUNT 2 FINISH_DATE 3 NOTE 0 QTY_BREAK1 2 QTY_BREAK2 2
		QTY_BREAK3 2 QTY_BREAK4 2 QTY_BREAK5 2 QTY_DISCOUNT1 2 QTY_DISCOUNT2 2 QTY_DISCOUNT3 2
		QTY_DISCOUNT4 2 QTY_DISCOUNT5 2 REFERENCE 0 SPECIAL_PRICE 2 UPDATE_DATE 3 UPDATE_USER 0}
	array set null_CUSTOMER_DISCOUNT {COMPANY_ID 0 CUSTOMER 0 PART 0 CUSTOMER_PART 1 PRICE_LEVEL 1 SUPPLIER_REBATE 1
		CUSTOMER_BARCODE 1 DISCOUNT 1 FINISH_DATE 1 NOTE 1 QTY_BREAK1 1 QTY_BREAK2 1
		QTY_BREAK3 1 QTY_BREAK4 1 QTY_BREAK5 1 QTY_DISCOUNT1 1 QTY_DISCOUNT2 1 QTY_DISCOUNT3 1
		QTY_DISCOUNT4 1 QTY_DISCOUNT5 1 REFERENCE 1 SPECIAL_PRICE 1 UPDATE_DATE 1 UPDATE_USER 1}
	array set default_CUSTOMER_DISCOUNT {COMPANY_ID {} CUSTOMER 0 PART 0 CUSTOMER_PART {} PRICE_LEVEL 0 SUPPLIER_REBATE 0.0
		CUSTOMER_BARCODE {} DISCOUNT 0.0 FINISH_DATE {} NOTE {} QTY_BREAK1 0.0 QTY_BREAK2 0.0
		QTY_BREAK3 0.0 QTY_BREAK4 0.0 QTY_BREAK5 0.0 QTY_DISCOUNT1 0.0 QTY_DISCOUNT2 0.0 QTY_DISCOUNT3 0.0
		QTY_DISCOUNT4 0.0 QTY_DISCOUNT5 0.0 REFERENCE {} SPECIAL_PRICE 0.0 UPDATE_DATE {} UPDATE_USER {}}

	set all_columns(CUSTOMER_DISCOUNT2) {COMPANY_ID CUSTOMER TYPE CODE DISCOUNT FINISH_DATE PRICE_LEVEL UPDATE_DATE}
	array set type_CUSTOMER_DISCOUNT2 {COMPANY_ID 0 CUSTOMER 1 TYPE 0 CODE 0 DISCOUNT 2 FINISH_DATE 3
		PRICE_LEVEL 1 UPDATE_DATE 3}
	array set null_CUSTOMER_DISCOUNT2 {COMPANY_ID 0 CUSTOMER 0 TYPE 0 CODE 1 DISCOUNT 1 FINISH_DATE 1
		PRICE_LEVEL 1 UPDATE_DATE 1}
	array set default_CUSTOMER_DISCOUNT2 {COMPANY_ID {} CUSTOMER 0 TYPE {} CODE {} DISCOUNT 0.0 FINISH_DATE {}
		PRICE_LEVEL 0 UPDATE_DATE {}}

	set all_columns(CUSTOMER_EXTRAS) {COMPANY_ID CUSTOMER CATALOG_NO CATALOG_SENT DISABLE_IF_OVERDUE DISABLE_OVERDUE_DAYS EMPLOYEE_COUNT_HIGH EMPLOYEE_COUNT_LOW
		ORDER_NOTIFICATION_EMAIL ORDER_STATUS_NOTIFICATIONS PRICE_CHANGE_NOTIFICATIONS PRICE_DECIMALS SINGLE_INVOICE_PER_ORDER}
	array set type_CUSTOMER_EXTRAS {COMPANY_ID 0 CUSTOMER 1 CATALOG_NO 0 CATALOG_SENT 0 DISABLE_IF_OVERDUE 0 DISABLE_OVERDUE_DAYS 1
		EMPLOYEE_COUNT_HIGH 0 EMPLOYEE_COUNT_LOW 0 ORDER_NOTIFICATION_EMAIL 0 ORDER_STATUS_NOTIFICATIONS 0 PRICE_CHANGE_NOTIFICATIONS 0 PRICE_DECIMALS 0
		SINGLE_INVOICE_PER_ORDER 0}
	array set null_CUSTOMER_EXTRAS {COMPANY_ID 0 CUSTOMER 0 CATALOG_NO 1 CATALOG_SENT 1 DISABLE_IF_OVERDUE 1 DISABLE_OVERDUE_DAYS 1
		EMPLOYEE_COUNT_HIGH 1 EMPLOYEE_COUNT_LOW 1 ORDER_NOTIFICATION_EMAIL 1 ORDER_STATUS_NOTIFICATIONS 0 PRICE_CHANGE_NOTIFICATIONS 1 PRICE_DECIMALS 1
		SINGLE_INVOICE_PER_ORDER 1}
	array set default_CUSTOMER_EXTRAS {COMPANY_ID {} CUSTOMER {} CATALOG_NO {} CATALOG_SENT {} DISABLE_IF_OVERDUE {} DISABLE_OVERDUE_DAYS 0
		EMPLOYEE_COUNT_HIGH {} EMPLOYEE_COUNT_LOW {} ORDER_NOTIFICATION_EMAIL {} ORDER_STATUS_NOTIFICATIONS 0 PRICE_CHANGE_NOTIFICATIONS {} PRICE_DECIMALS {}
		SINGLE_INVOICE_PER_ORDER {}}

	set all_columns(CUSTOMER_PRICE_BOOK) {COMPANY_ID CUSTOMER EMAIL FREQUENCY LAST_EXPORT_NO LAST_UPDATE OPTIONS PRODUCTS_TO_EXPORT
		TYPE_OF_EXPORT UPDATE_TYPE}
	array set type_CUSTOMER_PRICE_BOOK {COMPANY_ID 0 CUSTOMER 1 EMAIL 0 FREQUENCY 0 LAST_EXPORT_NO 1 LAST_UPDATE 3
		OPTIONS 0 PRODUCTS_TO_EXPORT 0 TYPE_OF_EXPORT 0 UPDATE_TYPE 0}
	array set null_CUSTOMER_PRICE_BOOK {COMPANY_ID 0 CUSTOMER 0 EMAIL 1 FREQUENCY 1 LAST_EXPORT_NO 1 LAST_UPDATE 1
		OPTIONS 1 PRODUCTS_TO_EXPORT 1 TYPE_OF_EXPORT 1 UPDATE_TYPE 1}
	array set default_CUSTOMER_PRICE_BOOK {COMPANY_ID {} CUSTOMER 0 EMAIL {} FREQUENCY {} LAST_EXPORT_NO 0 LAST_UPDATE {}
		OPTIONS {} PRODUCTS_TO_EXPORT {} TYPE_OF_EXPORT {} UPDATE_TYPE {}}

	set all_columns(CUSTOMER_TYPE_DISCOUNT) {COMPANY_ID AR_TYPE IN_TYPE DISCOUNT}
	array set type_CUSTOMER_TYPE_DISCOUNT {COMPANY_ID 0 AR_TYPE 0 IN_TYPE 0 DISCOUNT 2}
	array set null_CUSTOMER_TYPE_DISCOUNT {COMPANY_ID 0 AR_TYPE 0 IN_TYPE 0 DISCOUNT 1}
	array set default_CUSTOMER_TYPE_DISCOUNT {COMPANY_ID {} AR_TYPE {} IN_TYPE {} DISCOUNT 0.0}

	set all_columns(DEPT) {COMPANY_ID DEPT_ID GL_CODE NAME}
	array set type_DEPT {COMPANY_ID 0 DEPT_ID 0 GL_CODE 0 NAME 0}
	array set null_DEPT {COMPANY_ID 0 DEPT_ID 0 GL_CODE 1 NAME 0}
	array set default_DEPT {COMPANY_ID {} DEPT_ID {} GL_CODE {} NAME {}}

	set all_columns(FOLLOW_UP_NOTE) {NOTE_ID SORT_SEQUENCE COMPANY_ID TEXT REF REF_TYPE SUBJECT UPDATED_DATE
		ENTERED_BY UPDATED_BY DATE}
	array set type_FOLLOW_UP_NOTE {NOTE_ID 1 SORT_SEQUENCE 0 COMPANY_ID 0 TEXT 0 REF 0 REF_TYPE 0
		SUBJECT 0 UPDATED_DATE 3 ENTERED_BY 0 UPDATED_BY 0 DATE 3}
	array set null_FOLLOW_UP_NOTE {NOTE_ID 0 SORT_SEQUENCE 0 COMPANY_ID 0 TEXT 1 REF 1 REF_TYPE 1
		SUBJECT 1 UPDATED_DATE 1 ENTERED_BY 1 UPDATED_BY 1 DATE 1}
	array set default_FOLLOW_UP_NOTE {NOTE_ID {} SORT_SEQUENCE {} COMPANY_ID {} TEXT {} REF {} REF_TYPE {}
		SUBJECT {} UPDATED_DATE {} ENTERED_BY {} UPDATED_BY {} DATE {}}

	set all_columns(GL_UPDATE) {COMPANY_ID UPDATE_BATCH ACCOUNT HEADER REF_NO BATCH_NO AMOUNT}
	array set type_GL_UPDATE {COMPANY_ID 0 UPDATE_BATCH 1 ACCOUNT 1 HEADER 0 REF_NO 1 BATCH_NO 1
		AMOUNT 2}
	array set null_GL_UPDATE {COMPANY_ID 0 UPDATE_BATCH 0 ACCOUNT 0 HEADER 0 REF_NO 1 BATCH_NO 1
		AMOUNT 1}
	array set default_GL_UPDATE {COMPANY_ID {} UPDATE_BATCH 0 ACCOUNT 0 HEADER {} REF_NO 0 BATCH_NO 0
		AMOUNT 0.0}

	set all_columns(INSTRUMENT) {COMPANY_ID EVENT_DATE EVENT_NAME USER_ID EVENT_COUNT}
	array set type_INSTRUMENT {COMPANY_ID 0 EVENT_DATE 3 EVENT_NAME 0 USER_ID 0 EVENT_COUNT 1}
	array set null_INSTRUMENT {COMPANY_ID 0 EVENT_DATE 0 EVENT_NAME 0 USER_ID 0 EVENT_COUNT 1}
	array set default_INSTRUMENT {COMPANY_ID {} EVENT_DATE {} EVENT_NAME {} USER_ID {} EVENT_COUNT 0}

	set all_columns(JOB_EQUIPMENT) {COMPANY_ID PART REF SERIAL_NO DATE DESCRIPTION ID NOTE
		OTHER1 OTHER2 OTHER3 PART_NUMBER}
	array set type_JOB_EQUIPMENT {COMPANY_ID 0 PART 0 REF 0 SERIAL_NO 0 DATE 3 DESCRIPTION 0
		ID 1 NOTE 0 OTHER1 0 OTHER2 0 OTHER3 0 PART_NUMBER 1}
	array set null_JOB_EQUIPMENT {COMPANY_ID 0 PART 0 REF 0 SERIAL_NO 1 DATE 1 DESCRIPTION 1
		ID 0 NOTE 1 OTHER1 1 OTHER2 1 OTHER3 1 PART_NUMBER 1}
	array set default_JOB_EQUIPMENT {COMPANY_ID {} PART {} REF {} SERIAL_NO {} DATE {} DESCRIPTION {}
		ID {} NOTE {} OTHER1 {} OTHER2 {} OTHER3 {} PART_NUMBER 0}

	set all_columns(JOB_NOTE) {COMPANY_ID REF PRINT DATE ID TEXT USER}
	array set type_JOB_NOTE {COMPANY_ID 0 REF 0 PRINT 0 DATE 3 ID 1 TEXT 0
		USER 0}
	array set null_JOB_NOTE {COMPANY_ID 0 REF 0 PRINT 1 DATE 1 ID 0 TEXT 1
		USER 1}
	array set default_JOB_NOTE {COMPANY_ID {} REF {} PRINT {} DATE {} ID {} TEXT {}
		USER {}}

	set all_columns(LAYOUT) {COMPANY_ID LAYOUT MODULE NAME CODE}
	array set type_LAYOUT {COMPANY_ID 0 LAYOUT 0 MODULE 0 NAME 0 CODE 0}
	array set null_LAYOUT {COMPANY_ID 0 LAYOUT 0 MODULE 0 NAME 0 CODE 1}
	array set default_LAYOUT {COMPANY_ID {} LAYOUT {} MODULE {} NAME {} CODE {}}

	set all_columns(LOG) {ID COMPANY_ID USER_ID TEXT DATE BRANCH}
	array set type_LOG {ID 1 COMPANY_ID 0 USER_ID 0 TEXT 0 DATE 3 BRANCH 0}
	array set null_LOG {ID 0 COMPANY_ID 1 USER_ID 1 TEXT 0 DATE 0 BRANCH 1}
	array set default_LOG {ID {} COMPANY_ID {} USER_ID {} TEXT {} DATE {0000-00-00 00:00:00} BRANCH {}}

	set all_columns(MAIN_NOTE) {COMPANY_ID MODULE NUMBER TYPE ID STATUS ASSIGNED_TO SUB_TYPE
		PUBLIC UPDATED_DATE DATE START_DATE FINISH_DATE APPOINTMENT_DATE REF REF_TYPE
		TEXT CALL_TYPE CONTACT_ID ENTERED_BY EXPIRY_DATE PRIORITY SUBJECT UPDATED_BY}
	array set type_MAIN_NOTE {COMPANY_ID 0 MODULE 0 NUMBER 1 TYPE 0 ID 1 STATUS 0
		ASSIGNED_TO 0 SUB_TYPE 0 PUBLIC 0 UPDATED_DATE 3 DATE 3 START_DATE 3
		FINISH_DATE 3 APPOINTMENT_DATE 3 REF 0 REF_TYPE 0 TEXT 0 CALL_TYPE 0
		CONTACT_ID 1 ENTERED_BY 0 EXPIRY_DATE 3 PRIORITY 0 SUBJECT 0 UPDATED_BY 0}
	array set null_MAIN_NOTE {COMPANY_ID 0 MODULE 0 NUMBER 0 TYPE 1 ID 0 STATUS 0
		ASSIGNED_TO 1 SUB_TYPE 1 PUBLIC 1 UPDATED_DATE 1 DATE 1 START_DATE 1
		FINISH_DATE 1 APPOINTMENT_DATE 1 REF 1 REF_TYPE 1 TEXT 1 CALL_TYPE 1
		CONTACT_ID 1 ENTERED_BY 1 EXPIRY_DATE 1 PRIORITY 1 SUBJECT 1 UPDATED_BY 1}
	array set default_MAIN_NOTE {COMPANY_ID {} MODULE {} NUMBER {} TYPE {} ID {} STATUS {}
		ASSIGNED_TO {} SUB_TYPE {} PUBLIC {} UPDATED_DATE {} DATE {} START_DATE {}
		FINISH_DATE {} APPOINTMENT_DATE {} REF {} REF_TYPE {} TEXT {} CALL_TYPE {}
		CONTACT_ID 0 ENTERED_BY {} EXPIRY_DATE {} PRIORITY {} SUBJECT {} UPDATED_BY {}}

	set all_columns(MARKETING_CODES) {COMPANY_ID NAME MARKETING_CODE}
	array set type_MARKETING_CODES {COMPANY_ID 0 NAME 0 MARKETING_CODE 0}
	array set null_MARKETING_CODES {COMPANY_ID 0 NAME 0 MARKETING_CODE 0}
	array set default_MARKETING_CODES {COMPANY_ID {} NAME {} MARKETING_CODE {}}

	set all_columns(MASTER) {MODULE COMPANY_ID NUMBER PART DELETED ALPHA_SORT_SEQUENCE TYPE PARENT_COMPANY
		MASTER_ACCOUNT ZERO_DATE CODE MAIN_SUPPLIER NON_DIMINISHING SEQUENCE RATING NAME
		WEB_DISPLAY CONTROL_FLAG BALANCE_CURRENCY INVOICE_PRINT BRANCH PRINT_STATEMENT DISABLED AREA
		SUPERSEDING_PART CHARGE_FREIGHT MAIN_COURIER LOCATION SERIAL_TRACKING SELL_PRICE2 PARENT_DISCOUNTS BALANCE_TYPE
		SUBTYPE TAXABLE MAXIMUM_DAYS_CREDIT NON_STOCK PRIVACY_REQUESTED TAX_CODE CHEQUE_BANK CHEQUE_BRANCH
		CHEQUE_DRAWER DATE_OPENED LAST_PURCHASE_DATE MAIN_PAYMENT_TERMS POST_CODE PRICING_CURRENCY SUPPLIER_DESCRIPTION SUPPLIER_DISCOUNT
		SUPPLIER_LIST_PRICE SUPPLIER_PART_NO ADDRESS AUTOMATIC_PRICE_UPDATING AVERAGE_COST BANK_ACCOUNT BANK_OUTPUT_FILE CALL_CYCLE
		CONTACT_NAME COSTING_MULTIPLIER CREDIT_LIMIT CUBIC DEFAULT_DISCOUNT DEFAULT_LEAD_TIME DEFAULT_NOTIFICATION DEFAULT_PRICE_LEVEL
		DEPT EMAIL1 EMAIL2 EMAIL_ADDRESS EXTRA_DETAIL FAX_NO ISO_QUALIFICATION LAST_ORDER_REFERENCE
		LEAD_TIME MAIN_COMMERCIAL_TERMS MAIN_SHIPPING_METHOD MARGIN_EXEMPT MARKETING_CODE MAXIMUM_DISCOUNT MINIMUM_ORDER_VALUE MOBILE_NO
		NAME2 NON_DISCOUNTABLE ORDER_NO_REQUIRED ORDER_STATIONERY_FORM PACK_QUANTITY PACKING_SLIP_STATIONERY PARENT_ASSET PAYEE_NAME
		PAYMENT_METHOD PHONE_NO PRICE_CODE PROMPT_PAYMENT_DISCOUNT PURCHASE_MESSAGE PURCHASE_PRICE QTY_BREAK1 QTY_BREAK2
		QTY_BREAK3 QTY_BREAK4 QTY_BREAK5 QTY_DISCOUNT1 QTY_DISCOUNT2 QTY_DISCOUNT3 QTY_DISCOUNT4 QTY_DISCOUNT5
		REPLACEMENT_COST SALES_MESSAGE SELL_PRICE1 SELL_PRICE3 SELL_PRICE4 SELL_PRICE5 SELL_PRICE6 SELL_PRICE7
		SELL_PRICE8 SELL_PRICE9 SELL_PRICE10 SEND_INVOICE SERIAL_NUMBER STATEMENT_ID SUPPLIER_CODE UNIT_MEASURE
		WEB_SITE WEIGHT QTY_ON_HAND TAG LAST_PAYMENT_DATE LAST_SALE_DATE}
	array set type_MASTER {MODULE 0 COMPANY_ID 0 NUMBER 1 PART 0 DELETED 0 ALPHA_SORT_SEQUENCE 0
		TYPE 0 PARENT_COMPANY 1 MASTER_ACCOUNT 1 ZERO_DATE 3 CODE 0 MAIN_SUPPLIER 1
		NON_DIMINISHING 0 SEQUENCE 0 RATING 0 NAME 0 WEB_DISPLAY 0 CONTROL_FLAG 0
		BALANCE_CURRENCY 0 INVOICE_PRINT 0 BRANCH 0 PRINT_STATEMENT 0 DISABLED 0 AREA 0
		SUPERSEDING_PART 1 CHARGE_FREIGHT 0 MAIN_COURIER 0 LOCATION 0 SERIAL_TRACKING 0 SELL_PRICE2 2
		PARENT_DISCOUNTS 0 BALANCE_TYPE 0 SUBTYPE 0 TAXABLE 0 MAXIMUM_DAYS_CREDIT 1 NON_STOCK 0
		PRIVACY_REQUESTED 0 TAX_CODE 0 CHEQUE_BANK 0 CHEQUE_BRANCH 0 CHEQUE_DRAWER 0 DATE_OPENED 3
		LAST_PURCHASE_DATE 3 MAIN_PAYMENT_TERMS 0 POST_CODE 0 PRICING_CURRENCY 0 SUPPLIER_DESCRIPTION 0 SUPPLIER_DISCOUNT 2
		SUPPLIER_LIST_PRICE 2 SUPPLIER_PART_NO 0 ADDRESS 0 AUTOMATIC_PRICE_UPDATING 0 AVERAGE_COST 2 BANK_ACCOUNT 0
		BANK_OUTPUT_FILE 0 CALL_CYCLE 0 CONTACT_NAME 0 COSTING_MULTIPLIER 2 CREDIT_LIMIT 2 CUBIC 2
		DEFAULT_DISCOUNT 2 DEFAULT_LEAD_TIME 2 DEFAULT_NOTIFICATION 0 DEFAULT_PRICE_LEVEL 1 DEPT 0 EMAIL1 0
		EMAIL2 0 EMAIL_ADDRESS 0 EXTRA_DETAIL 0 FAX_NO 0 ISO_QUALIFICATION 0 LAST_ORDER_REFERENCE 0
		LEAD_TIME 2 MAIN_COMMERCIAL_TERMS 0 MAIN_SHIPPING_METHOD 0 MARGIN_EXEMPT 0 MARKETING_CODE 0 MAXIMUM_DISCOUNT 2
		MINIMUM_ORDER_VALUE 2 MOBILE_NO 0 NAME2 0 NON_DISCOUNTABLE 0 ORDER_NO_REQUIRED 0 ORDER_STATIONERY_FORM 0
		PACK_QUANTITY 2 PACKING_SLIP_STATIONERY 0 PARENT_ASSET 1 PAYEE_NAME 0 PAYMENT_METHOD 0 PHONE_NO 0
		PRICE_CODE 0 PROMPT_PAYMENT_DISCOUNT 2 PURCHASE_MESSAGE 0 PURCHASE_PRICE 2 QTY_BREAK1 2 QTY_BREAK2 2
		QTY_BREAK3 2 QTY_BREAK4 2 QTY_BREAK5 2 QTY_DISCOUNT1 2 QTY_DISCOUNT2 2 QTY_DISCOUNT3 2
		QTY_DISCOUNT4 2 QTY_DISCOUNT5 2 REPLACEMENT_COST 2 SALES_MESSAGE 0 SELL_PRICE1 2 SELL_PRICE3 2
		SELL_PRICE4 2 SELL_PRICE5 2 SELL_PRICE6 2 SELL_PRICE7 2 SELL_PRICE8 2 SELL_PRICE9 2
		SELL_PRICE10 2 SEND_INVOICE 0 SERIAL_NUMBER 0 STATEMENT_ID 0 SUPPLIER_CODE 0 UNIT_MEASURE 0
		WEB_SITE 0 WEIGHT 2 QTY_ON_HAND 2 TAG 0 LAST_PAYMENT_DATE 3 LAST_SALE_DATE 3}
	array set null_MASTER {MODULE 0 COMPANY_ID 0 NUMBER 0 PART 0 DELETED 1 ALPHA_SORT_SEQUENCE 1
		TYPE 1 PARENT_COMPANY 1 MASTER_ACCOUNT 1 ZERO_DATE 1 CODE 1 MAIN_SUPPLIER 1
		NON_DIMINISHING 1 SEQUENCE 1 RATING 1 NAME 0 WEB_DISPLAY 1 CONTROL_FLAG 1
		BALANCE_CURRENCY 1 INVOICE_PRINT 1 BRANCH 1 PRINT_STATEMENT 1 DISABLED 1 AREA 1
		SUPERSEDING_PART 1 CHARGE_FREIGHT 1 MAIN_COURIER 1 LOCATION 1 SERIAL_TRACKING 1 SELL_PRICE2 1
		PARENT_DISCOUNTS 1 BALANCE_TYPE 1 SUBTYPE 1 TAXABLE 1 MAXIMUM_DAYS_CREDIT 1 NON_STOCK 1
		PRIVACY_REQUESTED 1 TAX_CODE 1 CHEQUE_BANK 1 CHEQUE_BRANCH 1 CHEQUE_DRAWER 1 DATE_OPENED 1
		LAST_PURCHASE_DATE 1 MAIN_PAYMENT_TERMS 1 POST_CODE 1 PRICING_CURRENCY 1 SUPPLIER_DESCRIPTION 1 SUPPLIER_DISCOUNT 1
		SUPPLIER_LIST_PRICE 1 SUPPLIER_PART_NO 1 ADDRESS 1 AUTOMATIC_PRICE_UPDATING 1 AVERAGE_COST 1 BANK_ACCOUNT 1
		BANK_OUTPUT_FILE 1 CALL_CYCLE 1 CONTACT_NAME 1 COSTING_MULTIPLIER 1 CREDIT_LIMIT 1 CUBIC 1
		DEFAULT_DISCOUNT 1 DEFAULT_LEAD_TIME 1 DEFAULT_NOTIFICATION 1 DEFAULT_PRICE_LEVEL 1 DEPT 1 EMAIL1 1
		EMAIL2 1 EMAIL_ADDRESS 1 EXTRA_DETAIL 1 FAX_NO 1 ISO_QUALIFICATION 1 LAST_ORDER_REFERENCE 1
		LEAD_TIME 1 MAIN_COMMERCIAL_TERMS 1 MAIN_SHIPPING_METHOD 1 MARGIN_EXEMPT 1 MARKETING_CODE 1 MAXIMUM_DISCOUNT 1
		MINIMUM_ORDER_VALUE 1 MOBILE_NO 1 NAME2 1 NON_DISCOUNTABLE 1 ORDER_NO_REQUIRED 1 ORDER_STATIONERY_FORM 1
		PACK_QUANTITY 1 PACKING_SLIP_STATIONERY 1 PARENT_ASSET 1 PAYEE_NAME 1 PAYMENT_METHOD 1 PHONE_NO 1
		PRICE_CODE 1 PROMPT_PAYMENT_DISCOUNT 1 PURCHASE_MESSAGE 1 PURCHASE_PRICE 1 QTY_BREAK1 1 QTY_BREAK2 1
		QTY_BREAK3 1 QTY_BREAK4 1 QTY_BREAK5 1 QTY_DISCOUNT1 1 QTY_DISCOUNT2 1 QTY_DISCOUNT3 1
		QTY_DISCOUNT4 1 QTY_DISCOUNT5 1 REPLACEMENT_COST 1 SALES_MESSAGE 1 SELL_PRICE1 1 SELL_PRICE3 1
		SELL_PRICE4 1 SELL_PRICE5 1 SELL_PRICE6 1 SELL_PRICE7 1 SELL_PRICE8 1 SELL_PRICE9 1
		SELL_PRICE10 1 SEND_INVOICE 1 SERIAL_NUMBER 1 STATEMENT_ID 1 SUPPLIER_CODE 1 UNIT_MEASURE 1
		WEB_SITE 1 WEIGHT 1 QTY_ON_HAND 1 TAG 0 LAST_PAYMENT_DATE 1 LAST_SALE_DATE 1}
	array set default_MASTER {MODULE {} COMPANY_ID {} NUMBER 0 PART {} DELETED {} ALPHA_SORT_SEQUENCE {}
		TYPE {} PARENT_COMPANY 0 MASTER_ACCOUNT 0 ZERO_DATE {} CODE {} MAIN_SUPPLIER 0
		NON_DIMINISHING {} SEQUENCE {} RATING {} NAME {} WEB_DISPLAY {} CONTROL_FLAG {}
		BALANCE_CURRENCY {} INVOICE_PRINT {} BRANCH {} PRINT_STATEMENT {} DISABLED {} AREA {}
		SUPERSEDING_PART 0 CHARGE_FREIGHT {} MAIN_COURIER {} LOCATION {} SERIAL_TRACKING {} SELL_PRICE2 0.0
		PARENT_DISCOUNTS {} BALANCE_TYPE {} SUBTYPE {} TAXABLE {} MAXIMUM_DAYS_CREDIT 0 NON_STOCK {}
		PRIVACY_REQUESTED {} TAX_CODE {} CHEQUE_BANK {} CHEQUE_BRANCH {} CHEQUE_DRAWER {} DATE_OPENED {}
		LAST_PURCHASE_DATE {} MAIN_PAYMENT_TERMS {} POST_CODE {} PRICING_CURRENCY {} SUPPLIER_DESCRIPTION {} SUPPLIER_DISCOUNT 0.0
		SUPPLIER_LIST_PRICE 0.0 SUPPLIER_PART_NO {} ADDRESS {} AUTOMATIC_PRICE_UPDATING {} AVERAGE_COST 0.0 BANK_ACCOUNT {}
		BANK_OUTPUT_FILE {} CALL_CYCLE {} CONTACT_NAME {} COSTING_MULTIPLIER 0.0 CREDIT_LIMIT 0.0 CUBIC 0.0
		DEFAULT_DISCOUNT 0.0 DEFAULT_LEAD_TIME 0.0 DEFAULT_NOTIFICATION {} DEFAULT_PRICE_LEVEL 0 DEPT {} EMAIL1 {}
		EMAIL2 {} EMAIL_ADDRESS {} EXTRA_DETAIL {} FAX_NO {} ISO_QUALIFICATION {} LAST_ORDER_REFERENCE {}
		LEAD_TIME 0.0 MAIN_COMMERCIAL_TERMS {} MAIN_SHIPPING_METHOD {} MARGIN_EXEMPT {} MARKETING_CODE {} MAXIMUM_DISCOUNT 0.0
		MINIMUM_ORDER_VALUE 0.0 MOBILE_NO {} NAME2 {} NON_DISCOUNTABLE {} ORDER_NO_REQUIRED {} ORDER_STATIONERY_FORM {}
		PACK_QUANTITY 0.0 PACKING_SLIP_STATIONERY {} PARENT_ASSET 0 PAYEE_NAME {} PAYMENT_METHOD {} PHONE_NO {}
		PRICE_CODE {} PROMPT_PAYMENT_DISCOUNT 0.0 PURCHASE_MESSAGE {} PURCHASE_PRICE 0.0 QTY_BREAK1 0.0 QTY_BREAK2 0.0
		QTY_BREAK3 0.0 QTY_BREAK4 0.0 QTY_BREAK5 0.0 QTY_DISCOUNT1 0.0 QTY_DISCOUNT2 0.0 QTY_DISCOUNT3 0.0
		QTY_DISCOUNT4 0.0 QTY_DISCOUNT5 0.0 REPLACEMENT_COST 0.0 SALES_MESSAGE {} SELL_PRICE1 0.0 SELL_PRICE3 0.0
		SELL_PRICE4 0.0 SELL_PRICE5 0.0 SELL_PRICE6 0.0 SELL_PRICE7 0.0 SELL_PRICE8 0.0 SELL_PRICE9 0.0
		SELL_PRICE10 0.0 SEND_INVOICE 1 SERIAL_NUMBER {} STATEMENT_ID {} SUPPLIER_CODE {} UNIT_MEASURE {}
		WEB_SITE {} WEIGHT 0.0 QTY_ON_HAND 0.0 TAG {} LAST_PAYMENT_DATE {} LAST_SALE_DATE {}}

	set all_columns(MASTER_BUDGETS) {COMPANY_ID MODULE NUMBER YEAR SALES01 SALES02 SALES03 SALES04
		SALES05 SALES06 SALES07 SALES08 SALES09 SALES10 SALES11 SALES12}
	array set type_MASTER_BUDGETS {COMPANY_ID 0 MODULE 0 NUMBER 1 YEAR 1 SALES01 2 SALES02 2
		SALES03 2 SALES04 2 SALES05 2 SALES06 2 SALES07 2 SALES08 2
		SALES09 2 SALES10 2 SALES11 2 SALES12 2}
	array set null_MASTER_BUDGETS {COMPANY_ID 0 MODULE 0 NUMBER 0 YEAR 0 SALES01 1 SALES02 1
		SALES03 1 SALES04 1 SALES05 1 SALES06 1 SALES07 1 SALES08 1
		SALES09 1 SALES10 1 SALES11 1 SALES12 1}
	array set default_MASTER_BUDGETS {COMPANY_ID {} MODULE {} NUMBER 0 YEAR 0 SALES01 0.0 SALES02 0.0
		SALES03 0.0 SALES04 0.0 SALES05 0.0 SALES06 0.0 SALES07 0.0 SALES08 0.0
		SALES09 0.0 SALES10 0.0 SALES11 0.0 SALES12 0.0}

	set all_columns(MASTER_CODE) {COMPANY_ID MODULE CODE NAME DELETED TECHNICIAN HIDDEN BRANCH_MANAGER
		DEPN_METHOD DEPN_RATE EMAIL_ADDRESS GL_ACCUMULATED_DEPN GL_ASSET_CONTROL GL_CONTROL_ACCOUNT GL_COST_OF_SALES GL_DEPN_EXPENSE
		GL_GAIN_LOSS_ON_DEPN GL_SALES MINIMUM_MARGIN SALESMAN_BRANCH STANDARD_COMMISSION}
	array set type_MASTER_CODE {COMPANY_ID 0 MODULE 0 CODE 0 NAME 0 DELETED 0 TECHNICIAN 0
		HIDDEN 0 BRANCH_MANAGER 0 DEPN_METHOD 0 DEPN_RATE 2 EMAIL_ADDRESS 0 GL_ACCUMULATED_DEPN 1
		GL_ASSET_CONTROL 1 GL_CONTROL_ACCOUNT 1 GL_COST_OF_SALES 1 GL_DEPN_EXPENSE 1 GL_GAIN_LOSS_ON_DEPN 1 GL_SALES 1
		MINIMUM_MARGIN 2 SALESMAN_BRANCH 0 STANDARD_COMMISSION 2}
	array set null_MASTER_CODE {COMPANY_ID 0 MODULE 0 CODE 0 NAME 0 DELETED 1 TECHNICIAN 1
		HIDDEN 1 BRANCH_MANAGER 1 DEPN_METHOD 1 DEPN_RATE 1 EMAIL_ADDRESS 1 GL_ACCUMULATED_DEPN 1
		GL_ASSET_CONTROL 1 GL_CONTROL_ACCOUNT 1 GL_COST_OF_SALES 1 GL_DEPN_EXPENSE 1 GL_GAIN_LOSS_ON_DEPN 1 GL_SALES 1
		MINIMUM_MARGIN 1 SALESMAN_BRANCH 1 STANDARD_COMMISSION 1}
	array set default_MASTER_CODE {COMPANY_ID {} MODULE {} CODE {} NAME {} DELETED {} TECHNICIAN {}
		HIDDEN {} BRANCH_MANAGER {} DEPN_METHOD {} DEPN_RATE 0.0 EMAIL_ADDRESS {} GL_ACCUMULATED_DEPN 0
		GL_ASSET_CONTROL 0 GL_CONTROL_ACCOUNT 0 GL_COST_OF_SALES 0 GL_DEPN_EXPENSE 0 GL_GAIN_LOSS_ON_DEPN 0 GL_SALES 0
		MINIMUM_MARGIN 0.0 SALESMAN_BRANCH {} STANDARD_COMMISSION 0.0}

	set all_columns(MASTER_KEYWORD) {MODULE COMPANY_ID NUMBER KEYWORD LEVEL PRIORITY}
	array set type_MASTER_KEYWORD {MODULE 0 COMPANY_ID 0 NUMBER 1 KEYWORD 0 LEVEL 0 PRIORITY 0}
	array set null_MASTER_KEYWORD {MODULE 0 COMPANY_ID 0 NUMBER 0 KEYWORD 0 LEVEL 1 PRIORITY 1}
	array set default_MASTER_KEYWORD {MODULE {} COMPANY_ID {} NUMBER {} KEYWORD {} LEVEL {} PRIORITY {}}

	set all_columns(MASTER_SUBTYPE) {COMPANY_ID MODULE SUBTYPE TYPE NAME STATUS}
	array set type_MASTER_SUBTYPE {COMPANY_ID 0 MODULE 0 SUBTYPE 0 TYPE 0 NAME 0 STATUS 0}
	array set null_MASTER_SUBTYPE {COMPANY_ID 0 MODULE 0 SUBTYPE 0 TYPE 0 NAME 0 STATUS 1}
	array set default_MASTER_SUBTYPE {COMPANY_ID {} MODULE {} SUBTYPE {} TYPE {} NAME {} STATUS {}}

	set all_columns(MASTER_TYPE) {MODULE COMPANY_ID TYPE SEQUENCE TRADING_ACCOUNT GL_ASSET_CONTROL NAME DELETED
		HIDDEN SERVICE_TYPE PRODUCT_TYPE_CATEGORY GL_ACCUMULATED_DEPN GL_DEPN_EXPENSE GL_GAIN_LOSS_ON_DEPN ACCUMULATOR_SIGN ADD_SUBTRACT
		DEFAULT_CATEGORY DEFAULT_STATE DEPN_METHOD DEPN_RATE DISASSEMBLY_COST_RATIO DISASSEMBLY_PART DISASSEMBLY_SUB_PART DISCOUNT_GROUP
		GL_CONTROL_ACCOUNT GL_COST_OF_SALES GL_SALES GL_STOCK MAIN_SUPPLIER MAXIMUM_DISCOUNT MINIMUM_SALES_MARGIN PRICE1_HEADING
		PRICE2_HEADING PRICE3_HEADING PRICE4_HEADING PRICE5_HEADING PRICE6_HEADING PRICE7_HEADING PRICE8_HEADING PRICE9_HEADING
		PRICE10_HEADING QTY_BREAK1 QTY_BREAK2 QTY_BREAK3 QTY_BREAK4 QTY_BREAK5 QTY_DISCOUNT1 QTY_DISCOUNT2
		QTY_DISCOUNT3 QTY_DISCOUNT4 QTY_DISCOUNT5 REBATE REPORT_SIGN TOTAL_SIGN TYPE_HEADING TAG}
	array set type_MASTER_TYPE {MODULE 0 COMPANY_ID 0 TYPE 0 SEQUENCE 0 TRADING_ACCOUNT 0 GL_ASSET_CONTROL 1
		NAME 0 DELETED 0 HIDDEN 0 SERVICE_TYPE 0 PRODUCT_TYPE_CATEGORY 0 GL_ACCUMULATED_DEPN 1
		GL_DEPN_EXPENSE 1 GL_GAIN_LOSS_ON_DEPN 1 ACCUMULATOR_SIGN 0 ADD_SUBTRACT 0 DEFAULT_CATEGORY 0 DEFAULT_STATE 0
		DEPN_METHOD 0 DEPN_RATE 2 DISASSEMBLY_COST_RATIO 2 DISASSEMBLY_PART 0 DISASSEMBLY_SUB_PART 0 DISCOUNT_GROUP 0
		GL_CONTROL_ACCOUNT 1 GL_COST_OF_SALES 1 GL_SALES 1 GL_STOCK 1 MAIN_SUPPLIER 1 MAXIMUM_DISCOUNT 2
		MINIMUM_SALES_MARGIN 2 PRICE1_HEADING 0 PRICE2_HEADING 0 PRICE3_HEADING 0 PRICE4_HEADING 0 PRICE5_HEADING 0
		PRICE6_HEADING 0 PRICE7_HEADING 0 PRICE8_HEADING 0 PRICE9_HEADING 0 PRICE10_HEADING 0 QTY_BREAK1 2
		QTY_BREAK2 2 QTY_BREAK3 2 QTY_BREAK4 2 QTY_BREAK5 2 QTY_DISCOUNT1 2 QTY_DISCOUNT2 2
		QTY_DISCOUNT3 2 QTY_DISCOUNT4 2 QTY_DISCOUNT5 2 REBATE 2 REPORT_SIGN 0 TOTAL_SIGN 0
		TYPE_HEADING 0 TAG 0}
	array set null_MASTER_TYPE {MODULE 0 COMPANY_ID 0 TYPE 0 SEQUENCE 1 TRADING_ACCOUNT 1 GL_ASSET_CONTROL 1
		NAME 0 DELETED 1 HIDDEN 1 SERVICE_TYPE 1 PRODUCT_TYPE_CATEGORY 1 GL_ACCUMULATED_DEPN 1
		GL_DEPN_EXPENSE 1 GL_GAIN_LOSS_ON_DEPN 1 ACCUMULATOR_SIGN 1 ADD_SUBTRACT 1 DEFAULT_CATEGORY 1 DEFAULT_STATE 1
		DEPN_METHOD 1 DEPN_RATE 1 DISASSEMBLY_COST_RATIO 1 DISASSEMBLY_PART 1 DISASSEMBLY_SUB_PART 1 DISCOUNT_GROUP 1
		GL_CONTROL_ACCOUNT 1 GL_COST_OF_SALES 1 GL_SALES 1 GL_STOCK 1 MAIN_SUPPLIER 1 MAXIMUM_DISCOUNT 1
		MINIMUM_SALES_MARGIN 1 PRICE1_HEADING 1 PRICE2_HEADING 1 PRICE3_HEADING 1 PRICE4_HEADING 1 PRICE5_HEADING 1
		PRICE6_HEADING 1 PRICE7_HEADING 1 PRICE8_HEADING 1 PRICE9_HEADING 1 PRICE10_HEADING 1 QTY_BREAK1 1
		QTY_BREAK2 1 QTY_BREAK3 1 QTY_BREAK4 1 QTY_BREAK5 1 QTY_DISCOUNT1 1 QTY_DISCOUNT2 1
		QTY_DISCOUNT3 1 QTY_DISCOUNT4 1 QTY_DISCOUNT5 1 REBATE 1 REPORT_SIGN 1 TOTAL_SIGN 1
		TYPE_HEADING 1 TAG 0}
	array set default_MASTER_TYPE {MODULE {} COMPANY_ID {} TYPE {} SEQUENCE {} TRADING_ACCOUNT {} GL_ASSET_CONTROL 0
		NAME {} DELETED {} HIDDEN {} SERVICE_TYPE {} PRODUCT_TYPE_CATEGORY {} GL_ACCUMULATED_DEPN 0
		GL_DEPN_EXPENSE 0 GL_GAIN_LOSS_ON_DEPN 0 ACCUMULATOR_SIGN {} ADD_SUBTRACT {} DEFAULT_CATEGORY {} DEFAULT_STATE {}
		DEPN_METHOD {} DEPN_RATE 0.0 DISASSEMBLY_COST_RATIO 0.0 DISASSEMBLY_PART {} DISASSEMBLY_SUB_PART {} DISCOUNT_GROUP {}
		GL_CONTROL_ACCOUNT 0 GL_COST_OF_SALES 0 GL_SALES 0 GL_STOCK 0 MAIN_SUPPLIER 0 MAXIMUM_DISCOUNT 0.0
		MINIMUM_SALES_MARGIN 0.0 PRICE1_HEADING {} PRICE2_HEADING {} PRICE3_HEADING {} PRICE4_HEADING {} PRICE5_HEADING {}
		PRICE6_HEADING {} PRICE7_HEADING {} PRICE8_HEADING {} PRICE9_HEADING {} PRICE10_HEADING {} QTY_BREAK1 0.0
		QTY_BREAK2 0.0 QTY_BREAK3 0.0 QTY_BREAK4 0.0 QTY_BREAK5 0.0 QTY_DISCOUNT1 0.0 QTY_DISCOUNT2 0.0
		QTY_DISCOUNT3 0.0 QTY_DISCOUNT4 0.0 QTY_DISCOUNT5 0.0 REBATE 0.0 REPORT_SIGN {} TOTAL_SIGN {}
		TYPE_HEADING {} TAG {}}

	set all_columns(MISSHIPMENT_HEADER) {REF COMPANY_ID STATUS CUSTOMER ADJUSTMENT1_REF_NO ADJUSTMENT2_REF_NO BRANCH COURIER
		CUSTOMER_CONTACT CUSTOMER_EMAIL CUSTOMER_FAX CUSTOMER_PHONE DATE DELIVERY_ADDRESS DELIVERY_NAME LOG
		NOTES OPERATOR PACKING_SLIP}
	array set type_MISSHIPMENT_HEADER {REF 0 COMPANY_ID 0 STATUS 0 CUSTOMER 1 ADJUSTMENT1_REF_NO 1 ADJUSTMENT2_REF_NO 1
		BRANCH 0 COURIER 0 CUSTOMER_CONTACT 0 CUSTOMER_EMAIL 0 CUSTOMER_FAX 0 CUSTOMER_PHONE 0
		DATE 3 DELIVERY_ADDRESS 0 DELIVERY_NAME 0 LOG 0 NOTES 0 OPERATOR 0
		PACKING_SLIP 0}
	array set null_MISSHIPMENT_HEADER {REF 0 COMPANY_ID 0 STATUS 1 CUSTOMER 0 ADJUSTMENT1_REF_NO 1 ADJUSTMENT2_REF_NO 1
		BRANCH 0 COURIER 1 CUSTOMER_CONTACT 1 CUSTOMER_EMAIL 1 CUSTOMER_FAX 1 CUSTOMER_PHONE 1
		DATE 1 DELIVERY_ADDRESS 1 DELIVERY_NAME 1 LOG 1 NOTES 1 OPERATOR 1
		PACKING_SLIP 0}
	array set default_MISSHIPMENT_HEADER {REF {} COMPANY_ID {} STATUS {} CUSTOMER 0 ADJUSTMENT1_REF_NO 0 ADJUSTMENT2_REF_NO 0
		BRANCH {} COURIER {} CUSTOMER_CONTACT {} CUSTOMER_EMAIL {} CUSTOMER_FAX {} CUSTOMER_PHONE {}
		DATE {} DELIVERY_ADDRESS {} DELIVERY_NAME {} LOG {} NOTES {} OPERATOR {}
		PACKING_SLIP {}}

	set all_columns(MISSHIPMENT_LINE) {COMPANY_ID REF SORT_SEQUENCE CUSTOMER_REFERENCE NON_STOCK_NAME NON_STOCK_PART PART QTY_REQUIRED
		QTY_SHIPPED SERIAL_LIST STATUS TEXT}
	array set type_MISSHIPMENT_LINE {COMPANY_ID 0 REF 0 SORT_SEQUENCE 0 CUSTOMER_REFERENCE 0 NON_STOCK_NAME 0 NON_STOCK_PART 0
		PART 1 QTY_REQUIRED 2 QTY_SHIPPED 2 SERIAL_LIST 0 STATUS 0 TEXT 0}
	array set null_MISSHIPMENT_LINE {COMPANY_ID 0 REF 0 SORT_SEQUENCE 0 CUSTOMER_REFERENCE 1 NON_STOCK_NAME 1 NON_STOCK_PART 1
		PART 0 QTY_REQUIRED 1 QTY_SHIPPED 1 SERIAL_LIST 1 STATUS 1 TEXT 1}
	array set default_MISSHIPMENT_LINE {COMPANY_ID {} REF {} SORT_SEQUENCE {} CUSTOMER_REFERENCE {} NON_STOCK_NAME {} NON_STOCK_PART {}
		PART 0 QTY_REQUIRED 0.0 QTY_SHIPPED 0.0 SERIAL_LIST {} STATUS {} TEXT {}}

	set all_columns(MISSHIPMENT_NOTE) {COMPANY_ID REF DATE ID TEXT USER}
	array set type_MISSHIPMENT_NOTE {COMPANY_ID 0 REF 0 DATE 3 ID 1 TEXT 0 USER 0}
	array set null_MISSHIPMENT_NOTE {COMPANY_ID 0 REF 0 DATE 1 ID 0 TEXT 1 USER 1}
	array set default_MISSHIPMENT_NOTE {COMPANY_ID {} REF {} DATE {} ID {} TEXT {} USER {}}

	set all_columns(MODULE_TRAN) {COMPANY_ID MODULE TYPE PROGRAM STANDING MENU_SEQUENCE HISTORY DEFAULT_SIGN
		AUTOMATIC_BATCHES BOTTOM_ACCOUNT ENTER_SECURITY NAME NUMBERING ENQUIRY_SECURITY ALWAYS_USE_THIS_FORM BANK_REC_CONSOLIDATE
		BOTTOM_MODULE CLEAR_DEFAULTS DEFAULT_TAX ENTER_CHARGES MAINTAIN_SECURITY OTHER_TYPE PRINT_LAYOUT SORT_LINES
		SORT_TRANSACTION STANDING_TYPE STATIONERY_FORM TOP_ACCOUNT TOP_MODULE CHARGE_DESCRIPTION}
	array set type_MODULE_TRAN {COMPANY_ID 0 MODULE 0 TYPE 0 PROGRAM 0 STANDING 0 MENU_SEQUENCE 1
		HISTORY 0 DEFAULT_SIGN 0 AUTOMATIC_BATCHES 0 BOTTOM_ACCOUNT 1 ENTER_SECURITY 1 NAME 0
		NUMBERING 0 ENQUIRY_SECURITY 1 ALWAYS_USE_THIS_FORM 0 BANK_REC_CONSOLIDATE 0 BOTTOM_MODULE 0 CLEAR_DEFAULTS 0
		DEFAULT_TAX 0 ENTER_CHARGES 0 MAINTAIN_SECURITY 1 OTHER_TYPE 0 PRINT_LAYOUT 0 SORT_LINES 0
		SORT_TRANSACTION 0 STANDING_TYPE 0 STATIONERY_FORM 0 TOP_ACCOUNT 1 TOP_MODULE 0 CHARGE_DESCRIPTION 0}
	array set null_MODULE_TRAN {COMPANY_ID 0 MODULE 0 TYPE 0 PROGRAM 0 STANDING 1 MENU_SEQUENCE 1
		HISTORY 1 DEFAULT_SIGN 1 AUTOMATIC_BATCHES 1 BOTTOM_ACCOUNT 1 ENTER_SECURITY 1 NAME 0
		NUMBERING 1 ENQUIRY_SECURITY 1 ALWAYS_USE_THIS_FORM 1 BANK_REC_CONSOLIDATE 1 BOTTOM_MODULE 1 CLEAR_DEFAULTS 1
		DEFAULT_TAX 1 ENTER_CHARGES 1 MAINTAIN_SECURITY 1 OTHER_TYPE 1 PRINT_LAYOUT 1 SORT_LINES 1
		SORT_TRANSACTION 1 STANDING_TYPE 1 STATIONERY_FORM 1 TOP_ACCOUNT 1 TOP_MODULE 1 CHARGE_DESCRIPTION 1}
	array set default_MODULE_TRAN {COMPANY_ID {} MODULE {} TYPE {} PROGRAM {} STANDING {} MENU_SEQUENCE 0
		HISTORY {} DEFAULT_SIGN {} AUTOMATIC_BATCHES {} BOTTOM_ACCOUNT 0 ENTER_SECURITY 0 NAME {}
		NUMBERING {} ENQUIRY_SECURITY 0 ALWAYS_USE_THIS_FORM {} BANK_REC_CONSOLIDATE {} BOTTOM_MODULE {} CLEAR_DEFAULTS {}
		DEFAULT_TAX {} ENTER_CHARGES {} MAINTAIN_SECURITY 0 OTHER_TYPE {} PRINT_LAYOUT {} SORT_LINES {}
		SORT_TRANSACTION {} STANDING_TYPE {} STATIONERY_FORM {} TOP_ACCOUNT 0 TOP_MODULE {} CHARGE_DESCRIPTION {}}

	set all_columns(NOTES) {ACTION APPOINTMENT_DATE CALL_TYPE COMPANY_ID DATE ENTERED_BY EXPIRY_DATE ID
		MODULE NUMBER ORIGINAL_USER PRIORITY PUBLIC TEXT UPDATED_BY UPDATED_DATE}
	array set type_NOTES {ACTION 0 APPOINTMENT_DATE 3 CALL_TYPE 0 COMPANY_ID 0 DATE 3 ENTERED_BY 0
		EXPIRY_DATE 3 ID 1 MODULE 0 NUMBER 1 ORIGINAL_USER 0 PRIORITY 0
		PUBLIC 0 TEXT 0 UPDATED_BY 0 UPDATED_DATE 3}
	array set null_NOTES {ACTION 1 APPOINTMENT_DATE 1 CALL_TYPE 1 COMPANY_ID 0 DATE 1 ENTERED_BY 1
		EXPIRY_DATE 1 ID 0 MODULE 0 NUMBER 0 ORIGINAL_USER 1 PRIORITY 1
		PUBLIC 1 TEXT 1 UPDATED_BY 1 UPDATED_DATE 1}
	array set default_NOTES {ACTION {} APPOINTMENT_DATE {} CALL_TYPE {} COMPANY_ID {} DATE {} ENTERED_BY {}
		EXPIRY_DATE {} ID {} MODULE {} NUMBER 0 ORIGINAL_USER {} PRIORITY {}
		PUBLIC Y TEXT {} UPDATED_BY {} UPDATED_DATE {}}

	set all_columns(ORDER_HEADER) {COMPANY_ID REF STATUS CUSTOMER ORDER_TYPE ORDER_DATE EXPIRY_DATE ORDER_NO
		BRANCH EDIT_USER SALESMAN DELIVERY_NAME SALES_FOLLOWUP_DATE OPERATOR ORDER_VALUE FORWARD_DATE
		LOG STATUS_NOTE BACKORDER_COURIER BACKORDER_FREIGHT FLAGS PUBLIC_NOTES RECEIPT_REF_NO AUTHORISATION_USER
		CONFIRMATION_METHOD COURIER CUSTOMER_CONTACT CUSTOMER_EMAIL CUSTOMER_FAX CUSTOMER_PHONE DELIVERY_ADDRESS DELIVERY_INSTRUCTIONS
		DELIVERY_NOTE FORWARD_ORDER FREIGHT GENERATE_ONE_INVOICE GENERATE_ONE_PSLIP JOB_COMPLETED JOB_COMPLETION_DATE JOB_QUOTE_VALUE
		JOB_QUOTED JOB_TECHNICIAN JOB_TYPE JOB_WARRANTY JOB_WIP_REASON ORDER_TAKEN_BY PACKAGE_PRICE PAYMENT_NOTE
		PRICE_NOTE PRINTED PRIVATE_NOTES QUOTED_REF SALES_FOLLOWUP_NOTE SATURDAY_DELIVERY SERVICE_FOLLOWUP_DATE SERVICE_FOLLOWUP_NOTE
		SUBJECT}
	array set type_ORDER_HEADER {COMPANY_ID 0 REF 0 STATUS 0 CUSTOMER 1 ORDER_TYPE 0 ORDER_DATE 3
		EXPIRY_DATE 3 ORDER_NO 0 BRANCH 0 EDIT_USER 0 SALESMAN 0 DELIVERY_NAME 0
		SALES_FOLLOWUP_DATE 3 OPERATOR 0 ORDER_VALUE 2 FORWARD_DATE 3 LOG 0 STATUS_NOTE 0
		BACKORDER_COURIER 0 BACKORDER_FREIGHT 2 FLAGS 0 PUBLIC_NOTES 0 RECEIPT_REF_NO 1 AUTHORISATION_USER 0
		CONFIRMATION_METHOD 0 COURIER 0 CUSTOMER_CONTACT 0 CUSTOMER_EMAIL 0 CUSTOMER_FAX 0 CUSTOMER_PHONE 0
		DELIVERY_ADDRESS 0 DELIVERY_INSTRUCTIONS 0 DELIVERY_NOTE 0 FORWARD_ORDER 0 FREIGHT 2 GENERATE_ONE_INVOICE 0
		GENERATE_ONE_PSLIP 0 JOB_COMPLETED 0 JOB_COMPLETION_DATE 3 JOB_QUOTE_VALUE 2 JOB_QUOTED 0 JOB_TECHNICIAN 0
		JOB_TYPE 0 JOB_WARRANTY 0 JOB_WIP_REASON 0 ORDER_TAKEN_BY 0 PACKAGE_PRICE 2 PAYMENT_NOTE 0
		PRICE_NOTE 0 PRINTED 0 PRIVATE_NOTES 0 QUOTED_REF 0 SALES_FOLLOWUP_NOTE 0 SATURDAY_DELIVERY 0
		SERVICE_FOLLOWUP_DATE 3 SERVICE_FOLLOWUP_NOTE 0 SUBJECT 0}
	array set null_ORDER_HEADER {COMPANY_ID 0 REF 0 STATUS 1 CUSTOMER 0 ORDER_TYPE 1 ORDER_DATE 1
		EXPIRY_DATE 1 ORDER_NO 1 BRANCH 0 EDIT_USER 1 SALESMAN 1 DELIVERY_NAME 1
		SALES_FOLLOWUP_DATE 1 OPERATOR 1 ORDER_VALUE 1 FORWARD_DATE 1 LOG 1 STATUS_NOTE 1
		BACKORDER_COURIER 1 BACKORDER_FREIGHT 1 FLAGS 1 PUBLIC_NOTES 1 RECEIPT_REF_NO 1 AUTHORISATION_USER 1
		CONFIRMATION_METHOD 1 COURIER 1 CUSTOMER_CONTACT 1 CUSTOMER_EMAIL 1 CUSTOMER_FAX 1 CUSTOMER_PHONE 1
		DELIVERY_ADDRESS 1 DELIVERY_INSTRUCTIONS 1 DELIVERY_NOTE 1 FORWARD_ORDER 1 FREIGHT 1 GENERATE_ONE_INVOICE 1
		GENERATE_ONE_PSLIP 1 JOB_COMPLETED 1 JOB_COMPLETION_DATE 1 JOB_QUOTE_VALUE 1 JOB_QUOTED 1 JOB_TECHNICIAN 1
		JOB_TYPE 1 JOB_WARRANTY 1 JOB_WIP_REASON 1 ORDER_TAKEN_BY 1 PACKAGE_PRICE 1 PAYMENT_NOTE 1
		PRICE_NOTE 1 PRINTED 1 PRIVATE_NOTES 1 QUOTED_REF 1 SALES_FOLLOWUP_NOTE 1 SATURDAY_DELIVERY 1
		SERVICE_FOLLOWUP_DATE 1 SERVICE_FOLLOWUP_NOTE 1 SUBJECT 1}
	array set default_ORDER_HEADER {COMPANY_ID {} REF {} STATUS {} CUSTOMER 0 ORDER_TYPE {} ORDER_DATE {}
		EXPIRY_DATE {} ORDER_NO {} BRANCH {} EDIT_USER {} SALESMAN {} DELIVERY_NAME {}
		SALES_FOLLOWUP_DATE {} OPERATOR {} ORDER_VALUE 0.0 FORWARD_DATE {} LOG {} STATUS_NOTE {}
		BACKORDER_COURIER {} BACKORDER_FREIGHT 0.0 FLAGS {} PUBLIC_NOTES {} RECEIPT_REF_NO 0 AUTHORISATION_USER {}
		CONFIRMATION_METHOD {} COURIER {} CUSTOMER_CONTACT {} CUSTOMER_EMAIL {} CUSTOMER_FAX {} CUSTOMER_PHONE {}
		DELIVERY_ADDRESS {} DELIVERY_INSTRUCTIONS {} DELIVERY_NOTE {} FORWARD_ORDER {} FREIGHT 0.0 GENERATE_ONE_INVOICE {}
		GENERATE_ONE_PSLIP {} JOB_COMPLETED {} JOB_COMPLETION_DATE {} JOB_QUOTE_VALUE 0.0 JOB_QUOTED {} JOB_TECHNICIAN {}
		JOB_TYPE {} JOB_WARRANTY {} JOB_WIP_REASON {} ORDER_TAKEN_BY {} PACKAGE_PRICE 0.0 PAYMENT_NOTE {}
		PRICE_NOTE {} PRINTED {} PRIVATE_NOTES {} QUOTED_REF {} SALES_FOLLOWUP_NOTE {} SATURDAY_DELIVERY {}
		SERVICE_FOLLOWUP_DATE {} SERVICE_FOLLOWUP_NOTE {} SUBJECT {}}

	set all_columns(ORDER_LINE) {REF COMPANY_ID SORT_SEQUENCE STATUS PART DATE QTY_REQUIRED APPROVING_USER
		BRAND CUSTOMER_REFERENCE DISCOUNT ESTIMATE NET_PRICE NON_STOCK_COST NON_STOCK_NAME NON_STOCK_PART
		NON_STOCK_REF_NO NON_STOCK_SUPPLIER NON_STOCK_TYPE ORDER_VALUE QTY_INVOICED QTY_ORIGINAL QTY_OTHER REBATE
		SELL_PRICE TEXT}
	array set type_ORDER_LINE {REF 0 COMPANY_ID 0 SORT_SEQUENCE 0 STATUS 0 PART 1 DATE 3
		QTY_REQUIRED 2 APPROVING_USER 0 BRAND 0 CUSTOMER_REFERENCE 0 DISCOUNT 2 ESTIMATE 0
		NET_PRICE 2 NON_STOCK_COST 2 NON_STOCK_NAME 0 NON_STOCK_PART 0 NON_STOCK_REF_NO 1 NON_STOCK_SUPPLIER 1
		NON_STOCK_TYPE 0 ORDER_VALUE 2 QTY_INVOICED 2 QTY_ORIGINAL 2 QTY_OTHER 2 REBATE 2
		SELL_PRICE 2 TEXT 0}
	array set null_ORDER_LINE {REF 0 COMPANY_ID 0 SORT_SEQUENCE 0 STATUS 1 PART 0 DATE 1
		QTY_REQUIRED 1 APPROVING_USER 1 BRAND 1 CUSTOMER_REFERENCE 1 DISCOUNT 1 ESTIMATE 1
		NET_PRICE 1 NON_STOCK_COST 1 NON_STOCK_NAME 1 NON_STOCK_PART 1 NON_STOCK_REF_NO 1 NON_STOCK_SUPPLIER 1
		NON_STOCK_TYPE 1 ORDER_VALUE 1 QTY_INVOICED 1 QTY_ORIGINAL 1 QTY_OTHER 1 REBATE 1
		SELL_PRICE 1 TEXT 1}
	array set default_ORDER_LINE {REF {} COMPANY_ID {} SORT_SEQUENCE {} STATUS {} PART 0 DATE {}
		QTY_REQUIRED 0.0 APPROVING_USER {} BRAND {} CUSTOMER_REFERENCE {} DISCOUNT 0.0 ESTIMATE {}
		NET_PRICE 0.0 NON_STOCK_COST 0.0 NON_STOCK_NAME {} NON_STOCK_PART {} NON_STOCK_REF_NO 0 NON_STOCK_SUPPLIER 0
		NON_STOCK_TYPE {} ORDER_VALUE 0.0 QTY_INVOICED 0.0 QTY_ORIGINAL 0.0 QTY_OTHER 0.0 REBATE 0.0
		SELL_PRICE 0.0 TEXT {}}

	set all_columns(ORDER_LINE_DETAIL) {COMPANY_ID REF SORT_SEQUENCE STATUS LINE_NO PURCHASE_REF PURCHASE_LINE_NO PART
		INVOICE_REF PACKING_SLIP BRANCH TRANSFER_REF QTY STATUS_MESSAGE SERIAL_LIST SHIP_TO_CUSTOMER
		SUPPLIER}
	array set type_ORDER_LINE_DETAIL {COMPANY_ID 0 REF 0 SORT_SEQUENCE 0 STATUS 0 LINE_NO 1 PURCHASE_REF 0
		PURCHASE_LINE_NO 1 PART 1 INVOICE_REF 1 PACKING_SLIP 0 BRANCH 0 TRANSFER_REF 1
		QTY 2 STATUS_MESSAGE 0 SERIAL_LIST 0 SHIP_TO_CUSTOMER 0 SUPPLIER 1}
	array set null_ORDER_LINE_DETAIL {COMPANY_ID 0 REF 0 SORT_SEQUENCE 0 STATUS 0 LINE_NO 0 PURCHASE_REF 1
		PURCHASE_LINE_NO 1 PART 1 INVOICE_REF 1 PACKING_SLIP 1 BRANCH 1 TRANSFER_REF 1
		QTY 0 STATUS_MESSAGE 0 SERIAL_LIST 1 SHIP_TO_CUSTOMER 1 SUPPLIER 1}
	array set default_ORDER_LINE_DETAIL {COMPANY_ID {} REF {} SORT_SEQUENCE {} STATUS {} LINE_NO 0 PURCHASE_REF {}
		PURCHASE_LINE_NO 0 PART 0 INVOICE_REF 0 PACKING_SLIP {} BRANCH {} TRANSFER_REF 0
		QTY 0.0000 STATUS_MESSAGE {} SERIAL_LIST {} SHIP_TO_CUSTOMER {} SUPPLIER 0}

	set all_columns(OVERSEAS_ENQUIRY) {ID COMPANY_ID OPERATOR STATUS CUSTOMER DATE EDIT_USER CUSTOMER_CONTACT
		CUSTOMER_EMAIL CUSTOMER_FAX CUSTOMER_PHONE DELIVERY_ADDRESS DELIVERY_METHOD DELIVERY_NAME NOTES ORDER_NO
		PRIORITY}
	array set type_OVERSEAS_ENQUIRY {ID 1 COMPANY_ID 0 OPERATOR 0 STATUS 0 CUSTOMER 1 DATE 3
		EDIT_USER 0 CUSTOMER_CONTACT 0 CUSTOMER_EMAIL 0 CUSTOMER_FAX 0 CUSTOMER_PHONE 0 DELIVERY_ADDRESS 0
		DELIVERY_METHOD 0 DELIVERY_NAME 0 NOTES 0 ORDER_NO 0 PRIORITY 0}
	array set null_OVERSEAS_ENQUIRY {ID 0 COMPANY_ID 0 OPERATOR 1 STATUS 0 CUSTOMER 0 DATE 0
		EDIT_USER 1 CUSTOMER_CONTACT 1 CUSTOMER_EMAIL 1 CUSTOMER_FAX 1 CUSTOMER_PHONE 1 DELIVERY_ADDRESS 1
		DELIVERY_METHOD 1 DELIVERY_NAME 1 NOTES 1 ORDER_NO 1 PRIORITY 1}
	array set default_OVERSEAS_ENQUIRY {ID {} COMPANY_ID {} OPERATOR {} STATUS {} CUSTOMER 0 DATE {0000-00-00 00:00:00}
		EDIT_USER {} CUSTOMER_CONTACT {} CUSTOMER_EMAIL {} CUSTOMER_FAX {} CUSTOMER_PHONE {} DELIVERY_ADDRESS {}
		DELIVERY_METHOD {} DELIVERY_NAME {} NOTES {} ORDER_NO {} PRIORITY {}}

	set all_columns(OVERSEAS_PART) {ID STATUS PART_NO PART OVERSEAS_ID SUPPLIER BRAND COST_FACTOR
		DELIVERY_DETAIL DESCRIPTION LINE_NOTE QTY SUPPLIER_PART UNIT_COST}
	array set type_OVERSEAS_PART {ID 1 STATUS 0 PART_NO 1 PART 0 OVERSEAS_ID 1 SUPPLIER 1
		BRAND 0 COST_FACTOR 2 DELIVERY_DETAIL 0 DESCRIPTION 0 LINE_NOTE 0 QTY 2
		SUPPLIER_PART 0 UNIT_COST 2}
	array set null_OVERSEAS_PART {ID 0 STATUS 0 PART_NO 1 PART 0 OVERSEAS_ID 0 SUPPLIER 1
		BRAND 1 COST_FACTOR 1 DELIVERY_DETAIL 1 DESCRIPTION 1 LINE_NOTE 1 QTY 1
		SUPPLIER_PART 1 UNIT_COST 1}
	array set default_OVERSEAS_PART {ID {} STATUS {} PART_NO 0 PART {} OVERSEAS_ID 0 SUPPLIER 0
		BRAND {} COST_FACTOR 0.0 DELIVERY_DETAIL {} DESCRIPTION {} LINE_NOTE {} QTY 0.0
		SUPPLIER_PART {} UNIT_COST 0.0}

	set all_columns(PACKING_SLIP) {COMPANY_ID PACKING_SLIP REF STATUS PRINT_DATE STATUS_MESSAGE FREIGHT SPECIAL_FLAG
		CHECKED_BY COURIER DELIVERY_ADDRESS NOTES OPERATOR PICKED_BY PRINT_TIME REF_NO
		SATURDAY_DELIVERY SHIP_TO_CUSTOMER SUPPLY_BRANCH CONFIRM}
	array set type_PACKING_SLIP {COMPANY_ID 0 PACKING_SLIP 0 REF 0 STATUS 0 PRINT_DATE 3 STATUS_MESSAGE 0
		FREIGHT 2 SPECIAL_FLAG 0 CHECKED_BY 0 COURIER 0 DELIVERY_ADDRESS 0 NOTES 0
		OPERATOR 0 PICKED_BY 0 PRINT_TIME 0 REF_NO 1 SATURDAY_DELIVERY 0 SHIP_TO_CUSTOMER 0
		SUPPLY_BRANCH 0 CONFIRM 0}
	array set null_PACKING_SLIP {COMPANY_ID 0 PACKING_SLIP 0 REF 0 STATUS 0 PRINT_DATE 1 STATUS_MESSAGE 0
		FREIGHT 1 SPECIAL_FLAG 1 CHECKED_BY 1 COURIER 1 DELIVERY_ADDRESS 1 NOTES 1
		OPERATOR 1 PICKED_BY 1 PRINT_TIME 1 REF_NO 1 SATURDAY_DELIVERY 1 SHIP_TO_CUSTOMER 1
		SUPPLY_BRANCH 0 CONFIRM 1}
	array set default_PACKING_SLIP {COMPANY_ID {} PACKING_SLIP {} REF {} STATUS {} PRINT_DATE {} STATUS_MESSAGE {}
		FREIGHT 0.0 SPECIAL_FLAG {} CHECKED_BY {} COURIER {} DELIVERY_ADDRESS {} NOTES {}
		OPERATOR {} PICKED_BY {} PRINT_TIME {} REF_NO 0 SATURDAY_DELIVERY {} SHIP_TO_CUSTOMER {}
		SUPPLY_BRANCH {} CONFIRM {}}

	set all_columns(PART_LABEL) {BARCODE COMPANY_ID CUBIC HEIGHT ID INNER_BARCODE INNER_QTY LABEL_TEXT
		LENGTH OUTER_BARCODE OUTER_QTY PART QTY SUPPLIER_BARCODE WIDTH}
	array set type_PART_LABEL {BARCODE 0 COMPANY_ID 0 CUBIC 2 HEIGHT 2 ID 1 INNER_BARCODE 0
		INNER_QTY 2 LABEL_TEXT 0 LENGTH 2 OUTER_BARCODE 0 OUTER_QTY 2 PART 1
		QTY 2 SUPPLIER_BARCODE 0 WIDTH 2}
	array set null_PART_LABEL {BARCODE 1 COMPANY_ID 0 CUBIC 1 HEIGHT 1 ID 0 INNER_BARCODE 1
		INNER_QTY 1 LABEL_TEXT 1 LENGTH 1 OUTER_BARCODE 1 OUTER_QTY 1 PART 0
		QTY 1 SUPPLIER_BARCODE 1 WIDTH 1}
	array set default_PART_LABEL {BARCODE {} COMPANY_ID {} CUBIC 0.0 HEIGHT 0.0 ID {} INNER_BARCODE {}
		INNER_QTY 0.0 LABEL_TEXT {} LENGTH 0.0 OUTER_BARCODE {} OUTER_QTY 0.0 PART 0
		QTY 0.0 SUPPLIER_BARCODE {} WIDTH 0.0}

	set all_columns(PART_PHRASE) {COMPANY_ID PART PHRASE}
	array set type_PART_PHRASE {COMPANY_ID 0 PART 1 PHRASE 0}
	array set null_PART_PHRASE {COMPANY_ID 0 PART 0 PHRASE 0}
	array set default_PART_PHRASE {COMPANY_ID {} PART {} PHRASE {}}

	set all_columns(PHONE_NUMBER) {COMPANY_ID ACCOUNT ADDRESS_ID MODULE NUMBER ACTION ID}
	array set type_PHONE_NUMBER {COMPANY_ID 0 ACCOUNT 1 ADDRESS_ID 1 MODULE 0 NUMBER 0 ACTION 0
		ID 1}
	array set null_PHONE_NUMBER {COMPANY_ID 0 ACCOUNT 0 ADDRESS_ID 1 MODULE 0 NUMBER 0 ACTION 1
		ID 0}
	array set default_PHONE_NUMBER {COMPANY_ID {} ACCOUNT 0 ADDRESS_ID 0 MODULE {} NUMBER {} ACTION {}
		ID {}}

	set all_columns(PPP_CONTRACT) {REF COMPANY_ID END_DATE STATUS CUSTOMER PRODUCT START_DATE DELIVERY_ADDRESS
		DELIVERY_NAME LOCATION PRICE_PER_PAGE SALESMAN SERIAL_NUMBER}
	array set type_PPP_CONTRACT {REF 0 COMPANY_ID 0 END_DATE 3 STATUS 0 CUSTOMER 1 PRODUCT 1
		START_DATE 3 DELIVERY_ADDRESS 0 DELIVERY_NAME 0 LOCATION 0 PRICE_PER_PAGE 2 SALESMAN 0
		SERIAL_NUMBER 0}
	array set null_PPP_CONTRACT {REF 0 COMPANY_ID 0 END_DATE 1 STATUS 0 CUSTOMER 0 PRODUCT 0
		START_DATE 1 DELIVERY_ADDRESS 1 DELIVERY_NAME 1 LOCATION 1 PRICE_PER_PAGE 1 SALESMAN 0
		SERIAL_NUMBER 1}
	array set default_PPP_CONTRACT {REF {} COMPANY_ID {} END_DATE {} STATUS {} CUSTOMER 0 PRODUCT 0
		START_DATE {} DELIVERY_ADDRESS {} DELIVERY_NAME {} LOCATION {} PRICE_PER_PAGE 0.0 SALESMAN {}
		SERIAL_NUMBER {}}

	set all_columns(PPP_COUNT) {COMPANY_ID REF DATE ORDER_REF PAGE_COUNT STATUS}
	array set type_PPP_COUNT {COMPANY_ID 0 REF 0 DATE 3 ORDER_REF 0 PAGE_COUNT 1 STATUS 0}
	array set null_PPP_COUNT {COMPANY_ID 0 REF 0 DATE 0 ORDER_REF 1 PAGE_COUNT 0 STATUS 0}
	array set default_PPP_COUNT {COMPANY_ID {} REF {} DATE {0000-00-00 00:00:00} ORDER_REF {} PAGE_COUNT 0 STATUS {}}

	set all_columns(PPP_ITEM) {COMPANY_ID PAGE_YIELD REF PART PRICE SUPPLIER_REBATE}
	array set type_PPP_ITEM {COMPANY_ID 0 PAGE_YIELD 1 REF 0 PART 1 PRICE 2 SUPPLIER_REBATE 2}
	array set null_PPP_ITEM {COMPANY_ID 0 PAGE_YIELD 1 REF 0 PART 0 PRICE 1 SUPPLIER_REBATE 1}
	array set default_PPP_ITEM {COMPANY_ID {} PAGE_YIELD 0 REF {} PART 0 PRICE 0.0 SUPPLIER_REBATE 0.0}

	set all_columns(PPP_NOTE) {COMPANY_ID REF DATE ID TEXT USER}
	array set type_PPP_NOTE {COMPANY_ID 0 REF 0 DATE 3 ID 1 TEXT 0 USER 0}
	array set null_PPP_NOTE {COMPANY_ID 0 REF 0 DATE 1 ID 0 TEXT 1 USER 1}
	array set default_PPP_NOTE {COMPANY_ID {} REF {} DATE {} ID {} TEXT {} USER {}}

	set all_columns(PRICE_CHANGE) {COMPANY_ID PART TIME CHANGE_NOTE DATE ID SELL_PRICE1 SELL_PRICE2
		SELL_PRICE3 SELL_PRICE4 SELL_PRICE5 SELL_PRICE6 SELL_PRICE7 SELL_PRICE8 SELL_PRICE9 SELL_PRICE10
		SUPPLIER_LIST_PRICE USER}
	array set type_PRICE_CHANGE {COMPANY_ID 0 PART 1 TIME 0 CHANGE_NOTE 0 DATE 3 ID 1
		SELL_PRICE1 2 SELL_PRICE2 2 SELL_PRICE3 2 SELL_PRICE4 2 SELL_PRICE5 2 SELL_PRICE6 2
		SELL_PRICE7 2 SELL_PRICE8 2 SELL_PRICE9 2 SELL_PRICE10 2 SUPPLIER_LIST_PRICE 2 USER 0}
	array set null_PRICE_CHANGE {COMPANY_ID 0 PART 0 TIME 0 CHANGE_NOTE 0 DATE 0 ID 0
		SELL_PRICE1 1 SELL_PRICE2 1 SELL_PRICE3 1 SELL_PRICE4 1 SELL_PRICE5 1 SELL_PRICE6 1
		SELL_PRICE7 1 SELL_PRICE8 1 SELL_PRICE9 1 SELL_PRICE10 1 SUPPLIER_LIST_PRICE 1 USER 0}
	array set default_PRICE_CHANGE {COMPANY_ID {} PART 0 TIME {} CHANGE_NOTE {} DATE {0000-00-00 00:00:00} ID {}
		SELL_PRICE1 0.0 SELL_PRICE2 0.0 SELL_PRICE3 0.0 SELL_PRICE4 0.0 SELL_PRICE5 0.0 SELL_PRICE6 0.0
		SELL_PRICE7 0.0 SELL_PRICE8 0.0 SELL_PRICE9 0.0 SELL_PRICE10 0.0 SUPPLIER_LIST_PRICE 0.0 USER {}}

	set all_columns(PRICE_CODE) {COMPANY_ID PRICE_CODE NAME}
	array set type_PRICE_CODE {COMPANY_ID 0 PRICE_CODE 0 NAME 0}
	array set null_PRICE_CODE {COMPANY_ID 0 PRICE_CODE 0 NAME 0}
	array set default_PRICE_CODE {COMPANY_ID {} PRICE_CODE {} NAME {}}

	set all_columns(PRICE_UPDATE_LINE) {COMPANY_ID SORT_SEQUENCE UPDATE_NO PART SELL_PRICE1 SELL_PRICE2 SELL_PRICE3 SELL_PRICE4
		SELL_PRICE5 SELL_PRICE6 SELL_PRICE7 SELL_PRICE8 SELL_PRICE9 SELL_PRICE10}
	array set type_PRICE_UPDATE_LINE {COMPANY_ID 0 SORT_SEQUENCE 0 UPDATE_NO 1 PART 1 SELL_PRICE1 2 SELL_PRICE2 2
		SELL_PRICE3 2 SELL_PRICE4 2 SELL_PRICE5 2 SELL_PRICE6 2 SELL_PRICE7 2 SELL_PRICE8 2
		SELL_PRICE9 2 SELL_PRICE10 2}
	array set null_PRICE_UPDATE_LINE {COMPANY_ID 0 SORT_SEQUENCE 0 UPDATE_NO 0 PART 0 SELL_PRICE1 1 SELL_PRICE2 1
		SELL_PRICE3 1 SELL_PRICE4 1 SELL_PRICE5 1 SELL_PRICE6 1 SELL_PRICE7 1 SELL_PRICE8 1
		SELL_PRICE9 1 SELL_PRICE10 1}
	array set default_PRICE_UPDATE_LINE {COMPANY_ID {} SORT_SEQUENCE {} UPDATE_NO {} PART {} SELL_PRICE1 0.0 SELL_PRICE2 0.0
		SELL_PRICE3 0.0 SELL_PRICE4 0.0 SELL_PRICE5 0.0 SELL_PRICE6 0.0 SELL_PRICE7 0.0 SELL_PRICE8 0.0
		SELL_PRICE9 0.0 SELL_PRICE10 0.0}

	set all_columns(PRINTER) {ID COMPANY_ID BRANCH NAME OUTPUT CLOSE_STRING COMMAND COMMAND_STYLE
		DEFAULT_PAGE_LENGTH DEFAULT_PAGE_WIDTH INIT_STRING PORTRAIT PRINTER_PORT PRINTER_TYPE SECURITY_LEVEL}
	array set type_PRINTER {ID 1 COMPANY_ID 0 BRANCH 0 NAME 0 OUTPUT 0 CLOSE_STRING 0
		COMMAND 0 COMMAND_STYLE 0 DEFAULT_PAGE_LENGTH 1 DEFAULT_PAGE_WIDTH 1 INIT_STRING 0 PORTRAIT 0
		PRINTER_PORT 0 PRINTER_TYPE 0 SECURITY_LEVEL 1}
	array set null_PRINTER {ID 0 COMPANY_ID 1 BRANCH 1 NAME 0 OUTPUT 1 CLOSE_STRING 1
		COMMAND 1 COMMAND_STYLE 1 DEFAULT_PAGE_LENGTH 1 DEFAULT_PAGE_WIDTH 1 INIT_STRING 1 PORTRAIT 1
		PRINTER_PORT 1 PRINTER_TYPE 1 SECURITY_LEVEL 1}
	array set default_PRINTER {ID {} COMPANY_ID {} BRANCH {} NAME {} OUTPUT {} CLOSE_STRING {}
		COMMAND {} COMMAND_STYLE {} DEFAULT_PAGE_LENGTH 0 DEFAULT_PAGE_WIDTH 0 INIT_STRING {} PORTRAIT {}
		PRINTER_PORT {} PRINTER_TYPE {} SECURITY_LEVEL 0}

	set all_columns(PRODUCT_AUTOMOTIVE) {COMPANY_ID PART AUTOMOTIVE_MODEL_ID CHASSIS ENGINE ID NOTES POSITION
		YEAR_FROM YEAR_TO}
	array set type_PRODUCT_AUTOMOTIVE {COMPANY_ID 0 PART 1 AUTOMOTIVE_MODEL_ID 0 CHASSIS 0 ENGINE 0 ID 1
		NOTES 0 POSITION 0 YEAR_FROM 1 YEAR_TO 1}
	array set null_PRODUCT_AUTOMOTIVE {COMPANY_ID 0 PART 0 AUTOMOTIVE_MODEL_ID 0 CHASSIS 1 ENGINE 1 ID 0
		NOTES 1 POSITION 1 YEAR_FROM 1 YEAR_TO 1}
	array set default_PRODUCT_AUTOMOTIVE {COMPANY_ID {} PART {} AUTOMOTIVE_MODEL_ID {} CHASSIS {} ENGINE {} ID {}
		NOTES {} POSITION {} YEAR_FROM 0 YEAR_TO 0}

	set all_columns(PRODUCT_BARCODES) {COMPANY_ID PART PART_BARCODE SUPPLIER_BARCODE CUBIC HEIGHT INNER_BARCODE INNER_QTY
		INNER_WEIGHT OUTER_BARCODE OUTER_QTY OUTER_WEIGHT WIDTH LENGTH}
	array set type_PRODUCT_BARCODES {COMPANY_ID 0 PART 1 PART_BARCODE 0 SUPPLIER_BARCODE 0 CUBIC 2 HEIGHT 2
		INNER_BARCODE 0 INNER_QTY 2 INNER_WEIGHT 2 OUTER_BARCODE 0 OUTER_QTY 2 OUTER_WEIGHT 2
		WIDTH 2 LENGTH 2}
	array set null_PRODUCT_BARCODES {COMPANY_ID 0 PART 0 PART_BARCODE 1 SUPPLIER_BARCODE 1 CUBIC 1 HEIGHT 1
		INNER_BARCODE 1 INNER_QTY 1 INNER_WEIGHT 1 OUTER_BARCODE 1 OUTER_QTY 1 OUTER_WEIGHT 1
		WIDTH 1 LENGTH 1}
	array set default_PRODUCT_BARCODES {COMPANY_ID {} PART {} PART_BARCODE {} SUPPLIER_BARCODE {} CUBIC 0.0 HEIGHT 0.0
		INNER_BARCODE {} INNER_QTY 0.0 INNER_WEIGHT 0.0 OUTER_BARCODE {} OUTER_QTY 0.0 OUTER_WEIGHT 0.0
		WIDTH 0.0 LENGTH 0.0}

	set all_columns(PRODUCT_EXTRAS) {COMPANY_ID PART SPECIAL_LEVEL MODEL_NUMBER WEB_NAME SPECIAL_LEVEL_EXPIRY CHARGE1 CHARGE2
		CHARGE3 CHARGE4 CHARGE5 LABEL_TEXT PRODUCT_INFO_FILE RELEASE_DATE RETURN_DATE TARIFF_CLASS
		TYPE1 TYPE2 TYPE3 TYPE4 TYPE5 WEB_DESCRIPTION}
	array set type_PRODUCT_EXTRAS {COMPANY_ID 0 PART 1 SPECIAL_LEVEL 0 MODEL_NUMBER 0 WEB_NAME 0 SPECIAL_LEVEL_EXPIRY 3
		CHARGE1 2 CHARGE2 2 CHARGE3 2 CHARGE4 2 CHARGE5 2 LABEL_TEXT 0
		PRODUCT_INFO_FILE 0 RELEASE_DATE 3 RETURN_DATE 3 TARIFF_CLASS 0 TYPE1 0 TYPE2 0
		TYPE3 0 TYPE4 0 TYPE5 0 WEB_DESCRIPTION 0}
	array set null_PRODUCT_EXTRAS {COMPANY_ID 0 PART 0 SPECIAL_LEVEL 1 MODEL_NUMBER 1 WEB_NAME 1 SPECIAL_LEVEL_EXPIRY 1
		CHARGE1 1 CHARGE2 1 CHARGE3 1 CHARGE4 1 CHARGE5 1 LABEL_TEXT 1
		PRODUCT_INFO_FILE 1 RELEASE_DATE 1 RETURN_DATE 1 TARIFF_CLASS 1 TYPE1 1 TYPE2 1
		TYPE3 1 TYPE4 1 TYPE5 1 WEB_DESCRIPTION 1}
	array set default_PRODUCT_EXTRAS {COMPANY_ID {} PART 0 SPECIAL_LEVEL {} MODEL_NUMBER {} WEB_NAME {} SPECIAL_LEVEL_EXPIRY {}
		CHARGE1 0.0 CHARGE2 0.0 CHARGE3 0.0 CHARGE4 0.0 CHARGE5 0.0 LABEL_TEXT {}
		PRODUCT_INFO_FILE {} RELEASE_DATE {} RETURN_DATE {} TARIFF_CLASS {} TYPE1 {} TYPE2 {}
		TYPE3 {} TYPE4 {} TYPE5 {} WEB_DESCRIPTION {}}

	set all_columns(PRODUCT_TYPE_CATEGORY) {COMPANY_ID DESCRIPTION ID HIERARCHY WEB_DISPLAY}
	array set type_PRODUCT_TYPE_CATEGORY {COMPANY_ID 0 DESCRIPTION 0 ID 0 HIERARCHY 0 WEB_DISPLAY 0}
	array set null_PRODUCT_TYPE_CATEGORY {COMPANY_ID 0 DESCRIPTION 1 ID 0 HIERARCHY 1 WEB_DISPLAY 1}
	array set default_PRODUCT_TYPE_CATEGORY {COMPANY_ID {} DESCRIPTION {} ID {} HIERARCHY {} WEB_DISPLAY {}}

	set all_columns(PURCHASE_LINE) {COMPANY_ID REF SORT_SEQUENCE STATUS PART LINE_NO QTY_REQUIRED DUE_DATE
		QTY_RECEIVED NON_STOCK_PART BRAND_NAME NET_PRICE NON_STOCK_NAME NON_STOCK_NAME2 NON_STOCK_REF_NO NON_STOCK_TYPE
		ORDER_VALUE SUPPLIER_DISCOUNT SUPPLIER_LIST TEXT}
	array set type_PURCHASE_LINE {COMPANY_ID 0 REF 0 SORT_SEQUENCE 0 STATUS 0 PART 1 LINE_NO 1
		QTY_REQUIRED 2 DUE_DATE 3 QTY_RECEIVED 2 NON_STOCK_PART 0 BRAND_NAME 0 NET_PRICE 2
		NON_STOCK_NAME 0 NON_STOCK_NAME2 0 NON_STOCK_REF_NO 1 NON_STOCK_TYPE 0 ORDER_VALUE 2 SUPPLIER_DISCOUNT 2
		SUPPLIER_LIST 2 TEXT 0}
	array set null_PURCHASE_LINE {COMPANY_ID 0 REF 0 SORT_SEQUENCE 0 STATUS 1 PART 0 LINE_NO 1
		QTY_REQUIRED 1 DUE_DATE 1 QTY_RECEIVED 1 NON_STOCK_PART 1 BRAND_NAME 1 NET_PRICE 1
		NON_STOCK_NAME 1 NON_STOCK_NAME2 1 NON_STOCK_REF_NO 1 NON_STOCK_TYPE 1 ORDER_VALUE 1 SUPPLIER_DISCOUNT 1
		SUPPLIER_LIST 1 TEXT 1}
	array set default_PURCHASE_LINE {COMPANY_ID {} REF {} SORT_SEQUENCE {} STATUS {} PART 0 LINE_NO 0
		QTY_REQUIRED 0.0 DUE_DATE {} QTY_RECEIVED 0.0 NON_STOCK_PART {} BRAND_NAME {} NET_PRICE 0.0
		NON_STOCK_NAME {} NON_STOCK_NAME2 {} NON_STOCK_REF_NO 0 NON_STOCK_TYPE {} ORDER_VALUE 0.0 SUPPLIER_DISCOUNT 0.0
		SUPPLIER_LIST 0.0 TEXT {}}

	set all_columns(PURCHASE_ORDER) {COMPANY_ID REF STATUS SUPPLIER BRANCH ORDER_DATE SHIP_TO_CUSTOMER ORDER_VALUE
		LOG ACKNOWLEDGEMENT_DATE COMMERCIAL_TERMS CURRENCY CUSTOMER CUSTOMER_REF DUE_DATE EX_WORKS_DATE
		FOLLOW_UP_DATE FOLLOW_UP_NOTE INSTRUCTIONS INTERNAL_REF OPEN_PURCHASE OPERATOR PAYMENT_TERMS PRICING_FLAG
		PRINTED QUOTED_EXCHANGE_RATE SHIP_TO_ADDRESS SHIP_TO_NAME SHIPPING_DETAILS SUPPLIER_CONTACT SUPPLIER_FAX SUPPLIER_PHONE
		SUPPLIER_REF TAX_TYPE}
	array set type_PURCHASE_ORDER {COMPANY_ID 0 REF 0 STATUS 0 SUPPLIER 1 BRANCH 0 ORDER_DATE 3
		SHIP_TO_CUSTOMER 0 ORDER_VALUE 2 LOG 0 ACKNOWLEDGEMENT_DATE 3 COMMERCIAL_TERMS 0 CURRENCY 0
		CUSTOMER 1 CUSTOMER_REF 0 DUE_DATE 3 EX_WORKS_DATE 3 FOLLOW_UP_DATE 3 FOLLOW_UP_NOTE 0
		INSTRUCTIONS 0 INTERNAL_REF 0 OPEN_PURCHASE 0 OPERATOR 0 PAYMENT_TERMS 0 PRICING_FLAG 0
		PRINTED 0 QUOTED_EXCHANGE_RATE 2 SHIP_TO_ADDRESS 0 SHIP_TO_NAME 0 SHIPPING_DETAILS 0 SUPPLIER_CONTACT 0
		SUPPLIER_FAX 0 SUPPLIER_PHONE 0 SUPPLIER_REF 0 TAX_TYPE 0}
	array set null_PURCHASE_ORDER {COMPANY_ID 0 REF 0 STATUS 1 SUPPLIER 0 BRANCH 0 ORDER_DATE 1
		SHIP_TO_CUSTOMER 1 ORDER_VALUE 1 LOG 1 ACKNOWLEDGEMENT_DATE 1 COMMERCIAL_TERMS 1 CURRENCY 1
		CUSTOMER 1 CUSTOMER_REF 1 DUE_DATE 1 EX_WORKS_DATE 1 FOLLOW_UP_DATE 1 FOLLOW_UP_NOTE 1
		INSTRUCTIONS 1 INTERNAL_REF 1 OPEN_PURCHASE 1 OPERATOR 1 PAYMENT_TERMS 1 PRICING_FLAG 1
		PRINTED 1 QUOTED_EXCHANGE_RATE 1 SHIP_TO_ADDRESS 1 SHIP_TO_NAME 1 SHIPPING_DETAILS 1 SUPPLIER_CONTACT 1
		SUPPLIER_FAX 1 SUPPLIER_PHONE 1 SUPPLIER_REF 1 TAX_TYPE 1}
	array set default_PURCHASE_ORDER {COMPANY_ID {} REF {} STATUS {} SUPPLIER 0 BRANCH {} ORDER_DATE {}
		SHIP_TO_CUSTOMER {} ORDER_VALUE 0.0 LOG {} ACKNOWLEDGEMENT_DATE {} COMMERCIAL_TERMS {} CURRENCY {}
		CUSTOMER 0 CUSTOMER_REF {} DUE_DATE {} EX_WORKS_DATE {} FOLLOW_UP_DATE {} FOLLOW_UP_NOTE {}
		INSTRUCTIONS {} INTERNAL_REF {} OPEN_PURCHASE {} OPERATOR {} PAYMENT_TERMS {} PRICING_FLAG {}
		PRINTED {} QUOTED_EXCHANGE_RATE 0.0 SHIP_TO_ADDRESS {} SHIP_TO_NAME {} SHIPPING_DETAILS {} SUPPLIER_CONTACT {}
		SUPPLIER_FAX {} SUPPLIER_PHONE {} SUPPLIER_REF {} TAX_TYPE {}}

	set all_columns(RETURN_HEADER) {COMPANY_ID REF STATUS CUSTOMER DATE STATUS_NOTE BRANCH CUSTOMER_CONTACT
		CUSTOMER_EMAIL CUSTOMER_FAX CUSTOMER_PHONE EXPIRY_DATE INVOICE_REF NOTES OPERATOR}
	array set type_RETURN_HEADER {COMPANY_ID 0 REF 0 STATUS 0 CUSTOMER 1 DATE 3 STATUS_NOTE 0
		BRANCH 0 CUSTOMER_CONTACT 0 CUSTOMER_EMAIL 0 CUSTOMER_FAX 0 CUSTOMER_PHONE 0 EXPIRY_DATE 3
		INVOICE_REF 0 NOTES 0 OPERATOR 0}
	array set null_RETURN_HEADER {COMPANY_ID 0 REF 0 STATUS 1 CUSTOMER 0 DATE 1 STATUS_NOTE 1
		BRANCH 0 CUSTOMER_CONTACT 1 CUSTOMER_EMAIL 1 CUSTOMER_FAX 1 CUSTOMER_PHONE 1 EXPIRY_DATE 1
		INVOICE_REF 1 NOTES 1 OPERATOR 1}
	array set default_RETURN_HEADER {COMPANY_ID {} REF {} STATUS {} CUSTOMER 0 DATE {} STATUS_NOTE {}
		BRANCH {} CUSTOMER_CONTACT {} CUSTOMER_EMAIL {} CUSTOMER_FAX {} CUSTOMER_PHONE {} EXPIRY_DATE {}
		INVOICE_REF {} NOTES {} OPERATOR {}}

	set all_columns(RETURN_LINE) {COMPANY_ID REF SORT_SEQUENCE PART INVOICE_REF STATUS QTY_RETURNED COST_PRICE
		COST_VARIANCE CUSTOMER_REFERENCE DISCOUNT NET_PRICE NON_STOCK_NAME NON_STOCK_PART QTY_ORIGINAL SELL_PRICE
		TEXT}
	array set type_RETURN_LINE {COMPANY_ID 0 REF 0 SORT_SEQUENCE 0 PART 1 INVOICE_REF 0 STATUS 0
		QTY_RETURNED 2 COST_PRICE 2 COST_VARIANCE 2 CUSTOMER_REFERENCE 0 DISCOUNT 2 NET_PRICE 2
		NON_STOCK_NAME 0 NON_STOCK_PART 0 QTY_ORIGINAL 2 SELL_PRICE 2 TEXT 0}
	array set null_RETURN_LINE {COMPANY_ID 0 REF 0 SORT_SEQUENCE 0 PART 0 INVOICE_REF 1 STATUS 1
		QTY_RETURNED 1 COST_PRICE 1 COST_VARIANCE 1 CUSTOMER_REFERENCE 1 DISCOUNT 1 NET_PRICE 1
		NON_STOCK_NAME 1 NON_STOCK_PART 1 QTY_ORIGINAL 1 SELL_PRICE 1 TEXT 1}
	array set default_RETURN_LINE {COMPANY_ID {} REF {} SORT_SEQUENCE {} PART 0 INVOICE_REF {} STATUS {}
		QTY_RETURNED 0.0 COST_PRICE 0.0 COST_VARIANCE 0.0 CUSTOMER_REFERENCE {} DISCOUNT 0.0 NET_PRICE 0.0
		NON_STOCK_NAME {} NON_STOCK_PART {} QTY_ORIGINAL 0.0 SELL_PRICE 0.0 TEXT {}}

	set all_columns(RETURN_NOTE) {COMPANY_ID REF DATE ID TEXT USER}
	array set type_RETURN_NOTE {COMPANY_ID 0 REF 0 DATE 3 ID 1 TEXT 0 USER 0}
	array set null_RETURN_NOTE {COMPANY_ID 0 REF 0 DATE 1 ID 0 TEXT 1 USER 1}
	array set default_RETURN_NOTE {COMPANY_ID {} REF {} DATE {} ID {} TEXT {} USER {}}

	set all_columns(RE_ORDER) {COMPANY_ID BRANCH TYPE EXCLUSION_FACTOR FAST_QTY MAX_MONTHS_STOCK MEDIUM_QTY MIN_MONTHS_STOCK
		SLOW_QTY}
	array set type_RE_ORDER {COMPANY_ID 0 BRANCH 0 TYPE 0 EXCLUSION_FACTOR 2 FAST_QTY 2 MAX_MONTHS_STOCK 2
		MEDIUM_QTY 2 MIN_MONTHS_STOCK 2 SLOW_QTY 2}
	array set null_RE_ORDER {COMPANY_ID 0 BRANCH 0 TYPE 0 EXCLUSION_FACTOR 1 FAST_QTY 1 MAX_MONTHS_STOCK 1
		MEDIUM_QTY 1 MIN_MONTHS_STOCK 1 SLOW_QTY 1}
	array set default_RE_ORDER {COMPANY_ID {} BRANCH {} TYPE {} EXCLUSION_FACTOR 0.0 FAST_QTY 0.0 MAX_MONTHS_STOCK 0.0
		MEDIUM_QTY 0.0 MIN_MONTHS_STOCK 0.0 SLOW_QTY 0.0}

	set all_columns(SALESMAN_COMMISSION) {BRANCH_SALES_COMMISSION COMPANY_ID SALESMAN STANDARD_SALES_COMMISSION TYPE}
	array set type_SALESMAN_COMMISSION {BRANCH_SALES_COMMISSION 2 COMPANY_ID 0 SALESMAN 0 STANDARD_SALES_COMMISSION 2 TYPE 0}
	array set null_SALESMAN_COMMISSION {BRANCH_SALES_COMMISSION 1 COMPANY_ID 0 SALESMAN 0 STANDARD_SALES_COMMISSION 1 TYPE 0}
	array set default_SALESMAN_COMMISSION {BRANCH_SALES_COMMISSION 0.0 COMPANY_ID {} SALESMAN {} STANDARD_SALES_COMMISSION 0.0 TYPE {}}

	set all_columns(SAVED_REPORT) {ID COMPANY_ID REPORT USER TITLE DATA DATE}
	array set type_SAVED_REPORT {ID 1 COMPANY_ID 0 REPORT 0 USER 0 TITLE 0 DATA 0
		DATE 3}
	array set null_SAVED_REPORT {ID 0 COMPANY_ID 0 REPORT 0 USER 0 TITLE 1 DATA 0
		DATE 0}
	array set default_SAVED_REPORT {ID {} COMPANY_ID {} REPORT {} USER {} TITLE {} DATA {}
		DATE {0000-00-00 00:00:00}}

	set all_columns(SCHEDULED_PRICE_UPDATE) {COMPANY_ID EFFECTIVE_DATE DATE NOTES NOTIFICATION_SENT OPERATOR STATUS UPDATE_NO
		UPDATE_PRICE1 UPDATE_PRICE2 UPDATE_PRICE3 UPDATE_PRICE4 UPDATE_PRICE5 UPDATE_PRICE6 UPDATE_PRICE7 UPDATE_PRICE8
		UPDATE_PRICE9 UPDATE_PRICE10}
	array set type_SCHEDULED_PRICE_UPDATE {COMPANY_ID 0 EFFECTIVE_DATE 3 DATE 3 NOTES 0 NOTIFICATION_SENT 0 OPERATOR 0
		STATUS 0 UPDATE_NO 1 UPDATE_PRICE1 0 UPDATE_PRICE2 0 UPDATE_PRICE3 0 UPDATE_PRICE4 0
		UPDATE_PRICE5 0 UPDATE_PRICE6 0 UPDATE_PRICE7 0 UPDATE_PRICE8 0 UPDATE_PRICE9 0 UPDATE_PRICE10 0}
	array set null_SCHEDULED_PRICE_UPDATE {COMPANY_ID 0 EFFECTIVE_DATE 1 DATE 1 NOTES 1 NOTIFICATION_SENT 1 OPERATOR 1
		STATUS 1 UPDATE_NO 0 UPDATE_PRICE1 1 UPDATE_PRICE2 1 UPDATE_PRICE3 1 UPDATE_PRICE4 1
		UPDATE_PRICE5 1 UPDATE_PRICE6 1 UPDATE_PRICE7 1 UPDATE_PRICE8 1 UPDATE_PRICE9 1 UPDATE_PRICE10 1}
	array set default_SCHEDULED_PRICE_UPDATE {COMPANY_ID {} EFFECTIVE_DATE {} DATE {} NOTES {} NOTIFICATION_SENT {} OPERATOR {}
		STATUS {} UPDATE_NO {} UPDATE_PRICE1 {} UPDATE_PRICE2 {} UPDATE_PRICE3 {} UPDATE_PRICE4 {}
		UPDATE_PRICE5 {} UPDATE_PRICE6 {} UPDATE_PRICE7 {} UPDATE_PRICE8 {} UPDATE_PRICE9 {} UPDATE_PRICE10 {}}

	set all_columns(SERIAL_NUMBER) {PART COMPANY_ID SERIAL_NO BRANCH STATUS COST_PRICE INSTALL_ADDRESS INSTALL_DATE
		INSTALL_NAME INSTALL_NOTE INSTALL_PHONE PURCHASE_DATE QTY_ON_HAND SELL_PRICE SOLD_DATE STATUS_MSG
		CUSTOMER}
	array set type_SERIAL_NUMBER {PART 1 COMPANY_ID 0 SERIAL_NO 0 BRANCH 0 STATUS 0 COST_PRICE 2
		INSTALL_ADDRESS 0 INSTALL_DATE 3 INSTALL_NAME 0 INSTALL_NOTE 0 INSTALL_PHONE 0 PURCHASE_DATE 3
		QTY_ON_HAND 2 SELL_PRICE 2 SOLD_DATE 3 STATUS_MSG 0 CUSTOMER 1}
	array set null_SERIAL_NUMBER {PART 0 COMPANY_ID 0 SERIAL_NO 0 BRANCH 1 STATUS 0 COST_PRICE 1
		INSTALL_ADDRESS 1 INSTALL_DATE 1 INSTALL_NAME 1 INSTALL_NOTE 1 INSTALL_PHONE 1 PURCHASE_DATE 1
		QTY_ON_HAND 1 SELL_PRICE 1 SOLD_DATE 1 STATUS_MSG 0 CUSTOMER 1}
	array set default_SERIAL_NUMBER {PART 0 COMPANY_ID {} SERIAL_NO {} BRANCH {} STATUS {} COST_PRICE 0.0
		INSTALL_ADDRESS {} INSTALL_DATE {} INSTALL_NAME {} INSTALL_NOTE {} INSTALL_PHONE {} PURCHASE_DATE {}
		QTY_ON_HAND 0.0 SELL_PRICE 0.0 SOLD_DATE {} STATUS_MSG {} CUSTOMER 0}

	set all_columns(STANDARD_TEXT) {ID PROGRAM TEXT}
	array set type_STANDARD_TEXT {ID 1 PROGRAM 0 TEXT 0}
	array set null_STANDARD_TEXT {ID 0 PROGRAM 0 TEXT 1}
	array set default_STANDARD_TEXT {ID {} PROGRAM {} TEXT {}}

	set all_columns(STK_HEADER) {COMPANY_ID STATUS REF_NO DATE BRANCH SELECTED_PARTS SEQUENCE UPDATE_STATUS
		USER}
	array set type_STK_HEADER {COMPANY_ID 0 STATUS 0 REF_NO 1 DATE 3 BRANCH 0 SELECTED_PARTS 0
		SEQUENCE 0 UPDATE_STATUS 0 USER 0}
	array set null_STK_HEADER {COMPANY_ID 0 STATUS 1 REF_NO 0 DATE 0 BRANCH 0 SELECTED_PARTS 1
		SEQUENCE 0 UPDATE_STATUS 1 USER 0}
	array set default_STK_HEADER {COMPANY_ID {} STATUS {} REF_NO 0 DATE {0000-00-00 00:00:00} BRANCH {} SELECTED_PARTS {}
		SEQUENCE {} UPDATE_STATUS {} USER {}}

	set all_columns(STK_PART) {COMPANY_ID REF_NO PART SEQUENCE BRANCH QTY_COUNTED QTY_HELD QTY_ON_HAND}
	array set type_STK_PART {COMPANY_ID 0 REF_NO 1 PART 1 SEQUENCE 0 BRANCH 0 QTY_COUNTED 2
		QTY_HELD 2 QTY_ON_HAND 2}
	array set null_STK_PART {COMPANY_ID 0 REF_NO 0 PART 0 SEQUENCE 1 BRANCH 0 QTY_COUNTED 1
		QTY_HELD 1 QTY_ON_HAND 1}
	array set default_STK_PART {COMPANY_ID {} REF_NO 0 PART 0 SEQUENCE {} BRANCH {} QTY_COUNTED 0.0
		QTY_HELD 0.0 QTY_ON_HAND 0.0}

	set all_columns(STK_SERIAL) {COMPANY_ID REF_NO PART SERIAL_NO BRANCH COUNTED NOTE ORIGINAL
		QTY}
	array set type_STK_SERIAL {COMPANY_ID 0 REF_NO 1 PART 1 SERIAL_NO 0 BRANCH 0 COUNTED 2
		NOTE 0 ORIGINAL 2 QTY 2}
	array set null_STK_SERIAL {COMPANY_ID 0 REF_NO 0 PART 0 SERIAL_NO 0 BRANCH 0 COUNTED 1
		NOTE 1 ORIGINAL 1 QTY 1}
	array set default_STK_SERIAL {COMPANY_ID {} REF_NO 0 PART 0 SERIAL_NO {} BRANCH {} COUNTED 0.0
		NOTE {} ORIGINAL 0.0 QTY 0.0}

	set all_columns(STOCK_PURCHASE) {PART COMPANY_ID BRANCH REF_NO QTY VALUE AVERAGE_COST QTY_ON_HAND
		DATE}
	array set type_STOCK_PURCHASE {PART 1 COMPANY_ID 0 BRANCH 0 REF_NO 1 QTY 2 VALUE 2
		AVERAGE_COST 2 QTY_ON_HAND 2 DATE 3}
	array set null_STOCK_PURCHASE {PART 0 COMPANY_ID 0 BRANCH 0 REF_NO 0 QTY 0 VALUE 0
		AVERAGE_COST 0 QTY_ON_HAND 0 DATE 0}
	array set default_STOCK_PURCHASE {PART 0 COMPANY_ID {} BRANCH {} REF_NO 0 QTY 0.0000 VALUE 0.00
		AVERAGE_COST 0.0000 QTY_ON_HAND 0.0000 DATE {0000-00-00 00:00:00}}

	set all_columns(STOCK_QTY) {COMPANY_ID PART BRANCH WAREHOUSE_LOCATION STOCK_ON_HAND STOCK_IN_TRANSIT OTHER_LOCATION SPECIAL_QTY
		CALC_DATE LOCATION_OVERRIDE MAXIMUM_QTY MAXIMUM_QUANTITY MEDIAN_QTY MINIMUM_QTY MINIMUM_QUANTITY NOTE
		NUMBER_OF_INVOICES QUANTITY_SOLD REORDER_STRATEGY STOCK_CATEGORY STOCK_HELD STOCK_LOCATION STOCK_ON_BACKORDER STOCK_ON_ORDER
		USER LAST_PURCHASE_DATE LAST_SALE_DATE LAST_STOCK_TAKE LAST_STOCK_TAKE_QTY}
	array set type_STOCK_QTY {COMPANY_ID 0 PART 1 BRANCH 0 WAREHOUSE_LOCATION 0 STOCK_ON_HAND 2 STOCK_IN_TRANSIT 2
		OTHER_LOCATION 0 SPECIAL_QTY 2 CALC_DATE 3 LOCATION_OVERRIDE 0 MAXIMUM_QTY 2 MAXIMUM_QUANTITY 2
		MEDIAN_QTY 2 MINIMUM_QTY 2 MINIMUM_QUANTITY 2 NOTE 0 NUMBER_OF_INVOICES 1 QUANTITY_SOLD 2
		REORDER_STRATEGY 0 STOCK_CATEGORY 0 STOCK_HELD 2 STOCK_LOCATION 0 STOCK_ON_BACKORDER 2 STOCK_ON_ORDER 2
		USER 0 LAST_PURCHASE_DATE 3 LAST_SALE_DATE 3 LAST_STOCK_TAKE 3 LAST_STOCK_TAKE_QTY 2}
	array set null_STOCK_QTY {COMPANY_ID 0 PART 0 BRANCH 0 WAREHOUSE_LOCATION 1 STOCK_ON_HAND 0 STOCK_IN_TRANSIT 0
		OTHER_LOCATION 1 SPECIAL_QTY 1 CALC_DATE 1 LOCATION_OVERRIDE 1 MAXIMUM_QTY 1 MAXIMUM_QUANTITY 1
		MEDIAN_QTY 1 MINIMUM_QTY 1 MINIMUM_QUANTITY 1 NOTE 1 NUMBER_OF_INVOICES 1 QUANTITY_SOLD 1
		REORDER_STRATEGY 1 STOCK_CATEGORY 1 STOCK_HELD 0 STOCK_LOCATION 1 STOCK_ON_BACKORDER 0 STOCK_ON_ORDER 0
		USER 1 LAST_PURCHASE_DATE 1 LAST_SALE_DATE 1 LAST_STOCK_TAKE 1 LAST_STOCK_TAKE_QTY 1}
	array set default_STOCK_QTY {COMPANY_ID {} PART 0 BRANCH {} WAREHOUSE_LOCATION {} STOCK_ON_HAND 0.0000 STOCK_IN_TRANSIT 0.0000
		OTHER_LOCATION {} SPECIAL_QTY 0.0 CALC_DATE {} LOCATION_OVERRIDE {} MAXIMUM_QTY 0.0 MAXIMUM_QUANTITY 0.0
		MEDIAN_QTY 0.0 MINIMUM_QTY 0.0 MINIMUM_QUANTITY 0.0 NOTE {} NUMBER_OF_INVOICES 0 QUANTITY_SOLD 0.0
		REORDER_STRATEGY {} STOCK_CATEGORY {} STOCK_HELD 0.0000 STOCK_LOCATION {} STOCK_ON_BACKORDER 0.0000 STOCK_ON_ORDER 0.0000
		USER {} LAST_PURCHASE_DATE {} LAST_SALE_DATE {} LAST_STOCK_TAKE {} LAST_STOCK_TAKE_QTY 0.0}

	set all_columns(SUPPLIER_ADDRESS) {SUPPLIER COMPANY_ID ADDRESS ID EMAIL_ADDRESS CONTACT FAX_NO MOBILE_NO
		PHONE_NO}
	array set type_SUPPLIER_ADDRESS {SUPPLIER 1 COMPANY_ID 0 ADDRESS 0 ID 1 EMAIL_ADDRESS 0 CONTACT 0
		FAX_NO 0 MOBILE_NO 0 PHONE_NO 0}
	array set null_SUPPLIER_ADDRESS {SUPPLIER 0 COMPANY_ID 0 ADDRESS 1 ID 0 EMAIL_ADDRESS 1 CONTACT 1
		FAX_NO 1 MOBILE_NO 1 PHONE_NO 1}
	array set default_SUPPLIER_ADDRESS {SUPPLIER 0 COMPANY_ID {} ADDRESS {} ID {} EMAIL_ADDRESS {} CONTACT {}
		FAX_NO {} MOBILE_NO {} PHONE_NO {}}

	set all_columns(SUPPLIER_MARKUP) {COMPANY_ID SUPPLIER TYPE MARKUP1 MARKUP2 MARKUP3 MARKUP4 MARKUP5
		MARKUP6 MARKUP7 MARKUP8 MARKUP9 MARKUP10}
	array set type_SUPPLIER_MARKUP {COMPANY_ID 0 SUPPLIER 1 TYPE 0 MARKUP1 2 MARKUP2 2 MARKUP3 2
		MARKUP4 2 MARKUP5 2 MARKUP6 2 MARKUP7 2 MARKUP8 2 MARKUP9 2
		MARKUP10 2}
	array set null_SUPPLIER_MARKUP {COMPANY_ID 0 SUPPLIER 0 TYPE 1 MARKUP1 1 MARKUP2 1 MARKUP3 1
		MARKUP4 1 MARKUP5 1 MARKUP6 1 MARKUP7 1 MARKUP8 1 MARKUP9 1
		MARKUP10 1}
	array set default_SUPPLIER_MARKUP {COMPANY_ID {} SUPPLIER 0 TYPE {} MARKUP1 0.0 MARKUP2 0.0 MARKUP3 0.0
		MARKUP4 0.0 MARKUP5 0.0 MARKUP6 0.0 MARKUP7 0.0 MARKUP8 0.0 MARKUP9 0.0
		MARKUP10 0.0}

	set all_columns(SYSTEM) {LAST_REF_NO LAST_LINE_NO LAST_PRODUCT_AUTOMOTIVE_ID LAST_BACKUP LAST_SYSTEM_UPDATE LAST_AUTOMOTIVE_MAKE_ID LAST_AUTOMOTIVE_MODEL_ID LAST_NOTE_NO
		LAST_SERIAL_NO SUPPORT_CONTACT SUPPORT_EMAIL SUPPORT_FAX SUPPORT_PHONE SUPPORT_WWW}
	array set type_SYSTEM {LAST_REF_NO 1 LAST_LINE_NO 1 LAST_PRODUCT_AUTOMOTIVE_ID 1 LAST_BACKUP 1 LAST_SYSTEM_UPDATE 1 LAST_AUTOMOTIVE_MAKE_ID 1
		LAST_AUTOMOTIVE_MODEL_ID 1 LAST_NOTE_NO 1 LAST_SERIAL_NO 1 SUPPORT_CONTACT 0 SUPPORT_EMAIL 0 SUPPORT_FAX 0
		SUPPORT_PHONE 0 SUPPORT_WWW 0}
	array set null_SYSTEM {LAST_REF_NO 1 LAST_LINE_NO 1 LAST_PRODUCT_AUTOMOTIVE_ID 0 LAST_BACKUP 1 LAST_SYSTEM_UPDATE 0 LAST_AUTOMOTIVE_MAKE_ID 0
		LAST_AUTOMOTIVE_MODEL_ID 0 LAST_NOTE_NO 1 LAST_SERIAL_NO 1 SUPPORT_CONTACT 1 SUPPORT_EMAIL 1 SUPPORT_FAX 1
		SUPPORT_PHONE 1 SUPPORT_WWW 1}
	array set default_SYSTEM {LAST_REF_NO 0 LAST_LINE_NO 0 LAST_PRODUCT_AUTOMOTIVE_ID {} LAST_BACKUP 0 LAST_SYSTEM_UPDATE 0 LAST_AUTOMOTIVE_MAKE_ID {}
		LAST_AUTOMOTIVE_MODEL_ID {} LAST_NOTE_NO 0 LAST_SERIAL_NO 0 SUPPORT_CONTACT {} SUPPORT_EMAIL {} SUPPORT_FAX {}
		SUPPORT_PHONE {} SUPPORT_WWW {}}

	set all_columns(TAXI_PIN) {ADDRESS COMPANY_ID COST_CENTRE CUSTOMER NAME PHONE_NO PIN TYPE}
	array set type_TAXI_PIN {ADDRESS 0 COMPANY_ID 0 COST_CENTRE 0 CUSTOMER 1 NAME 0 PHONE_NO 0
		PIN 0 TYPE 0}
	array set null_TAXI_PIN {ADDRESS 1 COMPANY_ID 0 COST_CENTRE 1 CUSTOMER 0 NAME 1 PHONE_NO 1
		PIN 0 TYPE 0}
	array set default_TAXI_PIN {ADDRESS {} COMPANY_ID {} COST_CENTRE {} CUSTOMER 0 NAME {} PHONE_NO {}
		PIN {} TYPE {}}

	set all_columns(TAXI_PIN_DATA) {CAB COMPANY_ID COST_CENTRE DATA_ID DATA_STATUS DATE DESTINATION FARE
		FROM1 FROM2 ID JOB_STATUS NAME PIN TIME TRIP}
	array set type_TAXI_PIN_DATA {CAB 0 COMPANY_ID 0 COST_CENTRE 0 DATA_ID 0 DATA_STATUS 0 DATE 0
		DESTINATION 0 FARE 2 FROM1 0 FROM2 0 ID 1 JOB_STATUS 0
		NAME 0 PIN 0 TIME 0 TRIP 0}
	array set null_TAXI_PIN_DATA {CAB 1 COMPANY_ID 0 COST_CENTRE 1 DATA_ID 0 DATA_STATUS 0 DATE 1
		DESTINATION 1 FARE 1 FROM1 1 FROM2 1 ID 0 JOB_STATUS 1
		NAME 1 PIN 0 TIME 1 TRIP 1}
	array set default_TAXI_PIN_DATA {CAB {} COMPANY_ID {} COST_CENTRE {} DATA_ID {} DATA_STATUS {} DATE {}
		DESTINATION {} FARE 0.0 FROM1 {} FROM2 {} ID {} JOB_STATUS {}
		NAME {} PIN {} TIME {} TRIP {}}

	set all_columns(TAXI_VOUCHER) {ADJUSTMENT_REF_NO AMOUNT CLIENT_NAME CLIENT_REF COMPANY_ID COST_CENTRE CUSTOMER DISCOUNT
		ENTERED_DATETIME EXPORT_BATCH FULL_FARE HOIST_NO ID INVOICE_REF_NO PASSENGERS REF_NO
		RIDE_DATE RIDE_FROM RIDE_TO STATUS USER_ID VOUCHER_NO}
	array set type_TAXI_VOUCHER {ADJUSTMENT_REF_NO 1 AMOUNT 2 CLIENT_NAME 0 CLIENT_REF 0 COMPANY_ID 0 COST_CENTRE 0
		CUSTOMER 1 DISCOUNT 2 ENTERED_DATETIME 3 EXPORT_BATCH 1 FULL_FARE 2 HOIST_NO 0
		ID 1 INVOICE_REF_NO 1 PASSENGERS 1 REF_NO 1 RIDE_DATE 3 RIDE_FROM 0
		RIDE_TO 0 STATUS 0 USER_ID 0 VOUCHER_NO 0}
	array set null_TAXI_VOUCHER {ADJUSTMENT_REF_NO 1 AMOUNT 1 CLIENT_NAME 1 CLIENT_REF 1 COMPANY_ID 0 COST_CENTRE 1
		CUSTOMER 0 DISCOUNT 1 ENTERED_DATETIME 0 EXPORT_BATCH 1 FULL_FARE 1 HOIST_NO 1
		ID 0 INVOICE_REF_NO 1 PASSENGERS 1 REF_NO 0 RIDE_DATE 1 RIDE_FROM 1
		RIDE_TO 1 STATUS 1 USER_ID 0 VOUCHER_NO 1}
	array set default_TAXI_VOUCHER {ADJUSTMENT_REF_NO 0 AMOUNT 0.0 CLIENT_NAME {} CLIENT_REF {} COMPANY_ID {} COST_CENTRE {}
		CUSTOMER 0 DISCOUNT 0.0 ENTERED_DATETIME {0000-00-00 00:00:00} EXPORT_BATCH 0 FULL_FARE 0.0 HOIST_NO {}
		ID {} INVOICE_REF_NO 0 PASSENGERS 0 REF_NO 0 RIDE_DATE {} RIDE_FROM {}
		RIDE_TO {} STATUS {} USER_ID {} VOUCHER_NO {}}

	set all_columns(TAXI_ZONE) {CODE COMPANY_ID NAME}
	array set type_TAXI_ZONE {CODE 0 COMPANY_ID 0 NAME 0}
	array set null_TAXI_ZONE {CODE 0 COMPANY_ID 0 NAME 0}
	array set default_TAXI_ZONE {CODE {} COMPANY_ID {} NAME {}}

	set all_columns(TAX_CODE) {CODE NAME TAX_INPUTS_ACCOUNT DATE1 DATE2 DATE3 DATE4 DATE5
		RATE1 RATE2 RATE3 RATE4 RATE5 TAX_OUTPUTS_ACCOUNT}
	array set type_TAX_CODE {CODE 0 NAME 0 TAX_INPUTS_ACCOUNT 1 DATE1 3 DATE2 3 DATE3 3
		DATE4 3 DATE5 3 RATE1 2 RATE2 2 RATE3 2 RATE4 2
		RATE5 2 TAX_OUTPUTS_ACCOUNT 1}
	array set null_TAX_CODE {CODE 0 NAME 0 TAX_INPUTS_ACCOUNT 1 DATE1 1 DATE2 1 DATE3 1
		DATE4 1 DATE5 1 RATE1 1 RATE2 1 RATE3 1 RATE4 1
		RATE5 1 TAX_OUTPUTS_ACCOUNT 1}
	array set default_TAX_CODE {CODE {} NAME {} TAX_INPUTS_ACCOUNT 0 DATE1 {} DATE2 {} DATE3 {}
		DATE4 {} DATE5 {} RATE1 0.0 RATE2 0.0 RATE3 0.0 RATE4 0.0
		RATE5 0.0 TAX_OUTPUTS_ACCOUNT 0}

	set all_columns(TICKET) {DISPATCH_NO COMPANY_ID REF_NO ORDER_NO ITEM_NO PACKING_SLIP TICKET COURIER_TYPE
		COURIER PRINT_CLOCK MANIFEST_BATCH WEIGHT STATUS_MESSAGE ADHOC_REFERENCE SERVICE ADHOC_ADDRESS
		ADHOC_NAME CITY_CODE DELIVERY_INSTRUCTIONS DESTINATION DISPATCH_BRANCH FREIGHT_COST LABEL_TEXT PHONE_NO
		SATCHEL SATURDAY_DELIVERY SIGNATURE_REQUIRED USER_ID VOLUME}
	array set type_TICKET {DISPATCH_NO 1 COMPANY_ID 0 REF_NO 1 ORDER_NO 0 ITEM_NO 1 PACKING_SLIP 0
		TICKET 0 COURIER_TYPE 0 COURIER 0 PRINT_CLOCK 1 MANIFEST_BATCH 1 WEIGHT 2
		STATUS_MESSAGE 0 ADHOC_REFERENCE 0 SERVICE 0 ADHOC_ADDRESS 0 ADHOC_NAME 0 CITY_CODE 0
		DELIVERY_INSTRUCTIONS 0 DESTINATION 0 DISPATCH_BRANCH 0 FREIGHT_COST 2 LABEL_TEXT 0 PHONE_NO 0
		SATCHEL 0 SATURDAY_DELIVERY 0 SIGNATURE_REQUIRED 0 USER_ID 0 VOLUME 2}
	array set null_TICKET {DISPATCH_NO 0 COMPANY_ID 0 REF_NO 1 ORDER_NO 1 ITEM_NO 0 PACKING_SLIP 1
		TICKET 1 COURIER_TYPE 1 COURIER 1 PRINT_CLOCK 1 MANIFEST_BATCH 1 WEIGHT 1
		STATUS_MESSAGE 1 ADHOC_REFERENCE 1 SERVICE 1 ADHOC_ADDRESS 1 ADHOC_NAME 1 CITY_CODE 1
		DELIVERY_INSTRUCTIONS 1 DESTINATION 1 DISPATCH_BRANCH 1 FREIGHT_COST 1 LABEL_TEXT 1 PHONE_NO 1
		SATCHEL 1 SATURDAY_DELIVERY 1 SIGNATURE_REQUIRED 1 USER_ID 1 VOLUME 1}
	array set default_TICKET {DISPATCH_NO 0 COMPANY_ID {} REF_NO 0 ORDER_NO {} ITEM_NO 0 PACKING_SLIP {}
		TICKET {} COURIER_TYPE {} COURIER {} PRINT_CLOCK 0 MANIFEST_BATCH 0 WEIGHT 0.0
		STATUS_MESSAGE {} ADHOC_REFERENCE {} SERVICE {} ADHOC_ADDRESS {} ADHOC_NAME {} CITY_CODE {}
		DELIVERY_INSTRUCTIONS {} DESTINATION {} DISPATCH_BRANCH {} FREIGHT_COST 0.0 LABEL_TEXT {} PHONE_NO {}
		SATCHEL {} SATURDAY_DELIVERY {} SIGNATURE_REQUIRED {} USER_ID {} VOLUME 0.0}

	set all_columns(TRAN) {COMPANY_ID HEADER REF_NO MODULE ACCOUNT TYPE REF SORT_SEQUENCE
		ORIGINAL_ACCOUNT BATCH_NO DATE TRANSFER_RECEIPTED ORDER_NO ORIGINAL_REF STATUS AMOUNT
		TRANSFER_BRANCH EXCHANGE_RATE INTERNAL_REF PAYMENT_METHOD AGING_METHOD ZERO_DATE BRANCH CROSS_REF_NO
		TOTAL UPDATED_RATE NON_STOCK_NAME NON_STOCK_PART TAX_TYPE QTY COST_OF_SALES RATE
		COST_PRICE COST_VARIANCE CURRENCY_CODE DELIVERY_METHOD DELIVERY_NAME LANDED_COST LINE_NOTE APPLY_TO_COST
		APPLY_VALUE1 APPLY_VALUE2 APPLY_VALUE3 APPLY_VALUE4 APPLY_VALUE5 APPLY_VALUE6 CONSIGNMENT_NO CREDIT
		CUSTOMER_REFERENCE DEBIT DELIVERY_ADDRESS DISCOUNT DUE_DATE FREIGHT LIST_PRICE MANUAL_FACTOR
		NARRATION NON_STOCK_REF_NO NON_STOCK_TYPE OPERATOR ORIGINAL_QTY PAYEE PAYMENT_DETAIL PERSONAL_MESSAGE
		SALESMAN SURCHARGE TEXT}
	array set type_TRAN {COMPANY_ID 0 HEADER 0 REF_NO 1 MODULE 0 ACCOUNT 1 TYPE 0
		REF 0 SORT_SEQUENCE 0 ORIGINAL_ACCOUNT 1 BATCH_NO 1 DATE 3 TRANSFER_RECEIPTED 0
		ORDER_NO 0 ORIGINAL_REF 0 STATUS 0 AMOUNT 2 TRANSFER_BRANCH 0 EXCHANGE_RATE 2
		INTERNAL_REF 0 PAYMENT_METHOD 0 AGING_METHOD 0 ZERO_DATE 3 BRANCH 0 CROSS_REF_NO 1
		TOTAL 2 UPDATED_RATE 2 NON_STOCK_NAME 0 NON_STOCK_PART 0 TAX_TYPE 0 QTY 2
		COST_OF_SALES 2 RATE 2 COST_PRICE 2 COST_VARIANCE 2 CURRENCY_CODE 0 DELIVERY_METHOD 0
		DELIVERY_NAME 0 LANDED_COST 2 LINE_NOTE 0 APPLY_TO_COST 0 APPLY_VALUE1 2 APPLY_VALUE2 2
		APPLY_VALUE3 2 APPLY_VALUE4 2 APPLY_VALUE5 2 APPLY_VALUE6 2 CONSIGNMENT_NO 0 CREDIT 2
		CUSTOMER_REFERENCE 0 DEBIT 2 DELIVERY_ADDRESS 0 DISCOUNT 2 DUE_DATE 3 FREIGHT 2
		LIST_PRICE 2 MANUAL_FACTOR 0 NARRATION 0 NON_STOCK_REF_NO 1 NON_STOCK_TYPE 0 OPERATOR 0
		ORIGINAL_QTY 2 PAYEE 0 PAYMENT_DETAIL 0 PERSONAL_MESSAGE 0 SALESMAN 0 SURCHARGE 2
		TEXT 0}
	array set null_TRAN {COMPANY_ID 0 HEADER 0 REF_NO 0 MODULE 0 ACCOUNT 0 TYPE 0
		REF 1 SORT_SEQUENCE 0 ORIGINAL_ACCOUNT 1 BATCH_NO 0 DATE 0 TRANSFER_RECEIPTED 1
		ORDER_NO 1 ORIGINAL_REF 1 STATUS 1 AMOUNT 1 TRANSFER_BRANCH 1 EXCHANGE_RATE 1
		INTERNAL_REF 1 PAYMENT_METHOD 1 AGING_METHOD 1 ZERO_DATE 1 BRANCH 1 CROSS_REF_NO 1
		TOTAL 1 UPDATED_RATE 1 NON_STOCK_NAME 1 NON_STOCK_PART 1 TAX_TYPE 1 QTY 1
		COST_OF_SALES 1 RATE 1 COST_PRICE 1 COST_VARIANCE 1 CURRENCY_CODE 1 DELIVERY_METHOD 1
		DELIVERY_NAME 1 LANDED_COST 1 LINE_NOTE 1 APPLY_TO_COST 1 APPLY_VALUE1 1 APPLY_VALUE2 1
		APPLY_VALUE3 1 APPLY_VALUE4 1 APPLY_VALUE5 1 APPLY_VALUE6 1 CONSIGNMENT_NO 1 CREDIT 1
		CUSTOMER_REFERENCE 1 DEBIT 1 DELIVERY_ADDRESS 1 DISCOUNT 1 DUE_DATE 1 FREIGHT 1
		LIST_PRICE 1 MANUAL_FACTOR 1 NARRATION 1 NON_STOCK_REF_NO 1 NON_STOCK_TYPE 1 OPERATOR 1
		ORIGINAL_QTY 1 PAYEE 1 PAYMENT_DETAIL 1 PERSONAL_MESSAGE 1 SALESMAN 1 SURCHARGE 1
		TEXT 1}
	array set default_TRAN {COMPANY_ID {} HEADER {} REF_NO 0 MODULE {} ACCOUNT 0 TYPE {}
		REF {} SORT_SEQUENCE {} ORIGINAL_ACCOUNT 0 BATCH_NO 0 DATE {0000-00-00 00:00:00} TRANSFER_RECEIPTED {}
		ORDER_NO {} ORIGINAL_REF {} STATUS {} AMOUNT 0.0 TRANSFER_BRANCH {} EXCHANGE_RATE 0.0
		INTERNAL_REF {} PAYMENT_METHOD {} AGING_METHOD {} ZERO_DATE {} BRANCH {} CROSS_REF_NO 0
		TOTAL 0.0 UPDATED_RATE 0.0 NON_STOCK_NAME {} NON_STOCK_PART {} TAX_TYPE {} QTY 0.0
		COST_OF_SALES 0.0 RATE 0.0 COST_PRICE 0.0 COST_VARIANCE 0.0 CURRENCY_CODE {} DELIVERY_METHOD {}
		DELIVERY_NAME {} LANDED_COST 0.0 LINE_NOTE {} APPLY_TO_COST {} APPLY_VALUE1 0.0 APPLY_VALUE2 0.0
		APPLY_VALUE3 0.0 APPLY_VALUE4 0.0 APPLY_VALUE5 0.0 APPLY_VALUE6 0.0 CONSIGNMENT_NO {} CREDIT 0.0
		CUSTOMER_REFERENCE {} DEBIT 0.0 DELIVERY_ADDRESS {} DISCOUNT 0.0 DUE_DATE {} FREIGHT 0.0
		LIST_PRICE 0.0 MANUAL_FACTOR {} NARRATION {} NON_STOCK_REF_NO 0 NON_STOCK_TYPE {} OPERATOR {}
		ORIGINAL_QTY 0.0 PAYEE {} PAYMENT_DETAIL {} PERSONAL_MESSAGE {} SALESMAN {} SURCHARGE 0.0
		TEXT {}}

	set all_columns(TRAN_APPLY) {COMPANY_ID APPLY_NO REF_NO INVOICE_DATE PAYMENT_DATE AMOUNT_PAID}
	array set type_TRAN_APPLY {COMPANY_ID 0 APPLY_NO 1 REF_NO 1 INVOICE_DATE 3 PAYMENT_DATE 3 AMOUNT_PAID 2}
	array set null_TRAN_APPLY {COMPANY_ID 0 APPLY_NO 0 REF_NO 0 INVOICE_DATE 1 PAYMENT_DATE 1 AMOUNT_PAID 1}
	array set default_TRAN_APPLY {COMPANY_ID {} APPLY_NO 0 REF_NO 0 INVOICE_DATE {} PAYMENT_DATE {} AMOUNT_PAID 0.0}

	set all_columns(TRAN_REF) {COMPANY_ID TYPE BRANCH LAST_NUMBER STATUS}
	array set type_TRAN_REF {COMPANY_ID 0 TYPE 0 BRANCH 0 LAST_NUMBER 1 STATUS 0}
	array set null_TRAN_REF {COMPANY_ID 0 TYPE 0 BRANCH 1 LAST_NUMBER 0 STATUS 1}
	array set default_TRAN_REF {COMPANY_ID {} TYPE {} BRANCH {} LAST_NUMBER 0 STATUS {}}

	set all_columns(TRAN_SERIAL) {COMPANY_ID SERIAL_NO PART HEADER REF_NO SORT_SEQUENCE ENTRY_SEQUENCE COST_PRICE
		STOCK_TAKE_DATE INSTALL_ADDRESS INSTALL_NAME INSTALL_NOTE QTY STOCK_TAKE_BRANCH STOCK_TAKE_FLAG}
	array set type_TRAN_SERIAL {COMPANY_ID 0 SERIAL_NO 0 PART 1 HEADER 0 REF_NO 1 SORT_SEQUENCE 0
		ENTRY_SEQUENCE 1 COST_PRICE 2 STOCK_TAKE_DATE 3 INSTALL_ADDRESS 0 INSTALL_NAME 0 INSTALL_NOTE 0
		QTY 2 STOCK_TAKE_BRANCH 0 STOCK_TAKE_FLAG 0}
	array set null_TRAN_SERIAL {COMPANY_ID 0 SERIAL_NO 0 PART 0 HEADER 0 REF_NO 0 SORT_SEQUENCE 0
		ENTRY_SEQUENCE 0 COST_PRICE 1 STOCK_TAKE_DATE 1 INSTALL_ADDRESS 1 INSTALL_NAME 1 INSTALL_NOTE 1
		QTY 1 STOCK_TAKE_BRANCH 1 STOCK_TAKE_FLAG 1}
	array set default_TRAN_SERIAL {COMPANY_ID {} SERIAL_NO {} PART 0 HEADER {} REF_NO 0 SORT_SEQUENCE {}
		ENTRY_SEQUENCE 0 COST_PRICE 0.0 STOCK_TAKE_DATE {} INSTALL_ADDRESS {} INSTALL_NAME {} INSTALL_NOTE {}
		QTY 0.0 STOCK_TAKE_BRANCH {} STOCK_TAKE_FLAG {}}

	set all_columns(TYPE_BUDGETS) {COMPANY_ID MODULE TYPE YEAR SALES01 SALES02 SALES03 SALES04
		SALES05 SALES06 SALES07 SALES08 SALES09 SALES10 SALES11 SALES12}
	array set type_TYPE_BUDGETS {COMPANY_ID 0 MODULE 0 TYPE 0 YEAR 1 SALES01 2 SALES02 2
		SALES03 2 SALES04 2 SALES05 2 SALES06 2 SALES07 2 SALES08 2
		SALES09 2 SALES10 2 SALES11 2 SALES12 2}
	array set null_TYPE_BUDGETS {COMPANY_ID 0 MODULE 0 TYPE 0 YEAR 0 SALES01 1 SALES02 1
		SALES03 1 SALES04 1 SALES05 1 SALES06 1 SALES07 1 SALES08 1
		SALES09 1 SALES10 1 SALES11 1 SALES12 1}
	array set default_TYPE_BUDGETS {COMPANY_ID {} MODULE {} TYPE {} YEAR 0 SALES01 0.0 SALES02 0.0
		SALES03 0.0 SALES04 0.0 SALES05 0.0 SALES06 0.0 SALES07 0.0 SALES08 0.0
		SALES09 0.0 SALES10 0.0 SALES11 0.0 SALES12 0.0}

	set all_columns(TYPE_DATA) {MODULE COMPANY_ID HEADING_ID NUMBER SEQUENCE VALUE}
	array set type_TYPE_DATA {MODULE 0 COMPANY_ID 0 HEADING_ID 1 NUMBER 1 SEQUENCE 1 VALUE 0}
	array set null_TYPE_DATA {MODULE 0 COMPANY_ID 0 HEADING_ID 0 NUMBER 0 SEQUENCE 0 VALUE 1}
	array set default_TYPE_DATA {MODULE {} COMPANY_ID {} HEADING_ID 0 NUMBER 0 SEQUENCE 0 VALUE {}}

	set all_columns(TYPE_HEADING) {COMPANY_ID MODULE TYPE SEQUENCE DISPLAY HEADING ID}
	array set type_TYPE_HEADING {COMPANY_ID 0 MODULE 0 TYPE 0 SEQUENCE 1 DISPLAY 0 HEADING 0
		ID 1}
	array set null_TYPE_HEADING {COMPANY_ID 0 MODULE 0 TYPE 0 SEQUENCE 0 DISPLAY 1 HEADING 0
		ID 0}
	array set default_TYPE_HEADING {COMPANY_ID {} MODULE {} TYPE {} SEQUENCE 0 DISPLAY {} HEADING {}
		ID {}}

	set all_columns(USER) {USER_ID EMAIL_ADDRESS NAME AP_SECURITY AR_SECURITY CO_SECURITY FA_SECURITY GL_SECURITY
		IN_SECURITY PO_SECURITY UT_SECURITY HISTORY ADDRESS ALL_COMPANIES BRANCH_ID CALL_TYPE
		COMPANY_ID DEFAULT_OUTPUT DEFAULT_PRINTER DEFAULT_SALESPERSON DEFAULT_START FAX_NO HIDE_COSTS MINIMUM_MARGIN
		MOBILE_PHONE NOTES OPTIONS PASSWORD PHONE_NO POSITION SS_SECURITY TAG}
	array set type_USER {USER_ID 0 EMAIL_ADDRESS 0 NAME 0 AP_SECURITY 1 AR_SECURITY 1 CO_SECURITY 1
		FA_SECURITY 1 GL_SECURITY 1 IN_SECURITY 1 PO_SECURITY 1 UT_SECURITY 1 HISTORY 0
		ADDRESS 0 ALL_COMPANIES 0 BRANCH_ID 0 CALL_TYPE 0 COMPANY_ID 0 DEFAULT_OUTPUT 0
		DEFAULT_PRINTER 1 DEFAULT_SALESPERSON 0 DEFAULT_START 0 FAX_NO 0 HIDE_COSTS 0 MINIMUM_MARGIN 2
		MOBILE_PHONE 0 NOTES 0 OPTIONS 0 PASSWORD 0 PHONE_NO 0 POSITION 0
		SS_SECURITY 1 TAG 0}
	array set null_USER {USER_ID 0 EMAIL_ADDRESS 1 NAME 0 AP_SECURITY 1 AR_SECURITY 1 CO_SECURITY 1
		FA_SECURITY 1 GL_SECURITY 1 IN_SECURITY 1 PO_SECURITY 1 UT_SECURITY 1 HISTORY 1
		ADDRESS 1 ALL_COMPANIES 1 BRANCH_ID 1 CALL_TYPE 1 COMPANY_ID 1 DEFAULT_OUTPUT 1
		DEFAULT_PRINTER 1 DEFAULT_SALESPERSON 1 DEFAULT_START 1 FAX_NO 1 HIDE_COSTS 1 MINIMUM_MARGIN 1
		MOBILE_PHONE 1 NOTES 1 OPTIONS 1 PASSWORD 1 PHONE_NO 1 POSITION 1
		SS_SECURITY 1 TAG 0}
	array set default_USER {USER_ID {} EMAIL_ADDRESS {} NAME {} AP_SECURITY 0 AR_SECURITY 0 CO_SECURITY 0
		FA_SECURITY 0 GL_SECURITY 0 IN_SECURITY 0 PO_SECURITY 0 UT_SECURITY 0 HISTORY {}
		ADDRESS {} ALL_COMPANIES {} BRANCH_ID {} CALL_TYPE {} COMPANY_ID {} DEFAULT_OUTPUT {}
		DEFAULT_PRINTER 0 DEFAULT_SALESPERSON {} DEFAULT_START {} FAX_NO {} HIDE_COSTS {} MINIMUM_MARGIN 0.0
		MOBILE_PHONE {} NOTES {} OPTIONS {} PASSWORD {} PHONE_NO {} POSITION {}
		SS_SECURITY 0 TAG {}}

	set all_columns(USER_COMPANY) {USER_ID LOGIN_OK COMPANY_ID}
	array set type_USER_COMPANY {USER_ID 0 LOGIN_OK 0 COMPANY_ID 0}
	array set null_USER_COMPANY {USER_ID 0 LOGIN_OK 1 COMPANY_ID 0}
	array set default_USER_COMPANY {USER_ID {} LOGIN_OK {} COMPANY_ID {}}

	set all_columns(VOUCHER_REGISTER) {ACCOUNT COMPANY_ID FIRST_NUMBER LAST_NUMBER STATUS TYPE}
	array set type_VOUCHER_REGISTER {ACCOUNT 1 COMPANY_ID 0 FIRST_NUMBER 1 LAST_NUMBER 1 STATUS 0 TYPE 0}
	array set null_VOUCHER_REGISTER {ACCOUNT 0 COMPANY_ID 0 FIRST_NUMBER 0 LAST_NUMBER 0 STATUS 1 TYPE 0}
	array set default_VOUCHER_REGISTER {ACCOUNT 0 COMPANY_ID {} FIRST_NUMBER 0 LAST_NUMBER 0 STATUS {} TYPE {}}

	set all_columns(WARRANTY_CLAIM) {COMPANY_ID CUSTOMER STATUS CREDIT_REF_NO CUSTOMER_REF DATE ID NOTES
		PART SERIAL_NO}
	array set type_WARRANTY_CLAIM {COMPANY_ID 0 CUSTOMER 1 STATUS 0 CREDIT_REF_NO 1 CUSTOMER_REF 0 DATE 3
		ID 1 NOTES 0 PART 1 SERIAL_NO 0}
	array set null_WARRANTY_CLAIM {COMPANY_ID 0 CUSTOMER 0 STATUS 0 CREDIT_REF_NO 1 CUSTOMER_REF 1 DATE 0
		ID 0 NOTES 1 PART 0 SERIAL_NO 1}
	array set default_WARRANTY_CLAIM {COMPANY_ID {} CUSTOMER 0 STATUS {} CREDIT_REF_NO 0 CUSTOMER_REF {} DATE {0000-00-00 00:00:00}
		ID {} NOTES {} PART 0 SERIAL_NO {}}

	set all_columns(WARRANTY_DETAIL) {AMOUNT COMPANY_ID ID PART QTY RATE TEXT TOTAL
		WARRANTY_ID}
	array set type_WARRANTY_DETAIL {AMOUNT 2 COMPANY_ID 0 ID 1 PART 1 QTY 2 RATE 2
		TEXT 0 TOTAL 2 WARRANTY_ID 1}
	array set null_WARRANTY_DETAIL {AMOUNT 1 COMPANY_ID 0 ID 0 PART 0 QTY 1 RATE 1
		TEXT 1 TOTAL 1 WARRANTY_ID 0}
	array set default_WARRANTY_DETAIL {AMOUNT 0.0 COMPANY_ID {} ID {} PART 0 QTY 0.0 RATE 0.0
		TEXT {} TOTAL 0.0 WARRANTY_ID 0}

	set all_columns(WEB_CONTROL) {COMPANY_ID ID LAST_ORDER_NO LAST_EXPORT_ID LAST_IMPORT}
	array set type_WEB_CONTROL {COMPANY_ID 0 ID 1 LAST_ORDER_NO 1 LAST_EXPORT_ID 1 LAST_IMPORT 3}
	array set null_WEB_CONTROL {COMPANY_ID 1 ID 0 LAST_ORDER_NO 1 LAST_EXPORT_ID 1 LAST_IMPORT 0}
	array set default_WEB_CONTROL {COMPANY_ID {} ID 0 LAST_ORDER_NO 0 LAST_EXPORT_ID 0 LAST_IMPORT {0000-00-00 00:00:00}}

	set all_columns(WEB_SESSION) {COMPANY_ID ID STATUS USER_ID LAST_ACCESS LAST_ACCESS_DATE PAGE_VIEWS AUTHORISATION_USER
		CARD_EXPIRY CARD_NAME CARD_NUMBER CARD_TYPE CHARGE_FREIGHT COURIER_NAME COURIER_REF CUSTOMER_NO
		DELIVERY_ADDRESS DELIVERY_COUNTRY DELIVERY_NAME EMAIL_ADDRESS FAX_NO FIXED_FREIGHT MOBILE_NO NOTIFY_METHOD
		ORDER_FREIGHT ORDER_LIST ORDER_NO ORDER_NO_REQUIRED ORDER_VALUE ORIGINAL_ID PAYMENT_METHOD PHONE_NO
		REMOTE_ADDR SALESMAN SECURITY_OPTIONS SPECIAL_FREIGHT SPECIAL_INSTRUCTIONS USER_NAME WEBSITE DELIVERY_METHOD
		WEB_REFERENCE CONTACT_NAME DELIVERY_AREA HOOK_URL PAYMENT_ENDED PAYMENT_REFERENCE PAYMENT_STARTED TAX_TYPE
		STORE_CODE CONTACT_ADDRESS DELIVERY_POSTCODE SALES_BRANCH SALESPERSON}
	array set type_WEB_SESSION {COMPANY_ID 0 ID 0 STATUS 0 USER_ID 0 LAST_ACCESS 1 LAST_ACCESS_DATE 0
		PAGE_VIEWS 1 AUTHORISATION_USER 0 CARD_EXPIRY 0 CARD_NAME 0 CARD_NUMBER 0 CARD_TYPE 0
		CHARGE_FREIGHT 0 COURIER_NAME 0 COURIER_REF 0 CUSTOMER_NO 1 DELIVERY_ADDRESS 0 DELIVERY_COUNTRY 0
		DELIVERY_NAME 0 EMAIL_ADDRESS 0 FAX_NO 0 FIXED_FREIGHT 2 MOBILE_NO 0 NOTIFY_METHOD 0
		ORDER_FREIGHT 2 ORDER_LIST 0 ORDER_NO 0 ORDER_NO_REQUIRED 0 ORDER_VALUE 2 ORIGINAL_ID 0
		PAYMENT_METHOD 0 PHONE_NO 0 REMOTE_ADDR 0 SALESMAN 0 SECURITY_OPTIONS 0 SPECIAL_FREIGHT 0
		SPECIAL_INSTRUCTIONS 0 USER_NAME 0 WEBSITE 0 DELIVERY_METHOD 0 WEB_REFERENCE 0 CONTACT_NAME 0
		DELIVERY_AREA 0 HOOK_URL 0 PAYMENT_ENDED 0 PAYMENT_REFERENCE 0 PAYMENT_STARTED 0 TAX_TYPE 0
		STORE_CODE 0 CONTACT_ADDRESS 0 DELIVERY_POSTCODE 0 SALES_BRANCH 0 SALESPERSON 0}
	array set null_WEB_SESSION {COMPANY_ID 0 ID 0 STATUS 0 USER_ID 1 LAST_ACCESS 0 LAST_ACCESS_DATE 0
		PAGE_VIEWS 1 AUTHORISATION_USER 1 CARD_EXPIRY 1 CARD_NAME 1 CARD_NUMBER 1 CARD_TYPE 1
		CHARGE_FREIGHT 1 COURIER_NAME 1 COURIER_REF 1 CUSTOMER_NO 1 DELIVERY_ADDRESS 1 DELIVERY_COUNTRY 1
		DELIVERY_NAME 1 EMAIL_ADDRESS 1 FAX_NO 1 FIXED_FREIGHT 1 MOBILE_NO 1 NOTIFY_METHOD 1
		ORDER_FREIGHT 1 ORDER_LIST 1 ORDER_NO 1 ORDER_NO_REQUIRED 1 ORDER_VALUE 1 ORIGINAL_ID 1
		PAYMENT_METHOD 1 PHONE_NO 1 REMOTE_ADDR 1 SALESMAN 1 SECURITY_OPTIONS 1 SPECIAL_FREIGHT 1
		SPECIAL_INSTRUCTIONS 1 USER_NAME 1 WEBSITE 1 DELIVERY_METHOD 1 WEB_REFERENCE 1 CONTACT_NAME 1
		DELIVERY_AREA 1 HOOK_URL 1 PAYMENT_ENDED 1 PAYMENT_REFERENCE 1 PAYMENT_STARTED 1 TAX_TYPE 1
		STORE_CODE 1 CONTACT_ADDRESS 1 DELIVERY_POSTCODE 1 SALES_BRANCH 1 SALESPERSON 1}
	array set default_WEB_SESSION {COMPANY_ID {} ID {} STATUS {} USER_ID {} LAST_ACCESS 0 LAST_ACCESS_DATE {}
		PAGE_VIEWS 0 AUTHORISATION_USER {} CARD_EXPIRY {} CARD_NAME {} CARD_NUMBER {} CARD_TYPE {}
		CHARGE_FREIGHT {} COURIER_NAME {} COURIER_REF {} CUSTOMER_NO 0 DELIVERY_ADDRESS {} DELIVERY_COUNTRY {}
		DELIVERY_NAME {} EMAIL_ADDRESS {} FAX_NO {} FIXED_FREIGHT 0.0 MOBILE_NO {} NOTIFY_METHOD {}
		ORDER_FREIGHT 0.0 ORDER_LIST {} ORDER_NO {} ORDER_NO_REQUIRED {} ORDER_VALUE 0.0 ORIGINAL_ID {}
		PAYMENT_METHOD {} PHONE_NO {} REMOTE_ADDR {} SALESMAN {} SECURITY_OPTIONS {} SPECIAL_FREIGHT {}
		SPECIAL_INSTRUCTIONS {} USER_NAME {} WEBSITE {} DELIVERY_METHOD {} WEB_REFERENCE {} CONTACT_NAME {}
		DELIVERY_AREA {} HOOK_URL {} PAYMENT_ENDED {} PAYMENT_REFERENCE {} PAYMENT_STARTED {} TAX_TYPE {}
		STORE_CODE {} CONTACT_ADDRESS {} DELIVERY_POSTCODE {} SALES_BRANCH {} SALESPERSON {}}

	set all_columns(WEB_USER) {USER_ID COMPANY_ID PASSWORD SALESMAN CUSTOMER_NO AUTHORISATION_USER DELIVERY_ADDRESS DELIVERY_NAME
		EMAIL_ADDRESS FAX_NO MOBILE_NO NOTIFY_METHOD OTHER_AUTHORISER PHONE_NO SECURITY_OPTIONS USER_NAME
		CHARGE_FREIGHT CONTACT_ADDRESS CONTACT_NAME ORDER_NO_REQUIRED SALES_BRANCH SALESPERSON}
	array set type_WEB_USER {USER_ID 0 COMPANY_ID 0 PASSWORD 0 SALESMAN 0 CUSTOMER_NO 1 AUTHORISATION_USER 0
		DELIVERY_ADDRESS 0 DELIVERY_NAME 0 EMAIL_ADDRESS 0 FAX_NO 0 MOBILE_NO 0 NOTIFY_METHOD 0
		OTHER_AUTHORISER 0 PHONE_NO 0 SECURITY_OPTIONS 0 USER_NAME 0 CHARGE_FREIGHT 0 CONTACT_ADDRESS 0
		CONTACT_NAME 0 ORDER_NO_REQUIRED 0 SALES_BRANCH 0 SALESPERSON 0}
	array set null_WEB_USER {USER_ID 0 COMPANY_ID 0 PASSWORD 0 SALESMAN 1 CUSTOMER_NO 0 AUTHORISATION_USER 1
		DELIVERY_ADDRESS 1 DELIVERY_NAME 1 EMAIL_ADDRESS 1 FAX_NO 1 MOBILE_NO 1 NOTIFY_METHOD 1
		OTHER_AUTHORISER 1 PHONE_NO 1 SECURITY_OPTIONS 1 USER_NAME 0 CHARGE_FREIGHT 1 CONTACT_ADDRESS 1
		CONTACT_NAME 1 ORDER_NO_REQUIRED 1 SALES_BRANCH 1 SALESPERSON 1}
	array set default_WEB_USER {USER_ID {} COMPANY_ID {} PASSWORD {} SALESMAN {} CUSTOMER_NO 0 AUTHORISATION_USER {}
		DELIVERY_ADDRESS {} DELIVERY_NAME {} EMAIL_ADDRESS {} FAX_NO {} MOBILE_NO {} NOTIFY_METHOD {}
		OTHER_AUTHORISER {} PHONE_NO {} SECURITY_OPTIONS {} USER_NAME {} CHARGE_FREIGHT {} CONTACT_ADDRESS {}
		CONTACT_NAME {} ORDER_NO_REQUIRED {} SALES_BRANCH {} SALESPERSON {}}

	array set key_unique {ADDITIONAL_CHARGE {{COMPANY_ID REF_NO ACCOUNT INVOICE_NO SEQUENCE}} ALTERNATE_PARTS {{COMPANY_ID PART ALTERNATE_PART}} ALTERNATE_SUPPLIERS {{COMPANY_ID PART SUPPLIER}}
		AREA {{COMPANY_ID AREA_CODE}} AREA_BUDGETS {{COMPANY_ID AREA_CODE YEAR}} ASSET_SCHEDULE {{COMPANY_ID CODE}}
		ASSET_VALUE {{COMPANY_ID ASSET}} AS_MODULE {{COMPANY_ID MODULE}} AUTOMOTIVE_MAKE ID
		AUTOMOTIVE_MODEL ID BALANCE {{COMPANY_ID MODULE ACCOUNT BRANCH YEAR}} BANK_STATEMENT {{COMPANY_ID ACCOUNT PAGE_NO}}
		BANK_STATEMENT_DETAIL {{COMPANY_ID ACCOUNT PAGE_NO REF_NO BATCH_NO REFERENCE}} BATCH {{COMPANY_ID BATCH_NO}} BRANCH {{COMPANY_ID BRANCH_ID}}
		BRANCH_BUDGETS {{COMPANY_ID BRANCH_ID YEAR}} CALL_CYCLE {{COMPANY_ID CYCLE}} CODE_BUDGETS {{COMPANY_ID MODULE CODE YEAR}}
		CODE_DATA {{COMPANY_ID MODULE NUMBER HEADING_ID}} CODE_HEADING ID COMPANY COMPANY_ID
		COMPONENTS {{COMPANY_ID PART COMPONENT}} CONTACT_ROLE {{COMPANY_ID MODULE ID}} COURIER {{COMPANY_ID CODE}}
		COURIER_CONTROL {{TYPE BRANCH COMPANY_ID}} COURIER_DESTINATION {{DESTINATION CITY_CODE BRANCH TYPE COMPANY_ID}} COURIER_PRODUCT {{CODE TYPE COMPANY_ID}}
		COURIER_SERVICE ID COURIER_TICKET_STATUS {{STATUS TYPE COMPANY_ID}} CURRENCY {{BALANCE_CURRENCY CODE}}
		CURRENCY_RATES {{BALANCE_CURRENCY CODE DATE}} CUSTOMER_ADDRESS ID CUSTOMER_CATEGORIES ID
		CUSTOMER_DISCOUNT {{COMPANY_ID CUSTOMER PART}} CUSTOMER_DISCOUNT2 {{CUSTOMER TYPE CODE COMPANY_ID}} CUSTOMER_EXTRAS {{CUSTOMER COMPANY_ID}}
		CUSTOMER_PRICE_BOOK {{CUSTOMER COMPANY_ID}} CUSTOMER_TYPE_DISCOUNT {{COMPANY_ID AR_TYPE IN_TYPE}} DEPT {{COMPANY_ID DEPT_ID}}
		FOLLOW_UP_NOTE {{NOTE_ID SORT_SEQUENCE}} GL_UPDATE {{COMPANY_ID UPDATE_BATCH ACCOUNT HEADER BATCH_NO REF_NO}} INSTRUMENT {{USER_ID COMPANY_ID EVENT_DATE EVENT_NAME}}
		JOB_EQUIPMENT ID JOB_NOTE ID LAYOUT {{COMPANY_ID MODULE LAYOUT}}
		LOG ID MAIN_NOTE ID MARKETING_CODES {{COMPANY_ID MARKETING_CODE}}
		MASTER {{COMPANY_ID MODULE NUMBER} {COMPANY_ID MODULE PART}} MASTER_BUDGETS {{COMPANY_ID MODULE NUMBER YEAR}} MASTER_CODE {{COMPANY_ID MODULE CODE}}
		MASTER_KEYWORD {{COMPANY_ID MODULE NUMBER KEYWORD}} MASTER_SUBTYPE {{MODULE TYPE SUBTYPE COMPANY_ID}} MASTER_TYPE {{COMPANY_ID MODULE TYPE}}
		MISSHIPMENT_HEADER {{REF COMPANY_ID}} MISSHIPMENT_LINE {{REF SORT_SEQUENCE COMPANY_ID}} MISSHIPMENT_NOTE ID
		MODULE_TRAN {{COMPANY_ID TYPE}} NOTES ID ORDER_HEADER {{COMPANY_ID REF}}
		ORDER_LINE {{COMPANY_ID REF SORT_SEQUENCE}} ORDER_LINE_DETAIL {{COMPANY_ID REF SORT_SEQUENCE LINE_NO}} OVERSEAS_ENQUIRY ID
		OVERSEAS_PART ID PACKING_SLIP {{COMPANY_ID PACKING_SLIP}} PART_LABEL ID
		PART_PHRASE {{COMPANY_ID PART PHRASE}} PHONE_NUMBER ID PPP_CONTRACT {{REF COMPANY_ID}}
		PPP_COUNT {{REF DATE COMPANY_ID}} PPP_ITEM {{REF PART COMPANY_ID}} PPP_NOTE ID
		PRICE_CHANGE ID PRICE_CODE {{COMPANY_ID PRICE_CODE}} PRICE_UPDATE_LINE {{COMPANY_ID UPDATE_NO SORT_SEQUENCE}}
		PRINTER ID PRODUCT_AUTOMOTIVE ID PRODUCT_BARCODES {{COMPANY_ID PART}}
		PRODUCT_EXTRAS {{COMPANY_ID PART}} PRODUCT_TYPE_CATEGORY {{COMPANY_ID ID}} PURCHASE_LINE {{COMPANY_ID REF SORT_SEQUENCE}}
		PURCHASE_ORDER {{COMPANY_ID REF}} RETURN_HEADER {{REF COMPANY_ID}} RETURN_LINE {{REF SORT_SEQUENCE COMPANY_ID}}
		RETURN_NOTE ID RE_ORDER {{COMPANY_ID BRANCH TYPE}} SALESMAN_COMMISSION {{COMPANY_ID SALESMAN TYPE}}
		SAVED_REPORT ID SCHEDULED_PRICE_UPDATE {{COMPANY_ID UPDATE_NO}} SERIAL_NUMBER {{COMPANY_ID PART SERIAL_NO}}
		STANDARD_TEXT ID STK_HEADER {{COMPANY_ID REF_NO}} STK_PART {{COMPANY_ID REF_NO PART}}
		STK_SERIAL {{COMPANY_ID REF_NO PART BRANCH SERIAL_NO}} STOCK_PURCHASE {{COMPANY_ID PART BRANCH DATE REF_NO}} STOCK_QTY {{COMPANY_ID PART BRANCH}}
		SUPPLIER_ADDRESS ID SUPPLIER_MARKUP {{SUPPLIER TYPE COMPANY_ID}} SYSTEM LAST_SYSTEM_UPDATE
		TAXI_PIN {{PIN COMPANY_ID}} TAXI_PIN_DATA ID TAXI_VOUCHER {ID REF_NO INVOICE_REF_NO}
		TAXI_ZONE {{CODE COMPANY_ID}} TAX_CODE CODE TICKET {{DISPATCH_NO ITEM_NO}}
		TRAN {{REF_NO SORT_SEQUENCE} {COMPANY_ID MODULE HEADER REF_NO SORT_SEQUENCE}} TRAN_APPLY {{COMPANY_ID REF_NO APPLY_NO}} TRAN_REF {{COMPANY_ID TYPE BRANCH}}
		TRAN_SERIAL {{REF_NO HEADER SORT_SEQUENCE SERIAL_NO PART COMPANY_ID}} TYPE_BUDGETS {{COMPANY_ID MODULE TYPE YEAR}} TYPE_DATA {{NUMBER SEQUENCE MODULE COMPANY_ID}}
		TYPE_HEADING ID USER USER_ID USER_COMPANY {{USER_ID COMPANY_ID}}
		VOUCHER_REGISTER {{FIRST_NUMBER TYPE COMPANY_ID}} WARRANTY_CLAIM ID WARRANTY_DETAIL ID
		WEB_CONTROL ID WEB_SESSION {{COMPANY_ID ID}} WEB_USER USER_ID}

	array set auto_column {ADDITIONAL_CHARGE {} ALTERNATE_PARTS {} ALTERNATE_SUPPLIERS {} AREA {} AREA_BUDGETS {} ASSET_SCHEDULE {}
		ASSET_VALUE {} AS_MODULE {} AUTOMOTIVE_MAKE {} AUTOMOTIVE_MODEL {} BALANCE {} BANK_STATEMENT {}
		BANK_STATEMENT_DETAIL {} BATCH {} BRANCH {} BRANCH_BUDGETS {} CALL_CYCLE {} CODE_BUDGETS {}
		CODE_DATA {} CODE_HEADING ID COMPANY {} COMPONENTS {} CONTACT_ROLE {} COURIER {}
		COURIER_CONTROL {} COURIER_DESTINATION {} COURIER_PRODUCT {} COURIER_SERVICE ID COURIER_TICKET_STATUS {} CURRENCY {}
		CURRENCY_RATES {} CUSTOMER_ADDRESS ID CUSTOMER_CATEGORIES ID CUSTOMER_DISCOUNT {} CUSTOMER_DISCOUNT2 {} CUSTOMER_EXTRAS {}
		CUSTOMER_PRICE_BOOK {} CUSTOMER_TYPE_DISCOUNT {} DEPT {} FOLLOW_UP_NOTE {} GL_UPDATE {} INSTRUMENT {}
		JOB_EQUIPMENT ID JOB_NOTE ID LAYOUT {} LOG ID MAIN_NOTE ID MARKETING_CODES {}
		MASTER {} MASTER_BUDGETS {} MASTER_CODE {} MASTER_KEYWORD {} MASTER_SUBTYPE {} MASTER_TYPE {}
		MISSHIPMENT_HEADER {} MISSHIPMENT_LINE {} MISSHIPMENT_NOTE ID MODULE_TRAN {} NOTES ID ORDER_HEADER {}
		ORDER_LINE {} ORDER_LINE_DETAIL {} OVERSEAS_ENQUIRY ID OVERSEAS_PART ID PACKING_SLIP {} PART_LABEL ID
		PART_PHRASE {} PHONE_NUMBER ID PPP_CONTRACT {} PPP_COUNT {} PPP_ITEM {} PPP_NOTE ID
		PRICE_CHANGE ID PRICE_CODE {} PRICE_UPDATE_LINE {} PRINTER ID PRODUCT_AUTOMOTIVE {} PRODUCT_BARCODES {}
		PRODUCT_EXTRAS {} PRODUCT_TYPE_CATEGORY {} PURCHASE_LINE {} PURCHASE_ORDER {} RETURN_HEADER {} RETURN_LINE {}
		RETURN_NOTE ID RE_ORDER {} SALESMAN_COMMISSION {} SAVED_REPORT ID SCHEDULED_PRICE_UPDATE {} SERIAL_NUMBER {}
		STANDARD_TEXT ID STK_HEADER {} STK_PART {} STK_SERIAL {} STOCK_PURCHASE {} STOCK_QTY {}
		SUPPLIER_ADDRESS ID SUPPLIER_MARKUP {} SYSTEM {} TAXI_PIN {} TAXI_PIN_DATA ID TAXI_VOUCHER ID
		TAXI_ZONE {} TAX_CODE {} TICKET {} TRAN {} TRAN_APPLY {} TRAN_REF {}
		TRAN_SERIAL {} TYPE_BUDGETS {} TYPE_DATA {} TYPE_HEADING ID USER {} USER_COMPANY {}
		VOUCHER_REGISTER {} WARRANTY_CLAIM ID WARRANTY_DETAIL ID WEB_CONTROL {} WEB_SESSION {} WEB_USER {}}

# End namespace
}

