
# Allocate an object tag

namespace eval redis {

# Return true if tag exists in redis
# If object exists, or group exists (type, whole or place zset)
proc tag_exists { tag } {
	set domainTag [command::inherit property {domain}]

	set objectKey [redis::objectkey $domainTag $tag]
	set typeKey [redis::groupkey $domainTag "is" $tag]
	set wholeKey [redis::groupkey $domainTag "of" $tag]
	set placeKey [redis::groupkey $domainTag "in" $tag]

	if {[redis "hlen" $objectKey] > 0} { return 1 }
	if {[redis "zcard" $typeKey] > 0} { return 1 }
	if {[redis "zcard" $wholeKey] > 0} { return 1 }
	if {[redis "zcard" $placeKey] > 0} { return 1 }
	return 0
}

# Return a list of candidate tags (may be empty)
# Doesn't check the tags are actually available
proc candidate_tags { fieldList } {
	variable reservedWord

	set candidates {}
	set separators " \t\n\"\*\/\\\$':#%!@&~+-,.;()\[\]{}<>?=_"
	# Find possible tag from contents of fields
	foreach field $fieldList {
		foreach word [split $field $separators] {
			# Remove any non-alphanumerics
			regsub -all {[^A-Z|a-z|0-9]} $word "" word
			set length [string length $word]
			if {$length < 2 || $length > 15} { continue }

			set word [string tolower $word]
			if {[info exists reservedWord($word)]} { continue }
			lappend candidates $word
		}
	}

	# Query master_keyword table (or a fixed string) ...
	# Order candidates by frequency, rarest first ...
	return $candidates
}

# Return a list of candidate tags that are available (may be empty)
proc available_tags { fieldList } {
	set available {}
	set candidates [candidate_tags $fieldList]
	foreach tag $candidates {
		if {! [tag_exists $tag]} {
			lappend available $tag
		}
	}
	return $available
}

# Reserve the tag is redis, create a zset
# Return true if successful
proc reserve_tag { tag } {
	if {[redis::tag_exists $tag]} { return 0 }

	set domainTag [command::inherit property {domain}]
	set typeKey [redis::groupkey $domainTag "is" $tag]
	redis "zadd" $typeKey 0 $tag
	return 1

	# A lua script could do the following ...
	# Use an integer as a tag
	while {1} {
		set tag [redis "hincrby" $domainKey "tag" 1]
		if {[attempt_tag $domainTag $tag]} {
			return $tag
		}
	}
}

# Reserved words
foreach word {
about above account accounts add adding after again against age agent agents
ago agreement all almost along already also always am among an and another
any are around as asked asset assets at away back balance balances bank
banks based be became become been before began being best better big born
both branch branches brought build business but by call called came can
cannot care carrier carriers case category categories certain change claim
close come common companies company concept confirm consume contact
contacts control cost costs could count course credit credits currency
currencies customer customers date day days death debt debts did different
discount dispatch do document does done down during each early either end
enough entity entities entry entries equity even event events ever every
example exchange expense fact family far few find first five fixed
following for force form found four free from full gave general get give
given go going good got great group groups had half hand hard has have
having he head held help her here high him his home how however idea
identity if in inc individual instance instances into inventory invoice
invoices is it item its itself just keep kind know known land large last
later layout least left less let liability life light like limited line list lists
live loan loans location long longer look lot ltd made main major make
making man many market matter may me means members might minute minutes
money month months more most mr mrs ms much must my name names near need never
new next no not nothing now number numbers object objects of off offer
often old on once one only open option optional or order orders other
others our out over own page pages part party parties past payable payment
payments period person place plan point present price prices priced
process pty purchase put quantity quantities quite quote rather real really
receipt receipts reconcile return returns revalue right said sale sales
same saw say says second seconds see seen service services set several
shall share she short should show side similar since small so some
sometimes soon split st statement status still subject substance substances
such supplier suppliers sure system take taken talk tax tell term terms
than that the their them then there these they thing things think this
those three time times to today together told too took top transaction
transactions transfer transfers true two type types under unique unit
units until up upon us use used user users using usually value values very
views want was way we well went were what when where which while who whole
whose why will with within without word words work works would written
year years yet you your
} { set reservedWord($word) 1 }

}
