
# Redis commands

# ------------------------------------------------------------------------------------

# Generic redis command, explicit arguments
proc redis { args } {
	set result [redis_command $args]
	return $result
}

# Generic redis command, pass argList
proc redis_command { argList } {
	set redisID [command::inherit property {redisID}]

	set id [redis::transmit $redisID $argList]
	set result [redis::receive $redisID $id]
	return $result
}

# ------------------------------------------------------------------------------------
namespace eval redis {

# Set hash fields (in an array) to values
# Do nothing if field array is empty
proc hmset { objectKey fieldName } {
	upvar $fieldName field

	set fieldList [array get field]
	if {[llength $fieldList]} {
		set argList [concat [list "hmset" $objectKey] $fieldList]
		return [redis_command $argList]
	}
	return ""
}

}
