
namespace eval datetime {

# return the current datetime value (YYYY-MM-DD hh::mm::ss)
proc now {} {
	set timeInSeconds [clock seconds]
	return [datetime::datetime $timeInSeconds]
}

# convert time in seconds to datetime format (YYYY-MM-DD hh::mm::ss)
proc datetime { timeInSeconds } {
	set year 	[clock format $timeInSeconds -format "%Y"]
	set month 	[clock format $timeInSeconds -format "%m"]
	set day 	[clock format $timeInSeconds -format "%d"]
	set hour 	[clock format $timeInSeconds -format "%H"]
	set minute 	[clock format $timeInSeconds -format "%M"]
	set second 	[clock format $timeInSeconds -format "%S"]

	return [format "%s-%s-%s %s:%s:%s" $year $month $day $hour $minute $second]
}

# end datetime namespace:
}