
# Country codes and names

namespace eval address {

# Guess the country for an entity (customer, supplier or company)
# Based on the phone number or balance currency
# Return {countryCode countryName mapID}
proc guess_country { phone fax mobile currencyCode } {
	# Extract prefix from phone number
	set result {}
	set number $phone
	if {$number == ""} { set number $fax }
	if {$number == ""} { set number $mobile }
	if {$number != ""} {
		set phoneCode ""
		regexp {\+([0-9]*)} $number all phoneCode
		if {$phoneCode == ""} {
			regexp {^00([0-9]*)} $number all phoneCode
		}
		if {$phoneCode == ""} {
			regexp {^([0-9][0-9])[- ]} $number all phoneCode
		}
		# Lookup country using phone prefix
		set result [per_phone_code $phoneCode]
	}

	# Lookup country using currency code
	if {$result == {}} {
		set result [per_currency $currencyCode]
	}
	if {$result != {}} { return $result }
	return {"" "" "world"}
}

# Lookup country by phoneCode
# Return {countryCode countryName mapID} or empty list
proc per_phone_code { phoneCode } {
	switch -- $phoneCode {
		"1"   { return { "US" "United States" "usa" } }
		"20"  { return { "EG" "Egypt"" "middleeast" } }
		"27"  { return { "ZA" "South Africa" "africa" } }
		"30"  { return { "GR" "Greece" "europe" } }
		"31"  { return { "NL" "Netherlands" "europe" } }
		"32"  { return { "BE" "Belgium" "europe" } }
		"33"  { return { "FR" "France" "europe" } }
		"34"  { return { "ES" "Spain" "europe" } }
		"36"  { return { "HU" "Hungary" "europe" } }
		"39"  { return { "IT" "Italy" "europe" } }
		"40"  { return { "RO" "Romania" "europe" } }
		"41"  { return { "CH" "Switzerland" "europe" } }
		"43"  { return { "AT" "Austria" "europe" } }
		"44"  { return { "GB" "United Kingdom" "uk" } }
		"45"  { return { "DK" "Denmark" "denmark" } }
		"46"  { return { "SE" "Sweden" "europe" } }
		"47"  { return { "NO" "Norway" "europe" } }
		"48"  { return { "PL" "Poland" "europe" } }
		"49"  { return { "DE" "Germany" "germany" } }
		"51"  { return { "PE" "Peru" "samerica" } }
		"52"  { return { "ME" "Mexico" "usa" } }
		"53"  { return { "CU" "Cuba" "usa" } }
		"54"  { return { "AR" "Argentina" "samerica" } }
		"55"  { return { "BR" "Brazil" "samerica" } }
		"56"  { return { "CL" "Chile" "samerica" } }
		"57"  { return { "CO" "Colombia" "samerica" } }
		"58"  { return { "VE" "Venezuela" "samerica" } }
		"60"  { return { "MY" "Malaysia" "asia" } }
		"61"  { return { "AU" "Australia" "australia" } }
		"62"  { return { "ID" "Indonesia" "asia" } }
		"63"  { return { "PH" "Philippines" "asia" } }
		"64"  { return { "NZ" "New Zealand" "nz" } }
		"65"  { return { "SG" "Singapore" "asia" } }
		"66"  { return { "TH" "Thailand" "asia" } }
		"81"  { return { "JP" "Japan" "japan" } }
		"82"  { return { "KR" "South Korea" "asia" } }
		"84"  { return { "VN" "Vietnam" "asia" } }
		"86"  { return { "CN" "China" "china" } }
		"90"  { return { "TR" "Turkey" "middleeast" } }
		"91"  { return { "IN" "India" "india" } }
		"92"  { return { "PK" "Pakistan" "middleeast" } }
		"93"  { return { "AF" "Afghanistan" "middleeast" } }
		"94"  { return { "LK" "Sri Lanka" "india" } }
		"95"  { return { "MM" "Myanmar" "asia" } }
		"98"  { return { "IR" "Iran" "middleeast" } }
		"234" { return { "NG" "Nigeria" "africa" } }
		"351" { return { "PT" "Portugal" "europe" } }
		"358" { return { "FI" "Finland" "europe" } }
		"385" { return { "HR" "Croatia" "europe" } }
		"420" { return { "CZ" "Chech Rebublic" "europe" } }
		"509" { return { "HT" "Haiti" "usa" } }
		"673" { return { "BN" "Brunei" "middleeast" } }
		"675" { return { "PG" "Papua New Guinea" "asia" } }
		"679" { return { "FJ" "Fiji" "nz" } }
		"852" { return { "HK" "Hong Kong" "china" } }
		"853" { return { "MO" "Macau" "china" } }
		"855" { return { "KH" "Cambodia" "asia" } }
		"886" { return { "TW" "Taiwan" "asia" } }
		"964" { return { "IQ" "Iraq" "middleeast" } }
		"966" { return { "SA" "Saudi Arabia" "middleeast" } }
		"967" { return { "YE" "Yemen" "middleeast" } }
		"970" { return { "PS" "State of Palestine" "middleeast" } }
		"971" { return { "AE" "United Arab Emirates" "middleeast" } }
		"972" { return { "IL" "Israel" "middleeast" } }
	}
	return {}
}

# Lookup country by currency code
# Return {countryCode countryName mapID} or empty list
proc per_currency { currencyCode } {
	switch -- $currencyCode {
		"AED" { return { "AE" "United Arab Emirates" "middleeast" } }
		"ARS" { return { "AR" "Argentina" "samerica" } }
		"AU"  { return { "AU" "Australia" "australia" } }
		"AUD" { return { "AU" "Australia" "australia" } }
		"BRL" { return { "BR" "Brazil" "samerica" } }
		"CAD" { return { "CA" "Canada" "usa" } }
		"CLP" { return { "CL" "Chile" "samerica" } }
		"CNY" { return { "CN" "China" "china" } }
		"COP" { return { "CO" "Colombia" "samerica" } }
		"CHF" { return { "CH" "Switzerland" "europe" } }
		"DEM" { return { "DE" "Germany" "germany" } }
		"DKK" { return { "DK" "Denmark" "denmark" } }
		"EGP" { return { "EG" "Egypt"" "middleeast" } }
		"EMU" { return { "" "" "europe" } }
		"EUR" { return { "" "" "europe" } }
		"FRA" { return { "FR" "France" "europe" } }
		"FRF" { return { "FR" "France" "europe" } }
		"GBP" { return { "GB" "United Kingdom" "uk" } }
		"HKD" { return { "HK" "Hong Kong" "china" } }
		"IDR" { return { "ID" "Indonesia" "asia" } }
		"IEP" { return { "GB" "United Kingdom" "uk" } }
		"INR" { return { "IN" "India" "india" } }
		"IQD" { return { "IQ" "Iraq" "middleeast" } }
		"IRR" { return { "IR" "Iran" "middleeast" } }
		"ITL" { return { "IT" "Italy" "europe" } }
		"JPY" { return { "JP" "Japan" "japan" } }
		"KWD" { return { "KW" "Kuwait" "middleeast" } }
		"NZ"  { return { "NZ" "New Zealand" "nz" } }
		"NZD" { return { "NZ" "New Zealand" "nz" } }
		"NLG" { return { "NL" "Netherlands" "europe" } }
		"NOK" { return { "NO" "Norway" "europe" } }
		"PEN" { return { "PE" "Peru" "samerica" } }
		"RMB" { return { "CN" "China" "china" } }
		"SAR" { return { "SA" "Saudi Arabia" "middleeast" } }
		"SEK" { return { "SE" "Sweden" "europe" } }
		"SGD" { return { "SG" "Singapore" "asia" } }
		"STG" { return { "GB" "United Kingdom" "uk" } }
		"UKP" { return { "GB" "United Kingdom" "uk" } }
		"USD" { return { "US" "United States" "usa" } }
		"VEF" { return { "VE" "Venezuela" "samerica" } }
		"YEN" { return { "JP" "Japan" "japan" } }
		"ZAR" { return { "ZA" "South Africa" "africa" } }
	}
	return {}
}

# End address namespace
}
